/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.relay.AzureIdentityTokenProvider;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.SecurityToken;
import com.microsoft.azure.relay.SharedAccessSignatureTokenProvider;
import com.microsoft.azure.relay.StringUtil;
import com.microsoft.azure.relay.TimeoutHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class TokenProvider {
    static final Duration DEFAULT_TOKEN_TIMEOUT = Duration.ofMinutes(60L);

    protected TokenProvider() {
    }

    public static TokenProvider createSharedAccessSignatureTokenProvider(String sharedAccessSignature) {
        return new SharedAccessSignatureTokenProvider(sharedAccessSignature);
    }

    public static TokenProvider createSharedAccessSignatureTokenProvider(String keyName, String sharedAccessKey) {
        return new SharedAccessSignatureTokenProvider(keyName, sharedAccessKey);
    }

    public static TokenProvider createAzureIdentityTokenProvider(TokenCredential tokenCredential) {
        return new AzureIdentityTokenProvider(tokenCredential);
    }

    public CompletableFuture<SecurityToken> getTokenAsync(String urlString, Duration validFor) {
        CompletableFuture<SecurityToken> future = new CompletableFuture<SecurityToken>();
        try {
            if (StringUtil.isNullOrEmpty(urlString)) {
                throw new IllegalArgumentException("Null url provided for security token");
            }
            TimeoutHelper.throwIfNegativeArgument(validFor, "validFor");
            urlString = TokenProvider.normalizeAudience(urlString);
            future = this.onGetTokenAsync(urlString, validFor);
        }
        catch (Exception e) {
            future.completeExceptionally(RelayLogger.throwingException(e, this));
        }
        return future;
    }

    protected abstract CompletableFuture<SecurityToken> onGetTokenAsync(String var1, Duration var2);

    static String normalizeAudience(String audience) throws URISyntaxException {
        String audienceURIString = new URI(audience).normalize().toString();
        return audienceURIString.charAt(audienceURIString.length() - 1) == '/' ? audienceURIString + '/' : audienceURIString;
    }
}

