/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AutoShutdownScheduledExecutor
implements ScheduledExecutorService {
    static final ThreadFactory THREAD_FACTORY = new CustomThreadFactory("autoshutdown");
    private final Object thisLock = new Object();
    private final int corePoolSize;
    private int refCount = 0;
    private ScheduledThreadPoolExecutor innerExecutor;

    AutoShutdownScheduledExecutor(int size) {
        this.corePoolSize = size;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    static AutoShutdownScheduledExecutor Create() {
        return new AutoShutdownScheduledExecutor(Math.max(Runtime.getRuntime().availableProcessors(), 2));
    }

    @Override
    public <T> Future<T> submit(final Callable<T> task) {
        this.incrementRefCount();
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    AutoShutdownScheduledExecutor.this.decrementRefCount();
                }
            }
        };
        return this.innerExecutor.submit(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.incrementRefCount();
        return this.innerExecutor.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.decrementRefCount();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.incrementRefCount();
        return this.innerExecutor.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.decrementRefCount();
            }
        }, result);
    }

    @Override
    public void execute(Runnable command) {
        this.incrementRefCount();
        this.innerExecutor.execute(() -> {
            try {
                command.run();
            }
            finally {
                this.decrementRefCount();
            }
        });
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.incrementRefCount();
        Runnable wrapper = () -> {
            try {
                command.run();
            }
            finally {
                this.decrementRefCount();
            }
        };
        return this.wrapFuture(this.innerExecutor.schedule(wrapper, delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(final Callable<V> callable, long delay, TimeUnit unit) {
        this.incrementRefCount();
        Callable wrapper = new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    AutoShutdownScheduledExecutor.this.decrementRefCount();
                }
            }
        };
        return this.wrapFuture(this.innerExecutor.schedule(wrapper, delay, unit));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementRefCount() {
        Object object = this.thisLock;
        synchronized (object) {
            ++this.refCount;
            if (this.refCount == 1) {
                this.innerExecutor = new ScheduledThreadPoolExecutor(this.corePoolSize, THREAD_FACTORY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementRefCount() {
        ScheduledThreadPoolExecutor executorToShutdown = null;
        Object object = this.thisLock;
        synchronized (object) {
            --this.refCount;
            if (this.refCount == 0) {
                executorToShutdown = this.innerExecutor;
                this.innerExecutor = null;
            }
        }
        if (executorToShutdown != null) {
            executorToShutdown.shutdown();
        }
    }

    private <T> ScheduledFuture<T> wrapFuture(ScheduledFuture<T> schedule) {
        return new CancellableScheduledFuture<T>(schedule);
    }

    private class CancellableScheduledFuture<T>
    implements ScheduledFuture<T> {
        private final ScheduledFuture<T> innerFuture;

        public CancellableScheduledFuture(ScheduledFuture<T> innerFuture) {
            this.innerFuture = innerFuture;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.innerFuture.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.innerFuture.compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelResult = this.innerFuture.cancel(mayInterruptIfRunning);
            if (cancelResult) {
                AutoShutdownScheduledExecutor.this.decrementRefCount();
            }
            return cancelResult;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this.innerFuture.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.innerFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.innerFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.innerFuture.isDone();
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        final String prefix;
        final ThreadFactory innerFactory;

        CustomThreadFactory(String prefix) {
            this.prefix = prefix;
            this.innerFactory = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable paramRunnable) {
            Thread thread = this.innerFactory.newThread(paramRunnable);
            thread.setName(this.prefix + "-" + thread.getName());
            return thread;
        }
    }
}

