/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.TimeoutHelper;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

final class CompletableFutureUtil {
    CompletableFutureUtil() {
    }

    public static boolean isDoneNormally(CompletableFuture<?> cf) {
        return cf != null && cf.isDone() && !cf.isCancelled() && !cf.isCompletedExceptionally();
    }

    public static CompletableFuture<Void> delayAsync(Duration delay, ScheduledExecutorService executor) {
        if (delay == null || delay.isZero() || delay.isNegative()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        executor.schedule(() -> future.complete(null), delay.toMillis(), TimeUnit.MILLISECONDS);
        return future;
    }

    public static <T> CompletableFuture<T> fromException(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static CompletableFuture<Void> timedRunAsync(Duration timeout, Runnable runnable, ScheduledExecutorService executor) {
        return CompletableFutureUtil.futureToCompletableFuture(timeout, runnable, executor);
    }

    public static <T> CompletableFuture<T> timedSupplyAsync(Duration timeout, final Supplier<T> supplier, ScheduledExecutorService executor) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return supplier.get();
            }
        };
        return CompletableFutureUtil.futureToCompletableFuture(timeout, callable, executor);
    }

    private static <T> CompletableFuture<T> futureToCompletableFuture(Duration timeout, Object task, ScheduledExecutorService executor) {
        TimeoutHelper.throwIfNegativeArgument(timeout);
        CompletableFuture taskCF = new CompletableFuture();
        AtomicReference<Object> cancelFuture = new AtomicReference<Object>(null);
        Future<?> taskFuture = executor.submit(() -> {
            Object taskResult = null;
            try {
                if (task instanceof Runnable) {
                    ((Runnable)task).run();
                } else if (task instanceof Callable) {
                    taskResult = ((Callable)task).call();
                }
                taskCF.complete(taskResult);
            }
            catch (Exception e) {
                taskCF.completeExceptionally(e);
            }
            finally {
                if (cancelFuture.get() != null) {
                    ((ScheduledFuture)cancelFuture.get()).cancel(true);
                }
            }
        });
        if (timeout != null) {
            cancelFuture.set(executor.schedule(() -> {
                taskCF.completeExceptionally(new TimeoutException("Could not complete CompletableFuture within the timeout duration."));
                taskFuture.cancel(true);
            }, timeout.toMillis(), TimeUnit.MILLISECONDS));
        }
        return taskCF;
    }
}

