/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.AutoShutdownScheduledExecutor;
import com.microsoft.azure.relay.CompletableFutureUtil;
import com.microsoft.azure.relay.HybridConnectionChannel;
import com.microsoft.azure.relay.HybridConnectionEndpointConfigurator;
import com.microsoft.azure.relay.HybridConnectionUtil;
import com.microsoft.azure.relay.RelayConnectionStringBuilder;
import com.microsoft.azure.relay.RelayConstants;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.RelayTraceSource;
import com.microsoft.azure.relay.SecurityToken;
import com.microsoft.azure.relay.StringUtil;
import com.microsoft.azure.relay.TokenProvider;
import com.microsoft.azure.relay.TrackingContext;
import com.microsoft.azure.relay.WebSocketChannel;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpointConfig;

public class HybridConnectionClient
implements RelayTraceSource {
    static final AutoShutdownScheduledExecutor EXECUTOR = AutoShutdownScheduledExecutor.Create();
    static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(70L);
    static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private String cachedString;
    private TrackingContext trackingContext;
    private URI address;
    private TokenProvider tokenProvider;
    private Duration operationTimeout;

    public HybridConnectionClient(URI address) {
        this.initialize(address, DEFAULT_CONNECTION_TIMEOUT, null, false);
    }

    public HybridConnectionClient(URI address, TokenProvider tokenProvider) {
        this.initialize(address, DEFAULT_CONNECTION_TIMEOUT, tokenProvider, true);
    }

    public HybridConnectionClient(String connectionString) throws URISyntaxException {
        this(connectionString, null, true);
    }

    public HybridConnectionClient(String connectionString, String path) throws URISyntaxException {
        this(connectionString, path, false);
    }

    HybridConnectionClient(String connectionString, String path, boolean pathFromConnectionString) throws URISyntaxException {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalArgumentException("the connection string cannot be null.");
        }
        RelayConnectionStringBuilder builder = new RelayConnectionStringBuilder(connectionString);
        builder.validate();
        if (pathFromConnectionString) {
            if (StringUtil.isNullOrWhiteSpace(builder.getEntityPath())) {
                throw new IllegalArgumentException("entityPath is required in connectionString");
            }
        } else {
            if (StringUtil.isNullOrWhiteSpace(path)) {
                throw new IllegalArgumentException("path is required outside of connectionString");
            }
            if (!StringUtil.isNullOrWhiteSpace(builder.getEntityPath())) {
                throw new IllegalArgumentException("connectionString is not allowed to include EntityPath");
            }
            builder.setEntityPath(path);
        }
        TokenProvider tokenProvider = null;
        if (!StringUtil.isNullOrEmpty(builder.getSharedAccessSignature()) || !StringUtil.isNullOrEmpty(builder.getSharedAccessKeyName())) {
            tokenProvider = builder.createTokenProvider();
        }
        Duration connectTimeout = DEFAULT_CONNECTION_TIMEOUT;
        if (builder.getOperationTimeout() != RelayConstants.DEFAULT_OPERATION_TIMEOUT) {
            connectTimeout = builder.getOperationTimeout();
        }
        this.initialize(new URI(builder.getEndpoint().toString() + builder.getEntityPath()), connectTimeout, tokenProvider, tokenProvider != null);
    }

    public URI getAddress() {
        return this.address;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public TrackingContext getTrackingContext() {
        return this.trackingContext;
    }

    @Override
    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.getClass().getSimpleName() + "(" + this.trackingContext + ")";
        }
        return this.cachedString;
    }

    public CompletableFuture<HybridConnectionChannel> createConnectionAsync() {
        return this.createConnectionAsync(null);
    }

    public CompletableFuture<HybridConnectionChannel> createConnectionAsync(Map<String, List<String>> customHeaders) {
        this.trackingContext = HybridConnectionClient.createTrackingContext(this.address);
        RelayLogger.logEvent("connecting", this, new String[0]);
        String audience = HybridConnectionUtil.getAudience(this.address);
        CompletableFuture<SecurityToken> token = this.tokenProvider.getTokenAsync(audience, TokenProvider.DEFAULT_TOKEN_TIMEOUT);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("ServiceBusAuthorization", Arrays.asList(token.join().getToken()));
        HybridConnectionEndpointConfigurator configurator = new HybridConnectionEndpointConfigurator();
        configurator.addHeaders(headers);
        if (customHeaders != null) {
            configurator.addHeaders(customHeaders);
        }
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        try {
            URI uri = HybridConnectionUtil.buildUri(this.address.getHost(), this.address.getPort(), this.address.getPath(), this.address.getQuery(), "connect", this.trackingContext.getTrackingId());
            WebSocketChannel channel = new WebSocketChannel(this.trackingContext, EXECUTOR);
            return channel.getWebSocket().connectAsync(uri, this.operationTimeout, config).thenApply($void -> channel);
        }
        catch (URISyntaxException e) {
            return CompletableFutureUtil.fromException(e);
        }
    }

    private static TrackingContext createTrackingContext(URI address) {
        String query;
        if (IS_DEBUG && !StringUtil.isNullOrEmpty(query = address.getQuery())) {
            String[] kvps;
            if (query.charAt(0) == '?') {
                query = query.substring(1);
            }
            for (String kvp : kvps = query.split("&")) {
                if (!kvp.startsWith("id=")) continue;
                return TrackingContext.create(kvp.substring(3), address);
            }
        }
        return TrackingContext.create(address);
    }

    private void initialize(URI address, Duration operationTimeout, TokenProvider tokenProvider, boolean tokenProviderRequired) {
        if (address == null) {
            throw RelayLogger.argumentNull("address", this);
        }
        if (!address.getScheme().equals("sb")) {
            throw RelayLogger.throwingException(new IllegalArgumentException("cannot initiate HybridConnection client with invalid uri scheme"), this);
        }
        if (tokenProviderRequired && tokenProvider == null) {
            throw RelayLogger.argumentNull("tokenProvider", this);
        }
        this.address = address;
        this.tokenProvider = tokenProvider;
        this.operationTimeout = operationTimeout;
    }
}

