/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.AsyncLock;
import com.microsoft.azure.relay.AutoShutdownScheduledExecutor;
import com.microsoft.azure.relay.ClientWebSocket;
import com.microsoft.azure.relay.CompletableFutureUtil;
import com.microsoft.azure.relay.ConnectionLostException;
import com.microsoft.azure.relay.EndpointNotFoundException;
import com.microsoft.azure.relay.HybridConnectionChannel;
import com.microsoft.azure.relay.HybridConnectionEndpointConfigurator;
import com.microsoft.azure.relay.HybridConnectionUtil;
import com.microsoft.azure.relay.HybridHttpConnection;
import com.microsoft.azure.relay.InputQueue;
import com.microsoft.azure.relay.ListenerCommand;
import com.microsoft.azure.relay.RelayConnectionStringBuilder;
import com.microsoft.azure.relay.RelayConstants;
import com.microsoft.azure.relay.RelayException;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.RelayTraceSource;
import com.microsoft.azure.relay.RelayedHttpListenerContext;
import com.microsoft.azure.relay.SecurityToken;
import com.microsoft.azure.relay.StringUtil;
import com.microsoft.azure.relay.TimeoutHelper;
import com.microsoft.azure.relay.TokenProvider;
import com.microsoft.azure.relay.TokenRenewer;
import com.microsoft.azure.relay.TraceLevel;
import com.microsoft.azure.relay.TrackingContext;
import com.microsoft.azure.relay.WebSocketChannel;
import com.microsoft.azure.relay.WriteMode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.json.JSONObject;

public class HybridConnectionListener
implements RelayTraceSource,
AutoCloseable {
    static final AutoShutdownScheduledExecutor EXECUTOR = AutoShutdownScheduledExecutor.Create();
    private final InputQueue<HybridConnectionChannel> connectionInputQueue;
    private final ControlConnection controlConnection;
    private final Object thisLock = new Object();
    private final AtomicBoolean openCalled;
    private final AtomicBoolean closeCalled;
    private Duration operationTimeout;
    private int maxWebSocketBufferSize;
    private String cachedString;
    private Function<RelayedHttpListenerContext, Boolean> acceptHandler;
    private Consumer<RelayedHttpListenerContext> requestHandler;
    private URI address;
    private TrackingContext trackingContext;
    private TokenProvider tokenProvider;
    private Throwable injectedFault;
    private Consumer<Throwable> connectingHandler;
    private Consumer<Throwable> offlineHandler;
    private Runnable onlineHandler;

    public HybridConnectionListener(URI address, TokenProvider tokenProvider) {
        if (address == null || tokenProvider == null) {
            throw RelayLogger.argumentNull("address or tokenProvider", this);
        }
        if (!address.getScheme().equals("sb")) {
            throw RelayLogger.throwingException(new IllegalArgumentException("Invalid scheme. Expected: sb, Actual: " + address.getScheme() + "."), this);
        }
        this.address = address;
        this.tokenProvider = tokenProvider;
        this.operationTimeout = RelayConstants.DEFAULT_OPERATION_TIMEOUT;
        this.trackingContext = TrackingContext.create(this.address);
        this.connectionInputQueue = new InputQueue(EXECUTOR);
        this.controlConnection = new ControlConnection(this);
        this.openCalled = new AtomicBoolean(false);
        this.closeCalled = new AtomicBoolean(false);
    }

    public HybridConnectionListener(String connectionString) throws URISyntaxException {
        this(connectionString, null, true);
    }

    public HybridConnectionListener(String connectionString, String path) throws URISyntaxException {
        this(connectionString, path, false);
    }

    HybridConnectionListener(String connectionString, String path, boolean pathFromConnectionString) throws URISyntaxException {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw RelayLogger.argumentNull("connectionString", this);
        }
        RelayConnectionStringBuilder builder = new RelayConnectionStringBuilder(connectionString);
        builder.validate();
        if (pathFromConnectionString) {
            if (StringUtil.isNullOrWhiteSpace(builder.getEntityPath())) {
                throw RelayLogger.argumentNull("entityPath", this);
            }
        } else {
            if (StringUtil.isNullOrWhiteSpace(path)) {
                throw RelayLogger.argumentNull("path", this);
            }
            if (!StringUtil.isNullOrWhiteSpace(builder.getEntityPath())) {
                throw RelayLogger.throwingException(new IllegalArgumentException("EntityPath must not appear in connectionString"), this);
            }
            builder.setEntityPath(path);
        }
        this.address = new URI(builder.getEndpoint() + builder.getEntityPath());
        this.tokenProvider = builder.createTokenProvider();
        this.operationTimeout = builder.getOperationTimeout();
        this.trackingContext = TrackingContext.create(this.address);
        this.connectionInputQueue = new InputQueue(EXECUTOR);
        this.controlConnection = new ControlConnection(this);
        this.openCalled = new AtomicBoolean(false);
        this.closeCalled = new AtomicBoolean(false);
    }

    public boolean isOnline() {
        return this.controlConnection.isOnline();
    }

    public Function<RelayedHttpListenerContext, Boolean> getAcceptHandler() {
        return this.acceptHandler;
    }

    public void setAcceptHandler(Function<RelayedHttpListenerContext, Boolean> acceptHandler) {
        this.acceptHandler = acceptHandler;
    }

    public Consumer<RelayedHttpListenerContext> getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(Consumer<RelayedHttpListenerContext> requestHandler) {
        this.requestHandler = requestHandler;
    }

    public URI getAddress() {
        return this.address;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @Override
    public TrackingContext getTrackingContext() {
        return this.trackingContext;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getMaxWebSocketBufferSize() {
        return this.maxWebSocketBufferSize;
    }

    public void setMaxWebSocketBufferSize(int maxWebSocketBufferSize) {
        if (maxWebSocketBufferSize > 0) {
            this.maxWebSocketBufferSize = maxWebSocketBufferSize;
        } else {
            RelayLogger.logEvent("objectNotSet", this, "maxWebSocketBufferSize");
        }
    }

    public Consumer<Throwable> getConnectingHandler() {
        return this.connectingHandler;
    }

    public void setConnectingHandler(Consumer<Throwable> onConnecting) {
        this.connectingHandler = onConnecting;
    }

    public Consumer<Throwable> getOfflineHandler() {
        return this.offlineHandler;
    }

    public void setOfflineHandler(Consumer<Throwable> onOffline) {
        this.offlineHandler = onOffline;
    }

    public Runnable getOnlineHandler() {
        return this.onlineHandler;
    }

    public void setOnlineHandler(Runnable onOnline) {
        this.onlineHandler = onOnline;
    }

    public CompletableFuture<Void> openAsync() {
        return this.openAsync(this.operationTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> openAsync(Duration timeout) {
        TimeoutHelper.throwIfNegativeArgument(timeout);
        Object object = this.thisLock;
        synchronized (object) {
            try {
                this.throwIfDisposed();
                this.throwIfReadOnly();
            }
            catch (RelayException e) {
                return CompletableFutureUtil.fromException(e);
            }
            this.openCalled.set(true);
        }
        return this.controlConnection.openAsync(timeout);
    }

    public CompletableFuture<Void> closeAsync() {
        return this.closeAsync(this.operationTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync(Duration timeout) {
        CompletableFuture[] closeTasks;
        TimeoutHelper timeoutHelper = new TimeoutHelper(timeout);
        Object object = this.thisLock;
        synchronized (object) {
            if (this.closeCalled.get()) {
                return CompletableFuture.completedFuture(null);
            }
            RelayLogger.logEvent("closing", this, new String[0]);
            this.closeCalled.set(true);
            this.connectionInputQueue.shutdown();
            closeTasks = new CompletableFuture[this.connectionInputQueue.getPendingCount()];
            for (int i = 0; i < this.connectionInputQueue.getPendingCount(); ++i) {
                closeTasks[i] = this.connectionInputQueue.dequeueAsync(timeoutHelper.remainingTime()).thenAccept(connection -> connection.closeAsync(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Client closing the socket normally")));
            }
        }
        return ((CompletableFuture)CompletableFuture.allOf(closeTasks).thenCompose($void -> this.controlConnection.closeAsync(timeoutHelper.remainingTime()))).whenComplete(($void, ex) -> {
            this.connectionInputQueue.dispose();
            RelayLogger.logEvent("closed", this, new String[0]);
            if (ex != null) {
                throw RelayLogger.throwingException(ex, this);
            }
        });
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<HybridConnectionChannel> acceptConnectionAsync() {
        CompletableFuture<HybridConnectionChannel> connection = null;
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.openCalled.get()) {
                throw RelayLogger.invalidOperation("cannot accept connection because listener is not open.", this);
            }
            connection = this.connectionInputQueue.dequeueAsync();
        }
        return connection;
    }

    @Override
    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.getClass().getSimpleName() + "(" + this.trackingContext + ")";
        }
        return this.cachedString;
    }

    CompletableFuture<Void> sendControlCommandAndStreamAsync(ListenerCommand command, ByteBuffer buffer, Duration timeout) {
        return this.controlConnection.sendCommandAndStreamAsync(command, buffer, timeout);
    }

    void throwIfDisposed() throws RelayException {
        if (this.closeCalled.get()) {
            throw RelayLogger.invalidOperation("Invalid operation. Cannot call open when it's already closed.", this);
        }
    }

    void throwIfReadOnly() throws RelayException {
        if (this.openCalled.get()) {
            throw RelayLogger.invalidOperation("Invalid operation. Cannot call open when it's already open.", this);
        }
    }

    private CompletableFuture<Void> onCommandAsync(String message, ClientWebSocket controlWebSocket) throws URISyntaxException, UnsupportedEncodingException {
        JSONObject jsonObj = new JSONObject(message);
        ListenerCommand listenerCommand = new ListenerCommand(jsonObj);
        ListenerCommand.AcceptCommand accept = listenerCommand.getAccept();
        ListenerCommand.RequestCommand request = listenerCommand.getRequest();
        if (accept != null) {
            return CompletableFuture.completedFuture(accept).thenComposeAsync(acceptCommand -> this.onAcceptCommandAsync((ListenerCommand.AcceptCommand)acceptCommand), (Executor)EXECUTOR);
        }
        if (request != null) {
            return HybridHttpConnection.createAsync(this, request, controlWebSocket);
        }
        return CompletableFutureUtil.fromException(new IllegalArgumentException("Invalid HybridConnection command was received."));
    }

    private CompletableFuture<Void> onAcceptCommandAsync(ListenerCommand.AcceptCommand acceptCommand) {
        try {
            URI rendezvousUri = new URI(acceptCommand.getAddress());
            URI requestUri = this.generateAcceptRequestUri(rendezvousUri);
            RelayedHttpListenerContext listenerContext = new RelayedHttpListenerContext(this, requestUri, acceptCommand.getId(), "GET", acceptCommand.getConnectHeaders());
            listenerContext.getRequest().setRemoteEndPoint(acceptCommand.getRemoteEndpoint());
            Function<RelayedHttpListenerContext, Boolean> acceptHandler = this.acceptHandler;
            boolean shouldAccept = acceptHandler == null;
            RelayLogger.logEvent("rendezvousStart", this, acceptCommand.getAddress());
            if (acceptHandler != null) {
                try {
                    shouldAccept = acceptHandler.apply(listenerContext);
                }
                catch (Exception userException) {
                    listenerContext.getResponse().setStatusCode(502);
                    listenerContext.getResponse().setStatusDescription("The Listener's custom AcceptHandler threw an exception. See Listener logs for details. TrackingId: " + listenerContext.getTrackingContext().getTrackingId());
                    throw RelayLogger.throwingException(userException, this);
                }
            }
            return this.completeAcceptAsync(listenerContext, rendezvousUri, shouldAccept);
        }
        catch (Exception exception) {
            RelayLogger.logEvent("rendezvousFailed", this, exception.toString());
            RelayLogger.logEvent("rendezVousStop", this, new String[0]);
            return CompletableFutureUtil.fromException(exception);
        }
    }

    private URI generateAcceptRequestUri(URI rendezvousUri) throws URISyntaxException, UnsupportedEncodingException {
        String query = HybridConnectionUtil.filterQueryString(rendezvousUri.getQuery());
        String path = rendezvousUri.getPath();
        path = path.startsWith("$hc/") ? path.substring(4) : path;
        URI address = this.address;
        return new URI(address.getScheme(), address.getUserInfo(), address.getHost(), address.getPort(), path, query, address.getFragment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> completeAcceptAsync(RelayedHttpListenerContext listenerContext, URI rendezvousUri, boolean shouldAccept) {
        CompletionStage<Object> completeAcceptTask = new CompletableFuture();
        if (shouldAccept) {
            Object object = this.thisLock;
            synchronized (object) {
                WebSocketChannel rendezvousConnection = new WebSocketChannel(listenerContext.getTrackingContext(), EXECUTOR);
                if (this.closeCalled.get()) {
                    RelayLogger.logEvent("rendezvousClose", this, rendezvousUri.toString());
                    completeAcceptTask = CompletableFuture.completedFuture(null);
                } else {
                    completeAcceptTask = rendezvousConnection.getWebSocket().connectAsync(rendezvousUri).thenRun(() -> this.connectionInputQueue.enqueueAndDispatch(rendezvousConnection, null, false));
                }
            }
        } else {
            RelayLogger.logEvent("rendezvousRejected", this, String.valueOf(listenerContext.getResponse().getStatusCode()), listenerContext.getResponse().getStatusDescription());
            completeAcceptTask = listenerContext.rejectAsync(rendezvousUri);
        }
        return completeAcceptTask.whenComplete((result, ex) -> {
            if (ex != null) {
                throw RelayLogger.throwingException(ex, this);
            }
            RelayLogger.logEvent("rendezvousStop", this, new String[0]);
        });
    }

    void clearFault() {
        this.injectedFault = null;
    }

    void injectFault(Throwable throwable) {
        CompletableFuture controlConnectionTask;
        if (throwable == null) {
            return;
        }
        if (throwable instanceof UpgradeException) {
            this.injectedFault = throwable;
        }
        if (throwable instanceof ConnectionLostException && (controlConnectionTask = this.controlConnection.connectAsyncTask) != null) {
            controlConnectionTask.thenAccept(webSocket -> webSocket.dispose());
        }
    }

    final class ControlConnection
    implements AutoCloseable {
        private final HybridConnectionListener listener;
        private final URI address;
        private String path;
        private final TokenRenewer tokenRenewer;
        private final AsyncLock sendAsyncLock;
        private final Object thisLock = new Object();
        private CompletableFuture<ClientWebSocket> connectAsyncTask;
        private AtomicInteger connectDelayIndex;
        private AtomicBoolean closeCalled;
        private Throwable lastError;

        ControlConnection(HybridConnectionListener listener) {
            this.listener = listener;
            this.address = listener.address;
            String rawPath = this.address.getPath();
            this.path = rawPath.startsWith("/") ? rawPath.substring(1) : rawPath;
            this.sendAsyncLock = new AsyncLock(EXECUTOR);
            this.connectDelayIndex = new AtomicInteger(0);
            this.closeCalled = new AtomicBoolean(false);
            this.tokenRenewer = new TokenRenewer(this.listener, this.address.toString(), TokenProvider.DEFAULT_TOKEN_TIMEOUT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isOnline() {
            Object object = this.thisLock;
            synchronized (object) {
                return CompletableFutureUtil.isDoneNormally(this.connectAsyncTask) && this.connectAsyncTask.join().isOpen();
            }
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        public CompletableFuture<Void> openAsync(Duration timeout) {
            CompletableFuture<ClientWebSocket> connectTask = this.ensureConnectTask(timeout);
            return ((CompletableFuture)connectTask.thenAccept(webSocket -> {
                this.tokenRenewer.setOnTokenRenewed(token -> this.onTokenRenewed((SecurityToken)token));
                this.receivePumpAsync();
            })).whenComplete(($void, err) -> {
                if (err != null) {
                    RelayLogger.throwingException(err, this.listener);
                    CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "closing web socket connection because something went wrong trying to connect.");
                    this.closeOrAbortWebSocketAsync(connectTask, closeReason);
                    throw new CompletionException((Throwable)err);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Void> closeAsync(Duration duration) {
            CompletableFuture<ClientWebSocket> connectTask;
            Object object = this.thisLock;
            synchronized (object) {
                if (this.closeCalled.get()) {
                    return CompletableFuture.completedFuture(null);
                }
                this.closeCalled.set(true);
                connectTask = this.connectAsyncTask;
                this.connectAsyncTask = null;
            }
            this.tokenRenewer.close();
            if (connectTask != null) {
                return connectTask.thenCompose(webSocket -> this.sendAsyncLock.acquireThenCompose(duration, () -> {
                    CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Normal Closure");
                    return webSocket.closeAsync(reason);
                }));
            }
            return CompletableFuture.completedFuture(null);
        }

        private CompletableFuture<Void> sendCommandAndStreamAsync(ListenerCommand command, ByteBuffer buffer, Duration timeout) {
            return this.ensureConnectTask(timeout).thenCompose(webSocket -> this.sendAsyncLock.acquireThenCompose(timeout, () -> {
                String json = null;
                if (command.getResponse() != null) {
                    json = command.getResponse().toJsonString();
                } else if (command.getRenewToken() != null) {
                    json = command.getRenewToken().toJsonString();
                }
                if (json != null) {
                    RelayLogger.logEvent("sendCommand", this, json);
                    return webSocket.writeAsync(json, timeout, true, WriteMode.TEXT).thenCompose($void -> {
                        if (buffer != null) {
                            return webSocket.writeAsync(buffer);
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                }
                return CompletableFutureUtil.fromException(new IllegalArgumentException("Invalid command to be sent by the listener to the cloud service"));
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<ClientWebSocket> ensureConnectTask(Duration timeout) {
            Object object = this.thisLock;
            synchronized (object) {
                if (this.connectAsyncTask == null || !this.isOnline()) {
                    this.connectAsyncTask = this.connectAsync(timeout);
                }
                return this.connectAsyncTask;
            }
        }

        private CompletableFuture<ClientWebSocket> connectAsync(Duration timeout) {
            try {
                this.listener.throwIfDisposed();
                CompletableFuture<Void> delayTask = CompletableFutureUtil.delayAsync(RelayConstants.CONNECTION_DELAY_INTERVALS[this.connectDelayIndex.get()], EXECUTOR);
                CompletableFuture<SecurityToken> token = this.tokenRenewer.getTokenAsync();
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                headers.put("ServiceBusAuthorization", Arrays.asList(token.join().getToken()));
                HybridConnectionEndpointConfigurator configurator = new HybridConnectionEndpointConfigurator();
                configurator.addHeaders(headers);
                ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
                String trackingId = TrackingContext.removeSuffix(this.listener.trackingContext.getTrackingId());
                URI websocketUri = HybridConnectionUtil.buildUri(this.address.getHost(), this.address.getPort(), this.address.getPath(), this.address.getQuery(), "listen", trackingId);
                ClientWebSocket webSocket = new ClientWebSocket(this.listener.trackingContext, EXECUTOR);
                return delayTask.thenCompose($void -> {
                    if (this.listener.injectedFault != null && this.listener.injectedFault instanceof UpgradeException) {
                        return CompletableFutureUtil.fromException(this.listener.injectedFault);
                    }
                    return webSocket.connectAsync(websocketUri, timeout, config).thenApply($void2 -> {
                        this.onOnline();
                        return webSocket;
                    });
                });
            }
            catch (Throwable e) {
                return CompletableFutureUtil.fromException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Void> closeOrAbortWebSocketAsync(CompletableFuture<ClientWebSocket> connectTask, CloseReason reason) {
            assert (CompletableFutureUtil.isDoneNormally(connectTask));
            Object object = this.thisLock;
            synchronized (object) {
                if (connectTask == this.connectAsyncTask) {
                    this.connectAsyncTask = null;
                }
            }
            return ((CompletableFuture)connectTask.thenCompose(webSocket -> webSocket.closeAsync(reason))).exceptionally(exception -> {
                RelayLogger.handledExceptionAsWarning(exception, this.listener);
                return null;
            });
        }

        @Override
        public void close() {
            this.closeAsync(RelayConstants.DEFAULT_OPERATION_TIMEOUT).join();
        }

        private CompletableFuture<Void> receivePumpAsync() {
            return this.receivePumpCoreAsync().handle((keepGoing, ex) -> {
                if (keepGoing.booleanValue()) {
                    this.receivePumpAsync();
                } else {
                    if (ex != null) {
                        RelayLogger.throwingException(ex, this, TraceLevel.WARNING);
                    }
                    this.onOffline((Throwable)ex);
                }
                return null;
            });
        }

        private CompletableFuture<Boolean> receivePumpCoreAsync() {
            CompletableFuture<ClientWebSocket> connectTask = this.ensureConnectTask(null);
            return ((CompletableFuture)connectTask.handle((webSocket, ex) -> {
                if (ex != null) {
                    this.lastError = ex;
                    return null;
                }
                return webSocket;
            })).thenCompose(webSocket -> {
                if (webSocket == null || !webSocket.isOpen()) {
                    return CompletableFuture.completedFuture(this.onDisconnect(this.lastError));
                }
                return webSocket.readTextAsync().thenApply(receivedMessage -> {
                    boolean keepGoing = true;
                    try {
                        if (!webSocket.isOpen()) {
                            this.closeOrAbortWebSocketAsync(connectTask, webSocket.getCloseReason());
                            if (this.closeCalled.get()) {
                                keepGoing = false;
                            } else {
                                CloseReason reason = webSocket.getCloseReason();
                                keepGoing = this.onDisconnect(new ConnectionLostException(reason.toString()));
                            }
                            return keepGoing;
                        }
                        if (receivedMessage != null) {
                            this.listener.onCommandAsync(receivedMessage, webSocket);
                        }
                    }
                    catch (Exception exception) {
                        RelayLogger.handledExceptionAsWarning(exception, this.listener);
                        this.closeOrAbortWebSocketAsync(connectTask, null);
                        keepGoing = this.onDisconnect(exception);
                    }
                    return keepGoing;
                });
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onOnline() {
            Object object = this.thisLock;
            synchronized (object) {
                if (this.isOnline()) {
                    return;
                }
                this.lastError = null;
                this.connectDelayIndex.set(-1);
            }
            RelayLogger.logEvent("connected", this.listener, new String[0]);
            Runnable onlineHandler = this.listener.getOnlineHandler();
            if (onlineHandler != null) {
                onlineHandler.run();
            }
        }

        private void onOffline(Throwable lastError) {
            if (lastError != null) {
                this.lastError = lastError;
            }
            RelayLogger.logEvent("offline", this, new String[0]);
            Consumer<Throwable> offlineHandler = this.listener.getOfflineHandler();
            if (offlineHandler != null) {
                offlineHandler.accept(lastError);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onDisconnect(Throwable lastError) {
            Consumer<Throwable> connectingHandler;
            Object object = this.thisLock;
            synchronized (object) {
                this.lastError = lastError;
                this.connectDelayIndex.updateAndGet(index -> index < RelayConstants.CONNECTION_DELAY_INTERVALS.length - 1 ? ++index : index);
            }
            boolean shouldReconnect = this.shouldReconnect(lastError);
            RelayLogger.logEvent("disconnect", this, String.valueOf(shouldReconnect));
            if (shouldReconnect && (connectingHandler = this.listener.getConnectingHandler()) != null) {
                connectingHandler.accept(lastError);
            }
            return shouldReconnect;
        }

        private boolean shouldReconnect(Throwable exception) {
            return !(exception instanceof EndpointNotFoundException);
        }

        private void onTokenRenewed(SecurityToken token) {
            ListenerCommand listenerCommand;
            ListenerCommand listenerCommand2 = listenerCommand = new ListenerCommand(null);
            Objects.requireNonNull(listenerCommand2);
            listenerCommand.setRenewToken(new ListenerCommand.RenewTokenCommand(listenerCommand2, null));
            listenerCommand.getRenewToken().setToken(token.toString());
            this.sendCommandAndStreamAsync(listenerCommand, null, null).exceptionally(ex -> {
                RelayLogger.throwingException(ex, this.listener, TraceLevel.WARNING);
                return null;
            });
        }
    }
}

