/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.AsyncLock;
import com.microsoft.azure.relay.AutoShutdownScheduledExecutor;
import com.microsoft.azure.relay.ClientWebSocket;
import com.microsoft.azure.relay.CompletableFutureUtil;
import com.microsoft.azure.relay.HybridConnectionListener;
import com.microsoft.azure.relay.HybridConnectionUtil;
import com.microsoft.azure.relay.ListenerCommand;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.RelayTraceSource;
import com.microsoft.azure.relay.RelayedHttpListenerContext;
import com.microsoft.azure.relay.RelayedHttpListenerResponse;
import com.microsoft.azure.relay.RequestCommandAndStream;
import com.microsoft.azure.relay.TimeoutHelper;
import com.microsoft.azure.relay.TraceLevel;
import com.microsoft.azure.relay.TrackingContext;
import com.microsoft.azure.relay.WriteMode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.websocket.CloseReason;
import org.eclipse.jetty.util.URIUtil;
import org.json.JSONObject;

class HybridHttpConnection
implements RelayTraceSource {
    private static final int MAX_CONTROL_CONNECTION_BODY_SIZE = 65536;
    private final AutoShutdownScheduledExecutor executor;
    private final HybridConnectionListener listener;
    private final ClientWebSocket controlWebSocket;
    private final URI rendezvousAddress;
    private ClientWebSocket rendezvousWebSocket;
    private TrackingContext trackingContext;
    private ListenerCommand.RequestCommand requestCommand;
    private String cachedString;

    private HybridHttpConnection(HybridConnectionListener listener, ClientWebSocket controlWebSocket, String rendezvousAddress, AutoShutdownScheduledExecutor executor) throws URISyntaxException {
        this.executor = executor;
        this.listener = listener;
        this.controlWebSocket = controlWebSocket;
        this.rendezvousAddress = new URI(rendezvousAddress);
        this.trackingContext = this.getNewTrackingContext();
        RelayLogger.logEvent("httpRequestStarting", this, new String[0]);
    }

    @Override
    public TrackingContext getTrackingContext() {
        return this.trackingContext;
    }

    public Duration getOperationTimeout() {
        return this.listener.getOperationTimeout();
    }

    static CompletableFuture<Void> createAsync(HybridConnectionListener listener, ListenerCommand.RequestCommand requestCommand, ClientWebSocket controlWebSocket) {
        HybridHttpConnection hybridHttpConnection;
        try {
            hybridHttpConnection = new HybridHttpConnection(listener, controlWebSocket, requestCommand.getAddress(), HybridConnectionListener.EXECUTOR);
        }
        catch (URISyntaxException e) {
            return CompletableFutureUtil.fromException(e);
        }
        Boolean requestOverControlConnection = requestCommand.hasBody();
        CompletableFuture<RequestCommandAndStream> requestAndStreamFuture = requestOverControlConnection != null && requestOverControlConnection == true ? hybridHttpConnection.receiveRequestBodyOverControlAsync(requestCommand) : CompletableFuture.completedFuture(new RequestCommandAndStream(requestCommand, null));
        return requestAndStreamFuture.thenComposeAsync(requestAndStream -> hybridHttpConnection.processFirstRequestAsync((RequestCommandAndStream)requestAndStream), (Executor)HybridConnectionListener.EXECUTOR);
    }

    @Override
    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.getClass().getSimpleName() + "(" + this.trackingContext + ")";
        }
        return this.cachedString;
    }

    private TrackingContext getNewTrackingContext() throws URISyntaxException {
        Map<String, String> queryParameters = HybridConnectionUtil.parseQueryString(this.rendezvousAddress.getQuery());
        String trackingId = queryParameters.get("sb-hc-id");
        String path = this.rendezvousAddress.getPath();
        if (path.startsWith("/$hc")) {
            path = path.substring("/$hc".length());
        }
        URI logicalAddress = new URI("https", this.listener.getAddress().getHost(), path, null);
        return TrackingContext.create(trackingId, logicalAddress);
    }

    private CompletableFuture<Void> processFirstRequestAsync(RequestCommandAndStream requestAndStream) {
        CompletionStage<Object> processTask = new CompletableFuture();
        ListenerCommand.RequestCommand requestCommand = requestAndStream.getRequestCommand();
        processTask = requestCommand.hasBody() == null ? this.receiveRequestOverRendezvousAsync().thenAccept(realRequestAndStream -> this.invokeRequestHandler((RequestCommandAndStream)realRequestAndStream)) : CompletableFuture.runAsync(() -> this.invokeRequestHandler(requestAndStream));
        return ((CompletableFuture)((CompletableFuture)processTask).handle((result, ex) -> ex)).thenCompose(ex -> {
            if (ex != null) {
                return CompletableFutureUtil.fromException(RelayLogger.throwingException(ex, this, TraceLevel.WARNING));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<RequestCommandAndStream> receiveRequestBodyOverControlAsync(ListenerCommand.RequestCommand requestCommand) {
        ByteArrayInputStream requestStream = null;
        if (requestCommand.hasBody().booleanValue()) {
            return this.controlWebSocket.readBinaryAsync().thenApply(receivedData -> new RequestCommandAndStream(requestCommand, new ByteArrayInputStream(receivedData.array())));
        }
        return CompletableFuture.completedFuture(new RequestCommandAndStream(requestCommand, requestStream));
    }

    private CompletableFuture<RequestCommandAndStream> receiveRequestOverRendezvousAsync() throws CompletionException {
        return ((CompletableFuture)((CompletableFuture)this.ensureRendezvousAsync(this.getOperationTimeout()).thenCompose(rendezvousResult -> this.rendezvousWebSocket.readTextAsync())).thenCompose(commandJson -> {
            JSONObject jsonObj = new JSONObject(commandJson);
            this.requestCommand = new ListenerCommand(jsonObj).getRequest();
            if (this.requestCommand != null && this.requestCommand.hasBody().booleanValue()) {
                RelayLogger.logEvent("httpReadRendezvous", this, "request body");
                return this.rendezvousWebSocket.readBinaryAsync();
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(buffer -> new RequestCommandAndStream(this.requestCommand, new ByteArrayInputStream(buffer.array())));
    }

    void invokeRequestHandler(RequestCommandAndStream requestAndStream) {
        Consumer<RelayedHttpListenerContext> requestHandler;
        ListenerCommand.RequestCommand requestCommand = requestAndStream.getRequestCommand();
        URI listenerAddress = this.listener.getAddress();
        String requestTarget = requestCommand.getRequestTarget();
        URI requestUri = null;
        try {
            requestUri = HybridHttpConnection.parseAndEncodeRequestUri(listenerAddress, requestTarget);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RelayedHttpListenerContext listenerContext = new RelayedHttpListenerContext(this.listener, requestUri, requestCommand.getId(), requestCommand.getMethod(), requestCommand.getRequestHeaders());
        listenerContext.getRequest().setRemoteEndPoint(requestCommand.getRemoteEndpoint());
        listenerContext.getResponse().setStatusCode(200);
        listenerContext.getResponse().setOutputStream(new ResponseStream(this, listenerContext));
        RelayLogger.logEvent("httpRequestReceived", this, requestCommand.getMethod());
        ByteArrayInputStream requestStream = requestAndStream.getStream();
        if (requestStream != null) {
            listenerContext.getRequest().setHasEntityBody(true);
            listenerContext.getRequest().setInputStream(requestStream);
        }
        if ((requestHandler = this.listener.getRequestHandler()) != null) {
            try {
                RelayLogger.logEvent("httpInvokeUserHandler", this, new String[0]);
                requestHandler.accept(listenerContext);
            }
            catch (Exception userException) {
                RelayLogger.throwingException(userException, this);
                listenerContext.getResponse().setStatusCode(500);
                listenerContext.getResponse().setStatusDescription("The listener RequestHandler threw an exception. See listener logs for more details.");
                listenerContext.getResponse().close();
                return;
            }
        } else {
            RelayLogger.logEvent("httpMissingRequestHandler", this, new String[0]);
            listenerContext.getResponse().setStatusCode(501);
            listenerContext.getResponse().setStatusDescription("The listener RequestHandler has not been configured.");
            listenerContext.getResponse().close();
        }
    }

    static URI parseAndEncodeRequestUri(URI listenerAddress, String requestTarget) throws URISyntaxException {
        String listenerAddressStr = listenerAddress.toString();
        String requestTargetWithoutConnectionName = requestTarget.replaceFirst(listenerAddress.getPath(), "");
        if (requestTargetWithoutConnectionName.startsWith("/")) {
            requestTargetWithoutConnectionName = requestTargetWithoutConnectionName.replaceFirst("/", "");
        }
        CharSequence[] pathAndQuery = requestTargetWithoutConnectionName.split("\\?", 2);
        pathAndQuery[0] = URIUtil.encodePath((String)pathAndQuery[0]);
        URI requestUri = new URI(listenerAddressStr + "/" + String.join((CharSequence)"?", pathAndQuery));
        return requestUri;
    }

    private CompletableFuture<Void> sendResponseAsync(ListenerCommand.ResponseCommand responseCommand, ByteBuffer responseBodyBuffer, Duration timeout) throws CompletionException {
        if (this.rendezvousWebSocket == null) {
            RelayLogger.logEvent("httpSendResponse", this, "control", String.valueOf(responseCommand.getStatusCode()));
            ListenerCommand listenerCommand = new ListenerCommand(null);
            listenerCommand.setResponse(responseCommand);
            return this.listener.sendControlCommandAndStreamAsync(listenerCommand, responseBodyBuffer, timeout).thenRun(() -> RelayLogger.logEvent("httpSendResponseFinished", this, "control", String.valueOf(responseCommand.getStatusCode())));
        }
        TimeoutHelper timeRemaining = new TimeoutHelper(timeout);
        RelayLogger.logEvent("httpSendResponse", this, "rendezvous", String.valueOf(responseCommand.getStatusCode()));
        ListenerCommand listenerCommand = new ListenerCommand(null);
        listenerCommand.setResponse(responseCommand);
        String command = listenerCommand.getResponse().toJsonString();
        CompletionStage sendCommandTask = ((CompletableFuture)this.ensureRendezvousAsync(timeRemaining.remainingTime()).thenCompose($void -> this.rendezvousWebSocket.writeAsync(command, timeRemaining.remainingTime(), true, WriteMode.TEXT))).thenAccept(bytesWritten -> RelayLogger.logEvent("httpSendResponseFinished", this, "rendezvous", String.valueOf(responseCommand.getStatusCode())));
        if (responseCommand.hasBody() && responseBodyBuffer != null) {
            return ((CompletableFuture)sendCommandTask).thenCompose($void -> {
                int bytesToWrite = responseBodyBuffer.remaining();
                return this.sendBytesOverRendezvousAsync(responseBodyBuffer, timeRemaining.remainingTime()).thenRun(() -> RelayLogger.logEvent("httpSendingBytes", this, String.valueOf(bytesToWrite)));
            });
        }
        return sendCommandTask;
    }

    private CompletableFuture<Void> sendBytesOverRendezvousAsync(ByteBuffer buffer, Duration timeout) {
        if (buffer == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.rendezvousWebSocket.writeAsync(buffer, timeout, false, WriteMode.BINARY).thenAccept(nullResult -> RelayLogger.logEvent("httpSendingBytes", this, String.valueOf(buffer.remaining())));
    }

    private CompletableFuture<Void> ensureRendezvousAsync(Duration timeout) throws CompletionException {
        if (this.rendezvousWebSocket == null) {
            RelayLogger.logEvent("httpCreateRendezvous", this, new String[0]);
            this.rendezvousWebSocket = new ClientWebSocket(this.trackingContext, this.executor);
            return this.rendezvousWebSocket.connectAsync(this.rendezvousAddress, timeout);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> closeRendezvousAsync() {
        if (this.rendezvousWebSocket != null) {
            RelayLogger.logEvent("closing", this, new String[0]);
            return this.rendezvousWebSocket.closeAsync(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "NormalClosure")).thenRun(() -> RelayLogger.logEvent("closed", this, new String[0]));
        }
        return CompletableFuture.completedFuture(null);
    }

    static ListenerCommand.ResponseCommand createResponseCommand(RelayedHttpListenerContext listenerContext) {
        RelayedHttpListenerResponse response = listenerContext.getResponse();
        ListenerCommand listenerCommand = new ListenerCommand(null);
        ListenerCommand.ResponseCommand responseCommand = new ListenerCommand.ResponseCommand(listenerCommand);
        responseCommand.setStatusCode(response.getStatusCode());
        responseCommand.setStatusDescription(response.getStatusDescription());
        responseCommand.setRequestId(listenerContext.getTrackingContext().getTrackingId());
        response.getHeaders().forEach((key, val) -> responseCommand.getResponseHeaders().put((String)key, (String)val));
        return responseCommand;
    }

    public final class ResponseStream
    extends OutputStream {
        static final long WRITE_BUFFER_FLUSH_TIMEOUT_MILLIS = 2000L;
        private final HybridHttpConnection connection;
        private final RelayedHttpListenerContext context;
        private final AsyncLock asyncLock;
        private boolean closed;
        private ByteBuffer writeBufferStream;
        private Timer writeBufferFlushTimer;
        private boolean responseCommandSent;
        private final TrackingContext trackingContext;
        private Duration writeTimeout;

        ResponseStream(HybridHttpConnection connection, RelayedHttpListenerContext context) {
            this.connection = connection;
            this.context = context;
            this.trackingContext = context.getTrackingContext();
            this.writeTimeout = this.connection.getOperationTimeout();
            this.asyncLock = new AsyncLock(HybridConnectionListener.EXECUTOR);
        }

        public TrackingContext getTrackingContext() {
            return this.trackingContext;
        }

        public Duration getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        @Override
        public void flush() throws IOException {
        }

        CompletableFuture<Void> flushCoreAsync(FlushReason reason, Duration timeout) throws CompletionException {
            RelayLogger.logEvent("httpResponseStreamFlush", this, reason.toString());
            TimeoutHelper timeoutHelper = new TimeoutHelper(timeout);
            if (!this.responseCommandSent) {
                ListenerCommand.ResponseCommand responseCommand = HybridHttpConnection.createResponseCommand(this.context);
                responseCommand.setBody(true);
                CompletionStage sendResponseTask = ((CompletableFuture)this.connection.ensureRendezvousAsync(timeoutHelper.remainingTime()).thenComposeAsync($void -> this.connection.sendResponseAsync(responseCommand, null, timeoutHelper.remainingTime()))).thenRun(() -> {
                    this.responseCommandSent = true;
                });
                if (this.writeBufferStream != null && this.writeBufferStream.position() > 0) {
                    return ((CompletableFuture)((CompletableFuture)sendResponseTask).thenCompose($void -> {
                        this.writeBufferStream.flip();
                        return this.connection.sendBytesOverRendezvousAsync(this.writeBufferStream, timeoutHelper.remainingTime());
                    })).thenRun(() -> {
                        this.writeBufferStream.clear();
                        if (this.writeBufferFlushTimer != null) {
                            this.writeBufferFlushTimer.cancel();
                        }
                    });
                }
                return sendResponseTask;
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.writeAsync(b, off, len).join();
            }
            catch (CompletionException e) {
                throw new IOException(e.getCause());
            }
        }

        public CompletableFuture<Void> writeAsync(byte[] b, int off, int len) {
            RelayLogger.logEvent("httpResponseStreamWrite", this, String.valueOf(len));
            this.context.getResponse().setReadonly();
            return this.asyncLock.acquireThenCompose(this.writeTimeout, () -> {
                CompletableFuture<Object> flushCoreTask = null;
                if (!this.responseCommandSent) {
                    FlushReason flushReason;
                    if (this.connection.rendezvousWebSocket != null) {
                        flushReason = FlushReason.RENDEZVOUS_EXISTS;
                    } else {
                        int bufferedCount;
                        int n = bufferedCount = this.writeBufferStream != null ? this.writeBufferStream.position() : 0;
                        if (len + bufferedCount <= 65536) {
                            if (this.writeBufferStream == null) {
                                this.writeBufferStream = ByteBuffer.allocate(65536);
                                this.writeBufferFlushTimer = new Timer();
                                this.writeBufferFlushTimer.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        ResponseStream.this.onWriteBufferFlushTimer();
                                    }
                                }, 2000L, Long.MAX_VALUE);
                            }
                            this.writeBufferStream.put(b, off, len);
                            return CompletableFuture.completedFuture(null);
                        }
                        flushReason = FlushReason.BUFFER_FULL;
                    }
                    flushCoreTask = this.flushCoreAsync(flushReason, this.writeTimeout);
                }
                ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
                if (flushCoreTask == null) {
                    flushCoreTask = CompletableFuture.completedFuture(null);
                }
                return flushCoreTask.thenCompose(result -> this.connection.sendBytesOverRendezvousAsync(buffer, this.writeTimeout));
            });
        }

        public String toString() {
            return this.connection.toString() + "+ResponseStream";
        }

        @Override
        public void close() throws IOException {
            try {
                this.closeAsync().join();
            }
            catch (CompletionException e) {
                throw new IOException(e.getCause());
            }
        }

        public CompletableFuture<Void> closeAsync() {
            if (this.closed) {
                return CompletableFuture.completedFuture(null);
            }
            RelayLogger.logEvent("closing", this, new String[0]);
            return this.asyncLock.acquireThenCompose(this.writeTimeout, () -> {
                CompletableFuture sendTask = null;
                if (!this.responseCommandSent) {
                    ListenerCommand.ResponseCommand responseCommand = HybridHttpConnection.createResponseCommand(this.context);
                    if (this.writeBufferStream != null) {
                        responseCommand.setBody(true);
                        this.writeBufferStream.flip();
                    }
                    sendTask = this.connection.sendResponseAsync(responseCommand, this.writeBufferStream, this.writeTimeout);
                    this.responseCommandSent = true;
                    if (this.writeBufferFlushTimer != null) {
                        this.writeBufferFlushTimer.cancel();
                    }
                } else {
                    sendTask = this.connection.sendBytesOverRendezvousAsync(null, this.writeTimeout);
                }
                return sendTask.thenCompose(result -> {
                    if (this.writeBufferStream != null) {
                        this.writeBufferStream.position(0);
                    }
                    this.closed = true;
                    return HybridHttpConnection.this.closeRendezvousAsync();
                });
            });
        }

        CompletableFuture<Void> onWriteBufferFlushTimer() {
            return this.asyncLock.acquireThenCompose(this.writeTimeout, () -> this.flushCoreAsync(FlushReason.TIMER, this.writeTimeout));
        }
    }

    private static enum FlushReason {
        BUFFER_FULL,
        RENDEZVOUS_EXISTS,
        TIMER;

    }
}

