/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.RelayConstants;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.StringUtil;
import com.microsoft.azure.relay.TimeoutHelper;
import com.microsoft.azure.relay.TokenProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;

public class RelayConnectionStringBuilder {
    static final String ENDPOINT_CONFIG_NAME = "Endpoint";
    static final String ENTITY_PATH_CONFIG_NAME = "EntityPath";
    static final String OPERATION_TIMEOUT_CONFIG_NAME = "OperationTimeout";
    static final String SHARED_ACCESS_KEYNAME_CONFIG_NAME = "SharedAccessKeyName";
    static final String SHARED_ACCESS_KEY_CONFIG_NAME = "SharedAccessKey";
    static final String SHARED_ACCESS_SIGNATURE_CONFIG_NAME = "SharedAccessSignature";
    static final char KEY_VALUE_SEPARATOR = '=';
    static final char KEY_VALUE_PAIR_DELIMITER = ';';
    private URI endpoint;
    private Duration operationTimeout = RelayConstants.DEFAULT_OPERATION_TIMEOUT;
    private String entityPath;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String sharedAccessSignature;

    public RelayConnectionStringBuilder() {
    }

    public RelayConnectionStringBuilder(String connectionString) {
        this();
        if (StringUtil.isNullOrEmpty(connectionString)) {
            throw new IllegalArgumentException("connectionString cannot be null or empty");
        }
        this.parseConnectionString(connectionString);
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI value) {
        if (value == null) {
            throw new IllegalArgumentException("the supplied endpoint endpoint cannot be null");
        }
        if (!value.isAbsolute()) {
            throw new IllegalArgumentException("the supplied endpoint must be an absolute uri");
        }
        this.endpoint = value;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Duration timeout) {
        TimeoutHelper.throwIfNegativeArgument(timeout);
        this.operationTimeout = timeout;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public void setSharedAccessKeyName(String sharedAccessKeyName) {
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public void setSharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
    }

    public String toString() {
        this.validate();
        StringBuilder connectionStringBuilder = new StringBuilder(200);
        connectionStringBuilder.append("Endpoint=" + this.endpoint + ';');
        if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
            connectionStringBuilder.append("EntityPath=" + this.entityPath + ';');
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
            connectionStringBuilder.append("SharedAccessKeyName=" + this.sharedAccessKeyName + ';');
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
            connectionStringBuilder.append("SharedAccessKey=" + this.sharedAccessKey + ';');
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessSignature)) {
            connectionStringBuilder.append("SharedAccessSignature=" + this.sharedAccessSignature + ';');
        }
        if (this.operationTimeout != RelayConstants.DEFAULT_OPERATION_TIMEOUT) {
            connectionStringBuilder.append("OperationTimeout=" + this.operationTimeout.getSeconds() + ';');
        }
        return connectionStringBuilder.toString();
    }

    protected TokenProvider createTokenProvider() {
        TokenProvider tokenProvider = null;
        if (!StringUtil.isNullOrEmpty(this.sharedAccessSignature)) {
            tokenProvider = TokenProvider.createSharedAccessSignatureTokenProvider(this.sharedAccessSignature);
        } else if (!StringUtil.isNullOrEmpty(this.sharedAccessKeyName) && !StringUtil.isNullOrEmpty(this.sharedAccessKey)) {
            tokenProvider = TokenProvider.createSharedAccessSignatureTokenProvider(this.sharedAccessKeyName, this.sharedAccessKey);
        } else {
            throw new IllegalArgumentException("need to supply sharedAccessSignature or both sharedAccessKeyName and sharedAccessKey");
        }
        return tokenProvider;
    }

    protected void validate() {
        boolean hasSharedAccessSignature;
        if (this.endpoint == null) {
            throw new IllegalArgumentException("provided endpoint cannot be null");
        }
        boolean hasSharedAccessKeyName = !StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName);
        boolean hasSharedAccessKey = !StringUtil.isNullOrWhiteSpace(this.sharedAccessKey);
        boolean bl = hasSharedAccessSignature = !StringUtil.isNullOrWhiteSpace(this.sharedAccessSignature);
        if (hasSharedAccessSignature) {
            if (hasSharedAccessKeyName) {
                throw new IllegalArgumentException("sharedAccessKeyName should not be supplied when sharedAccessSignture is supplied.");
            }
            if (hasSharedAccessKey) {
                throw new IllegalArgumentException("sharedAccessKey should not be supplied when sharedAccessSignture is supplied.");
            }
        } else if (hasSharedAccessKeyName && !hasSharedAccessKey || !hasSharedAccessKeyName && hasSharedAccessKey) {
            throw new IllegalArgumentException("sharedAccessKeyName and sharedAccessKey should be both supplied when sharedAccessSignture is not supplied.");
        }
    }

    private void parseConnectionString(String connectionString) {
        String[] keyValuePairs;
        for (String keyValuePair : keyValuePairs = connectionString.split(String.valueOf(';'))) {
            if (StringUtil.isNullOrEmpty(keyValuePair)) continue;
            String[] keyAndValue = keyValuePair.split(String.valueOf('='), 2);
            if (keyAndValue.length != 2) {
                throw new IllegalArgumentException("invalid key value pair in connection string");
            }
            String key = keyAndValue[0];
            String value = keyAndValue[1];
            if (key.equalsIgnoreCase(ENDPOINT_CONFIG_NAME)) {
                URI endpoint;
                try {
                    endpoint = new URI(value);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("The following string cannot be used to build a valid URI: " + e.getInput());
                }
                if (!endpoint.isAbsolute()) {
                    throw new IllegalArgumentException("The following string must be a valid absolute URI: " + endpoint);
                }
                this.endpoint = endpoint;
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH_CONFIG_NAME)) {
                this.entityPath = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEYNAME_CONFIG_NAME)) {
                this.sharedAccessKeyName = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_CONFIG_NAME)) {
                this.sharedAccessKey = value;
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_SIGNATURE_CONFIG_NAME)) {
                this.sharedAccessSignature = value;
                continue;
            }
            if (key.equalsIgnoreCase(OPERATION_TIMEOUT_CONFIG_NAME)) {
                try {
                    this.operationTimeout = Duration.ofSeconds(Long.parseLong(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw RelayLogger.throwingException(e, this);
                }
            }
            throw new IllegalArgumentException("the following is not a valid field for connection string: " + key);
        }
    }
}

