/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.ClientWebSocket;
import com.microsoft.azure.relay.CompletableFutureUtil;
import com.microsoft.azure.relay.HybridConnectionListener;
import com.microsoft.azure.relay.RelayTraceSource;
import com.microsoft.azure.relay.RelayedHttpListenerRequest;
import com.microsoft.azure.relay.RelayedHttpListenerResponse;
import com.microsoft.azure.relay.StringUtil;
import com.microsoft.azure.relay.TrackingContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RelayedHttpListenerContext
implements RelayTraceSource {
    private static final Duration ACCEPT_TIMEOUT = Duration.ofSeconds(20L);
    private String cachedToString;
    private final RelayedHttpListenerRequest request;
    private final RelayedHttpListenerResponse response;
    private final TrackingContext trackingContext;
    private final HybridConnectionListener listener;

    RelayedHttpListenerContext(HybridConnectionListener listener, URI requestUri, String trackingId, String method, Map<String, String> requestHeaders) {
        this.listener = listener;
        this.trackingContext = TrackingContext.create(trackingId, requestUri);
        this.request = new RelayedHttpListenerRequest(requestUri, method, requestHeaders);
        this.response = new RelayedHttpListenerResponse(this);
        this.flowSubProtocol();
    }

    public RelayedHttpListenerRequest getRequest() {
        return this.request;
    }

    public RelayedHttpListenerResponse getResponse() {
        return this.response;
    }

    @Override
    public TrackingContext getTrackingContext() {
        return this.trackingContext;
    }

    public HybridConnectionListener getListener() {
        return this.listener;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        this.cachedToString = "RelayedHttpListenerContext(" + this.trackingContext + ")";
        return this.cachedToString;
    }

    CompletableFuture<ClientWebSocket> acceptAsync(URI rendezvousUri) {
        ClientWebSocket webSocket = new ClientWebSocket(this.trackingContext, HybridConnectionListener.EXECUTOR);
        return webSocket.connectAsync(rendezvousUri, ACCEPT_TIMEOUT).thenApply(result -> webSocket);
    }

    CompletableFuture<Void> rejectAsync(URI rendezvousUri) {
        if (this.response.getStatusCode() == 100) {
            this.response.setStatusCode(400);
            this.response.setStatusDescription("Rejected by user code");
        }
        try {
            StringBuilder builder = new StringBuilder(rendezvousUri.toString());
            builder.append("&").append("sb-hc-statusCode").append("=").append(this.response.getStatusCode());
            builder.append("&").append("sb-hc-statusDescription").append("=").append(URLEncoder.encode(this.response.getStatusDescription(), StringUtil.UTF8.name()));
            URI rejectURI = new URI(builder.toString());
            ClientWebSocket webSocket = new ClientWebSocket(this.trackingContext, HybridConnectionListener.EXECUTOR);
            return webSocket.connectAsync(rejectURI, ACCEPT_TIMEOUT).thenCompose(result -> webSocket.closeAsync());
        }
        catch (IOException | URISyntaxException e) {
            return CompletableFutureUtil.fromException(e);
        }
    }

    private void flowSubProtocol() {
        String subProtocol = this.request.getHeaders().get("Sec-WebSocket-Protocol");
        if (!StringUtil.isNullOrEmpty(subProtocol)) {
            int separatorIndex = subProtocol.indexOf(44);
            if (separatorIndex >= 0) {
                subProtocol = subProtocol.substring(0, separatorIndex);
            }
            this.response.getHeaders().put("Sec-WebSocket-Protocol", subProtocol);
        }
    }
}

