/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.HybridHttpConnection;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.RelayedHttpListenerContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpStatus;

public class RelayedHttpListenerResponse {
    private final Map<String, String> headers;
    private final RelayedHttpListenerContext context;
    private boolean disposed;
    private boolean readonly;
    private int statusCode;
    private String statusDescription;
    private HybridHttpConnection.ResponseStream outputStream;

    RelayedHttpListenerResponse(RelayedHttpListenerContext context) {
        this.context = context;
        this.statusCode = 100;
        this.headers = new ResponseHeaderCollection();
        this.outputStream = null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statuscode) {
        this.checkClosedOrReadonly();
        if (statuscode < 100 || statuscode > 999) {
            throw RelayLogger.throwingException(new IllegalArgumentException("http status code must be between 100 and 999."), this.context);
        }
        this.statusCode = statuscode;
    }

    public String getStatusDescription() {
        if (this.statusDescription == null) {
            this.statusDescription = HttpStatus.getMessage((int)this.statusCode) != null ? HttpStatus.getMessage((int)this.statusCode) : null;
        }
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.checkClosedOrReadonly();
        if (statusDescription == null) {
            throw RelayLogger.throwingException(new IllegalArgumentException("cannot set a null statusDecription."), this.context);
        }
        for (int i = 0; i < statusDescription.length(); ++i) {
            char c = statusDescription.charAt(i);
            if ((c > '\u001f' || c == '\t') && c < '\u007f') continue;
            throw RelayLogger.throwingException(new IllegalArgumentException("status description should not contain any control characters."), this.context);
        }
        this.statusDescription = statusDescription;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HybridHttpConnection.ResponseStream getOutputStream() {
        return this.outputStream;
    }

    void setOutputStream(HybridHttpConnection.ResponseStream outputStream) {
        this.outputStream = outputStream;
    }

    public RelayedHttpListenerContext getContext() {
        return this.context;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.outputStream != null) {
            return this.outputStream.closeAsync().whenComplete(($void, ex) -> {
                this.disposed = true;
            });
        }
        this.disposed = true;
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
        this.closeAsync().join();
    }

    void setReadonly() {
        this.readonly = true;
    }

    private void checkClosedOrReadonly() {
        Exception ex = null;
        if (this.disposed) {
            ex = new IOException("The HTTP status code, status description, and headers cannot be modified after the output stream has already been closed.");
        } else if (this.readonly) {
            ex = new IllegalStateException("The HTTP status code, status description, and headers cannot be modified after writing to the output.");
        }
        if (ex != null) {
            throw RelayLogger.throwingException(ex, this.context);
        }
    }

    public class ResponseHeaderCollection
    extends HashMap<String, String> {
        private static final long serialVersionUID = -4334547975481290294L;

        @Override
        public String put(String key, String value) {
            RelayedHttpListenerResponse.this.checkClosedOrReadonly();
            return super.put(key, value);
        }

        @Override
        public String remove(Object key) {
            RelayedHttpListenerResponse.this.checkClosedOrReadonly();
            return (String)super.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            RelayedHttpListenerResponse.this.checkClosedOrReadonly();
            super.putAll(m);
        }

        @Override
        public void clear() {
            RelayedHttpListenerResponse.this.checkClosedOrReadonly();
            super.clear();
        }
    }
}

