/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.HybridConnectionUtil;
import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.StringUtil;
import java.net.URI;
import java.time.Instant;
import java.util.UUID;

public class TrackingContext {
    private static final UUID UUID_ZERO = new UUID(0L, 0L);
    private static final int UUID_STRING_LENGTH = UUID_ZERO.toString().length();
    static final String TRACKING_ID_NAME = "TrackingId";
    static final String ADDRESS_NAME = "Address";
    static final String TIMESTAMP_NAME = "Timestamp";
    private String cachedToString;
    private UUID activityId;
    private String trackingId;
    private String address;

    private TrackingContext(UUID activityId, String trackingId, String address) {
        this.activityId = activityId;
        this.trackingId = trackingId;
        this.address = address;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getAddress() {
        return this.address;
    }

    static TrackingContext create() {
        return TrackingContext.create(UUID.randomUUID(), (String)null);
    }

    static TrackingContext create(URI address) {
        return TrackingContext.create(UUID.randomUUID(), HybridConnectionUtil.getAudience(address));
    }

    static TrackingContext create(UUID activityId, String address) {
        return TrackingContext.create(activityId, activityId.toString(), address);
    }

    static TrackingContext create(String trackingId, URI address) {
        return TrackingContext.create(trackingId, HybridConnectionUtil.getAudience(address));
    }

    static TrackingContext create(String trackingId, String address) {
        boolean parseFailed = false;
        UUID activityId = UUID.fromString(trackingId.substring(0, Math.min(UUID_STRING_LENGTH, trackingId.length())));
        if (activityId.equals(UUID_ZERO)) {
            parseFailed = true;
            activityId = UUID.randomUUID();
        }
        TrackingContext trackingContext = TrackingContext.create(activityId, trackingId, address);
        if (parseFailed) {
            RelayLogger.logEvent("parsingUUIDFailed", trackingContext, trackingId, activityId.toString());
        }
        return trackingContext;
    }

    static TrackingContext create(UUID activityId, URI address) {
        return TrackingContext.create(activityId, activityId.toString(), address);
    }

    static TrackingContext create(UUID activityId, String trackingId, URI address) {
        return TrackingContext.create(activityId, trackingId, address.toString());
    }

    static TrackingContext create(UUID activityId, String trackingId, String address) {
        return new TrackingContext(activityId, trackingId, address);
    }

    static String removeSuffix(String trackingId) {
        int roleSuffixIndex = trackingId.indexOf("_");
        if (roleSuffixIndex == -1) {
            return trackingId;
        }
        return trackingId.substring(0, roleSuffixIndex);
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = StringUtil.isNullOrEmpty(this.address) ? "TrackingId:" + this.trackingId : "TrackingId:" + this.trackingId + ", " + ADDRESS_NAME + ":" + this.address;
        }
        return this.cachedToString;
    }

    String ensureTrackableMessage(String exceptionMessage) {
        if (StringUtil.isNullOrEmpty(exceptionMessage) || exceptionMessage.indexOf(TRACKING_ID_NAME) == -1) {
            if (!StringUtil.isNullOrEmpty(exceptionMessage) && !exceptionMessage.endsWith(".")) {
                exceptionMessage = exceptionMessage + ".";
            }
            return exceptionMessage + " " + this.createClientTrackingExceptionInfo();
        }
        return exceptionMessage;
    }

    String createClientTrackingExceptionInfo() {
        return this.createClientTrackingExceptionInfo(Instant.now());
    }

    String createClientTrackingExceptionInfo(Instant timestamp) {
        return StringUtil.isNullOrWhiteSpace(this.address) ? "TrackingId:" + this.trackingId + ", " + TIMESTAMP_NAME + ":" + timestamp : "TrackingId:" + this.trackingId + ", " + ADDRESS_NAME + ":" + this.address + ", " + TIMESTAMP_NAME + ":" + timestamp;
    }
}

