/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.AutoShutdownScheduledExecutor;
import com.microsoft.azure.relay.ClientWebSocket;
import com.microsoft.azure.relay.HybridConnectionChannel;
import com.microsoft.azure.relay.TrackingContext;
import com.microsoft.azure.relay.WriteMode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.websocket.CloseReason;

public class WebSocketChannel
implements HybridConnectionChannel {
    private final ClientWebSocket websocket;
    private final TrackingContext trackingContext;

    WebSocketChannel(TrackingContext trackingContext, AutoShutdownScheduledExecutor executor) {
        this(new ClientWebSocket(trackingContext, executor), trackingContext);
    }

    WebSocketChannel(ClientWebSocket websocket, TrackingContext trackingContext) {
        this.websocket = websocket;
        this.trackingContext = trackingContext;
    }

    @Override
    public TrackingContext getTrackingContext() {
        return this.trackingContext;
    }

    ClientWebSocket getWebSocket() {
        return this.websocket;
    }

    @Override
    public boolean isOpen() {
        return this.websocket.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.websocket.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.websocket.closeAsync();
    }

    @Override
    public CompletableFuture<Void> closeAsync(CloseReason reason) {
        return this.websocket.closeAsync(reason);
    }

    public CompletableFuture<String> readTextAsync() {
        return this.websocket.readTextAsync();
    }

    @Override
    public CompletableFuture<ByteBuffer> readAsync() {
        return this.websocket.readBinaryAsync();
    }

    @Override
    public CompletableFuture<ByteBuffer> readAsync(Duration timeout) {
        return this.websocket.readBinaryAsync(timeout);
    }

    @Override
    public CompletableFuture<Void> writeAsync(ByteBuffer data) {
        return this.websocket.writeAsync(data);
    }

    @Override
    public CompletableFuture<Void> writeAsync(ByteBuffer data, Duration timeout) {
        return this.websocket.writeAsync(data, timeout);
    }

    public CompletableFuture<Void> writeTextAsync(String textData, Duration timeout) {
        return this.websocket.writeAsync(textData, timeout, true, WriteMode.TEXT);
    }

    CompletableFuture<Void> writeAsync(Object data, Duration timeout, boolean isEnd, WriteMode mode) {
        return this.websocket.writeAsync(data, timeout, isEnd, mode);
    }
}

