/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.experimental.models.MessageWithMetadata;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.KafkaAvroDeserializerConfig;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaAvroDeserializer<T extends IndexedRecord>
implements Deserializer<T> {
    private SchemaRegistryApacheAvroSerializer serializer;
    private KafkaAvroDeserializerConfig config;

    public void configure(Map<String, ?> props, boolean isKey) {
        this.config = new KafkaAvroDeserializerConfig(props);
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryAsyncClient(new SchemaRegistryClientBuilder().fullyQualifiedNamespace(this.config.getSchemaRegistryUrl()).credential(this.config.getCredential()).buildAsyncClient()).avroSpecificReader(this.config.getAvroSpecificReader().booleanValue()).buildSerializer();
    }

    public T deserialize(String topic, byte[] bytes) {
        return null;
    }

    public T deserialize(String topic, Headers headers, byte[] bytes) {
        MessageWithMetadata message = new MessageWithMetadata();
        message.setBodyAsBinaryData(BinaryData.fromBytes((byte[])bytes));
        Header contentTypeHeader = headers.lastHeader("content-type");
        if (contentTypeHeader != null) {
            message.setContentType(new String(contentTypeHeader.value()));
        } else {
            message.setContentType("");
        }
        return (T)((IndexedRecord)this.serializer.deserializeMessageData(message, TypeReference.createInstance(this.config.getAvroSpecificType())));
    }

    public void close() {
    }
}

