/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.experimental.models.MessageWithMetadata;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.KafkaAvroSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer<T>
implements Serializer<T> {
    private SchemaRegistryApacheAvroSerializer serializer;

    public void configure(Map<String, ?> props, boolean isKey) {
        KafkaAvroSerializerConfig config = new KafkaAvroSerializerConfig(props);
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryAsyncClient(new SchemaRegistryClientBuilder().fullyQualifiedNamespace(config.getSchemaRegistryUrl()).credential(config.getCredential()).buildAsyncClient()).schemaGroup(config.getSchemaGroup()).autoRegisterSchema(config.getAutoRegisterSchemas().booleanValue()).buildSerializer();
    }

    public byte[] serialize(String topic, T record) {
        return null;
    }

    public byte[] serialize(String topic, Headers headers, T record) {
        if (record == null) {
            return null;
        }
        MessageWithMetadata message = this.serializer.serializeMessageData(record, TypeReference.createInstance(MessageWithMetadata.class));
        String messageContentType = message.getContentType();
        byte[] contentTypeBytes = messageContentType.getBytes();
        headers.add("content-type", contentTypeBytes);
        return message.getBodyAsBinaryData().toBytes();
    }

    public void close() {
    }
}

