/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.models.MessageContent;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.KafkaAvroSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer<T>
implements Serializer<T> {
    private SchemaRegistryApacheAvroSerializer serializer;

    public void configure(Map<String, ?> props, boolean isKey) {
        KafkaAvroSerializerConfig config = new KafkaAvroSerializerConfig(props);
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryClient(new SchemaRegistryClientBuilder().fullyQualifiedNamespace(config.getSchemaRegistryUrl()).credential(config.getCredential()).buildAsyncClient()).schemaGroup(config.getSchemaGroup()).autoRegisterSchemas(config.getAutoRegisterSchemas().booleanValue()).buildSerializer();
    }

    public byte[] serialize(String topic, T record) {
        return null;
    }

    public byte[] serialize(String topic, Headers headers, T record) {
        if (record == null) {
            return null;
        }
        MessageContent message = this.serializer.serialize(record, TypeReference.createInstance(MessageContent.class));
        byte[] contentTypeHeaderBytes = message.getContentType().getBytes();
        headers.add("content-type", contentTypeHeaderBytes);
        return message.getBodyAsBinaryData().toBytes();
    }

    public void close() {
    }
}

