/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.credential.TokenCredential;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroException;
import java.util.Map;

class AbstractKafkaSerdeConfig {
    private Map<String, Object> props;
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_CREDENTIAL_CONFIG = "schema.registry.credential";
    public static final String SCHEMA_GROUP_CONFIG = "schema.group";
    public static final String AVRO_SPECIFIC_VALUE_TYPE_CONFIG = "specific.avro.value.type";
    public static final String MAX_SCHEMA_MAP_SIZE_CONFIG = "max.schema.map.size";
    public static final Integer MAX_SCHEMA_MAP_SIZE_CONFIG_DEFAULT = 1000;

    AbstractKafkaSerdeConfig(Map<String, Object> props) {
        this.props = props;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public String getSchemaRegistryUrl() {
        return (String)this.props.get(SCHEMA_REGISTRY_URL_CONFIG);
    }

    public String getSchemaGroup() {
        if (!this.getProps().containsKey(SCHEMA_GROUP_CONFIG)) {
            throw new SchemaRegistryApacheAvroException("Schema group configuration property is required.");
        }
        return (String)this.getProps().get(SCHEMA_GROUP_CONFIG);
    }

    public TokenCredential getCredential() {
        return (TokenCredential)this.props.get(SCHEMA_REGISTRY_CREDENTIAL_CONFIG);
    }

    public Integer getMaxSchemaMapSize() {
        return (Integer)this.props.getOrDefault(MAX_SCHEMA_MAP_SIZE_CONFIG, MAX_SCHEMA_MAP_SIZE_CONFIG_DEFAULT);
    }

    public Class<?> getAvroSpecificType() {
        return this.getProps().getOrDefault(AVRO_SPECIFIC_VALUE_TYPE_CONFIG, Object.class);
    }
}

