/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.credential.TokenCredential;
import com.azure.core.models.MessageContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroException;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.azure.data.schemaregistry.models.SchemaRegistrySchema;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.AvroConverterConfig;
import com.microsoft.azure.schemaregistry.kafka.avro.AvroConverterUtils;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class AvroConverter
implements Converter {
    private SchemaRegistryAsyncClient schemaRegistryClient;
    private SchemaRegistryApacheAvroSerializer serializer;
    private SchemaRegistryApacheAvroSerializer deserializer;
    private AvroConverterConfig avroConverterConfig;

    public AvroConverter() {
    }

    public AvroConverter(SchemaRegistryAsyncClient client) {
        this.schemaRegistryClient = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.avroConverterConfig = new AvroConverterConfig(configs);
        ClientSecretCredential tokenCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId((String)this.avroConverterConfig.getProps().get("tenant.id"))).clientId((String)this.avroConverterConfig.getProps().get("client.id"))).clientSecret((String)this.avroConverterConfig.getProps().get("client.secret")).build();
        if (this.schemaRegistryClient == null) {
            this.schemaRegistryClient = new SchemaRegistryClientBuilder().fullyQualifiedNamespace(this.avroConverterConfig.getSchemaRegistryUrl()).credential((TokenCredential)tokenCredential).clientOptions(new ClientOptions().setApplicationId("KafkaConnectAvro/1.0")).buildAsyncClient();
        }
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryClient(this.schemaRegistryClient).schemaGroup(this.avroConverterConfig.getSchemaGroup()).autoRegisterSchemas(true).buildSerializer();
        this.deserializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryClient(this.schemaRegistryClient).schemaGroup(this.avroConverterConfig.getSchemaGroup()).buildSerializer();
    }

    public byte[] fromConnectData(String topics, Schema schema, Object value) {
        return this.fromConnectData(topics, null, schema, value);
    }

    public byte[] fromConnectData(String topics, Headers headers, Schema schema, Object value) {
        AvroConverterUtils utils = new AvroConverterUtils();
        Object avroValue = utils.fromConnectData(schema, utils.fromConnectSchema(schema, false), value, false);
        try {
            MessageContent message = this.serializer.serialize(avroValue, TypeReference.createInstance(MessageContent.class));
            byte[] contentTypeBytes = message.getContentType().getBytes();
            headers.add("content-type", contentTypeBytes);
            return message.getBodyAsBinaryData().toBytes();
        }
        catch (SchemaRegistryApacheAvroException e) {
            throw new DataException("Failed to serialize Avro data: ", (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return this.toConnectData(topic, null, value);
    }

    public SchemaAndValue toConnectData(String topic, Headers headers, byte[] value) {
        String contentTypeString = "";
        String schemaId = "";
        try {
            MessageContent message = new MessageContent();
            message.setBodyAsBinaryData(BinaryData.fromBytes((byte[])value));
            Header contentTypeHeader = headers.lastHeader("content-type");
            if (contentTypeHeader != null) {
                contentTypeString = new String(contentTypeHeader.value());
                message.setContentType(contentTypeString);
            }
            Object deserializedMessage = this.deserializer.deserialize(message, TypeReference.createInstance((Class)this.avroConverterConfig.getAvroSpecificType()));
            String[] splitSchemaId = contentTypeString.split("\\+");
            if (splitSchemaId.length < 2) {
                throw new DataException("Failed to prase schema id " + splitSchemaId[0]);
            }
            schemaId = splitSchemaId[1];
            SchemaRegistrySchema srSchema = (SchemaRegistrySchema)this.schemaRegistryClient.getSchema(schemaId).block();
            AvroConverterUtils utils = new AvroConverterUtils();
            return utils.toConnectData(new Schema.Parser().parse(srSchema.getDefinition()), deserializedMessage);
        }
        catch (SchemaRegistryApacheAvroException e) {
            throw new DataException("Failed to deserialize Avro data: ", (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }
}

