/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.AvroTypeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.internal.JacksonUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;

public class AvroConverterUtils {
    public static final String NAMESPACE = "com.microsoft.azure";
    public static final String DEFAULT_SCHEMA_NAME = "ConnectSchema";
    public static final String DEFAULT_SCHEMA_FULL_NAME = "com.microsoft.azure.ConnectSchema";
    public static final String MAP_ENTRY_TYPE_NAME = "MapEntry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String CONNECT_TYPE_PROP = "connect.type";
    public static final String CONNECT_TYPE_INT8 = "int8";
    public static final String CONNECT_TYPE_INT16 = "int16";
    public static final String AVRO_TYPE_UNION = "com.microsoft.azure.Union";
    public static final String AVRO_TYPE_ANYTHING = "com.microsoft.azure.Anything";
    public static final String AVRO_RECORD_DOC_PROP = "com.microsoft.azure.record.doc";
    public static final String AVRO_FIELD_DOC_PREFIX_PROP = "com.microsoft.azure.field.doc.";
    private static final Map<String, Schema.Type> NON_AVRO_TYPES_BY_TYPE_CODE = new HashMap<String, Schema.Type>();
    private static final Map<Schema.Type, List<Class>> SIMPLE_AVRO_SCHEMA_TYPES;
    private static final Map<Schema.Type, Schema.Type> CONNECT_TYPES_TO_AVRO_TYPES;
    private static final String ANYTHING_SCHEMA_BOOLEAN_FIELD = "boolean";
    private static final String ANYTHING_SCHEMA_BYTES_FIELD = "bytes";
    private static final String ANYTHING_SCHEMA_DOUBLE_FIELD = "double";
    private static final String ANYTHING_SCHEMA_FLOAT_FIELD = "float";
    private static final String ANYTHING_SCHEMA_INT_FIELD = "int";
    private static final String ANYTHING_SCHEMA_LONG_FIELD = "long";
    private static final String ANYTHING_SCHEMA_STRING_FIELD = "string";
    private static final String ANYTHING_SCHEMA_ARRAY_FIELD = "array";
    private static final String ANYTHING_SCHEMA_MAP_FIELD = "map";
    static final String AVRO_PROP = "avro";
    static final String AVRO_LOGICAL_TYPE_PROP = "logicalType";
    static final String AVRO_LOGICAL_TIMESTAMP_MILLIS = "timestamp-millis";
    static final String AVRO_LOGICAL_TIME_MILLIS = "time-millis";
    static final String AVRO_LOGICAL_DATE = "date";
    static final String AVRO_LOGICAL_DECIMAL = "decimal";
    static final String AVRO_LOGICAL_DECIMAL_SCALE_PROP = "scale";
    static final String AVRO_LOGICAL_DECIMAL_PRECISION_PROP = "precision";
    public static final String AVRO_TYPE_ENUM = "com.microsoft.azure.Enum";
    public static final String AVRO_ENUM_DOC_PREFIX_PROP = "com.microsoft.azure.enum.doc.";
    static final String CONNECT_AVRO_FIXED_SIZE_PROP = "connect.fixed.size";
    static final String CONNECT_AVRO_DECIMAL_PRECISION_PROP = "connect.decimal.precision";
    static final Integer CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT;
    public static final String CONNECT_INTERNAL_TYPE_NAME = "connect.internal.type";
    public static final String CONNECT_NAME_PROP = "connect.name";
    public static final String CONNECT_DOC_PROP = "connect.doc";
    public static final String CONNECT_RECORD_DOC_PROP = "connect.record.doc";
    public static final String CONNECT_ENUM_DOC_PROP = "connect.enum.doc";
    public static final String CONNECT_VERSION_PROP = "connect.version";
    public static final String CONNECT_DEFAULT_VALUE_PROP = "connect.default";
    public static final String CONNECT_PARAMETERS_PROP = "connect.parameters";
    public static final Schema ANYTHING_SCHEMA_MAP_ELEMENT;
    public static final Schema ANYTHING_SCHEMA;
    private static final Schema NULL_AVRO_SCHEMA;

    public SchemaAndValue toConnectData(Schema avroSchema, Object value) {
        if (value == null) {
            return null;
        }
        org.apache.kafka.connect.data.Schema schema = avroSchema.equals((Object)ANYTHING_SCHEMA) ? null : this.toConnectSchema(avroSchema);
        return new SchemaAndValue(schema, this.toConnectValue(schema, value));
    }

    private Object toConnectValue(org.apache.kafka.connect.data.Schema schema, Object value) {
        if (value == null || value == JsonProperties.NULL_VALUE) {
            return null;
        }
        try {
            if (schema == null) {
                if (!(value instanceof IndexedRecord)) {
                    throw new DataException("Invalid Avro data for schemaless Connect data");
                }
                IndexedRecord recordValue = (IndexedRecord)value;
                Object boolVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_BOOLEAN_FIELD).pos());
                if (boolVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, boolVal);
                }
                Object bytesVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_BYTES_FIELD).pos());
                if (bytesVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, bytesVal);
                }
                Object doubleVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_DOUBLE_FIELD).pos());
                if (doubleVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA, doubleVal);
                }
                Object floatVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_FLOAT_FIELD).pos());
                if (floatVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA, floatVal);
                }
                Object intVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_INT_FIELD).pos());
                if (intVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.INT32_SCHEMA, intVal);
                }
                Object longVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_LONG_FIELD).pos());
                if (longVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.INT64_SCHEMA, longVal);
                }
                Object stringVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_STRING_FIELD).pos());
                if (stringVal != null) {
                    return this.toConnectValue(org.apache.kafka.connect.data.Schema.STRING_SCHEMA, stringVal);
                }
                Object arrayVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_ARRAY_FIELD).pos());
                if (arrayVal != null) {
                    if (!(arrayVal instanceof Collection)) {
                        throw new DataException("Expected Collection for schemaless array field but found " + arrayVal.getClass().getName());
                    }
                    Collection arrayValCollection = (Collection)arrayVal;
                    ArrayList<Object> result = new ArrayList<Object>(arrayValCollection.size());
                    for (Object arrayValue : arrayValCollection) {
                        result.add(this.toConnectValue(null, arrayValue));
                    }
                    return result;
                }
                Object mapVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_MAP_FIELD).pos());
                if (mapVal != null) {
                    if (!(mapVal instanceof Collection)) {
                        throw new DataException("Expected List for schemaless map field but found " + mapVal.getClass().getName());
                    }
                    Collection mapValueCollection = (Collection)mapVal;
                    HashMap<Object, Object> result = new HashMap<Object, Object>(mapValueCollection.size());
                    for (IndexedRecord mapValue : mapValueCollection) {
                        int avroKeyFieldIndex = mapValue.getSchema().getField(KEY_FIELD).pos();
                        int avroValueFieldIndex = mapValue.getSchema().getField(VALUE_FIELD).pos();
                        Object convertedKey = this.toConnectValue(null, mapValue.get(avroKeyFieldIndex));
                        Object convertedValue = this.toConnectValue(null, mapValue.get(avroValueFieldIndex));
                        result.put(convertedKey, convertedValue);
                    }
                    return result;
                }
                return null;
            }
            Object converted = null;
            switch (schema.type()) {
                case INT32: {
                    Integer intValue = (Integer)value;
                    converted = intValue;
                    break;
                }
                case INT64: {
                    Long longValue = (Long)value;
                    converted = longValue;
                    break;
                }
                case FLOAT32: {
                    Float floatValue = (Float)value;
                    converted = floatValue;
                    break;
                }
                case FLOAT64: {
                    Double doubleValue = (Double)value;
                    converted = doubleValue;
                    break;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    converted = boolValue;
                    break;
                }
                case INT8: {
                    converted = ((Integer)value).byteValue();
                    break;
                }
                case INT16: {
                    converted = ((Integer)value).shortValue();
                    break;
                }
                case STRING: {
                    if (value instanceof String) {
                        converted = value;
                        break;
                    }
                    if (value instanceof CharSequence || value instanceof Enum) {
                        converted = value.toString();
                        break;
                    }
                    throw new DataException("Invalid class for string type, expecting String or CharSequence, got " + value.getClass());
                }
                case BYTES: {
                    if (value instanceof byte[]) {
                        converted = ByteBuffer.wrap((byte[])value);
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        converted = value;
                        break;
                    }
                    if (value instanceof GenericFixed) {
                        converted = ByteBuffer.wrap(((GenericFixed)value).bytes());
                        break;
                    }
                    throw new DataException("Invalid class for bytes type, expecting byte[] or ByteBuffer, got " + value.getClass());
                }
                case ARRAY: {
                    org.apache.kafka.connect.data.Schema valueSchema = schema.valueSchema();
                    Collection valueSchemaCollection = (Collection)value;
                    ArrayList<Object> arrayValue = new ArrayList<Object>(valueSchemaCollection.size());
                    for (Object elem : valueSchemaCollection) {
                        arrayValue.add(this.toConnectValue(valueSchema, elem));
                    }
                    converted = arrayValue;
                    break;
                }
                case MAP: {
                    org.apache.kafka.connect.data.Schema keySchema = schema.keySchema();
                    org.apache.kafka.connect.data.Schema valueSchema = schema.valueSchema();
                    if (keySchema != null && keySchema.type() == Schema.Type.STRING && !keySchema.isOptional()) {
                        Map valueSchemaMap = (Map)value;
                        HashMap<String, Object> mapValue = new HashMap<String, Object>(valueSchemaMap.size());
                        for (Map.Entry entry : valueSchemaMap.entrySet()) {
                            mapValue.put(((CharSequence)entry.getKey()).toString(), this.toConnectValue(valueSchema, entry.getValue()));
                        }
                        converted = mapValue;
                        break;
                    }
                    Collection original = (Collection)value;
                    HashMap<Object, Object> mapValue = new HashMap<Object, Object>(original.size());
                    for (IndexedRecord entry : original) {
                        int avroKeyFieldIndex = entry.getSchema().getField(KEY_FIELD).pos();
                        int avroValueFieldIndex = entry.getSchema().getField(VALUE_FIELD).pos();
                        Object convertedKey = this.toConnectValue(keySchema, entry.get(avroKeyFieldIndex));
                        Object convertedValue = this.toConnectValue(valueSchema, entry.get(avroValueFieldIndex));
                        mapValue.put(convertedKey, convertedValue);
                    }
                    converted = mapValue;
                    break;
                }
                case STRUCT: {
                    if (AVRO_TYPE_UNION.equals(schema.name())) {
                        org.apache.kafka.connect.data.Schema valueRecordSchema = null;
                        if (value instanceof IndexedRecord) {
                            IndexedRecord valueRecord = (IndexedRecord)value;
                            valueRecordSchema = this.toConnectSchema(valueRecord.getSchema());
                        }
                        int index = 0;
                        for (Field field : schema.fields()) {
                            org.apache.kafka.connect.data.Schema fieldSchema = field.schema();
                            if (this.isInstanceOfAvroSchemaTypeForSimpleSchema(fieldSchema, value, index) || valueRecordSchema != null && AvroConverterUtils.schemaEquals(valueRecordSchema, fieldSchema)) {
                                converted = new Struct(schema).put(AvroConverterUtils.unionMemberFieldName(fieldSchema, index), this.toConnectValue(fieldSchema, value));
                                break;
                            }
                            ++index;
                        }
                        if (converted != null) break;
                        throw new DataException("Did not find matching union field for data");
                    }
                    if (value instanceof Map) {
                        Map original = (Map)value;
                        Struct result = new Struct(schema);
                        for (Field field : schema.fields()) {
                            String fieldName = field.name();
                            Object convertedFieldValue = this.toConnectValue(field.schema(), original.getOrDefault(fieldName, field.schema().defaultValue()));
                            result.put(field, convertedFieldValue);
                        }
                        return result;
                    }
                    IndexedRecord valueRecord = (IndexedRecord)value;
                    Struct structValue = new Struct(schema);
                    for (Field field : schema.fields()) {
                        String fieldName = field.name();
                        int avroFieldIndex = valueRecord.getSchema().getField(fieldName).pos();
                        Object convertedFieldValue = this.toConnectValue(field.schema(), valueRecord.get(avroFieldIndex));
                        structValue.put(field, convertedFieldValue);
                    }
                    converted = structValue;
                    break;
                }
                default: {
                    throw new DataException("Unknown Connect schema type: " + schema.type());
                }
            }
            if (schema.name() != null) {
                String schemaNameLower;
                switch (schemaNameLower = schema.name().toLowerCase()) {
                    case "org.apache.kafka.connect.data.date": {
                        if (!(value instanceof Integer)) {
                            throw new DataException("Invalid type for Time, underlying representation should be int32 but was " + value.getClass());
                        }
                        converted = Date.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)((Integer)value));
                        break;
                    }
                    case "org.apache.kafka.connect.data.time": {
                        if (!(value instanceof Integer)) {
                            throw new DataException("Invalid type for Time, underlying representation should be int32 but was " + value.getClass());
                        }
                        converted = Time.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)((Integer)value));
                        break;
                    }
                    case "org.apache.kafka.connect.data.timestamp": {
                        if (!(value instanceof Long)) {
                            throw new DataException("Invalid type for Timestamp, underlying representation should be int64 but was " + value.getClass());
                        }
                        converted = Timestamp.toLogical((org.apache.kafka.connect.data.Schema)schema, (long)((Long)value));
                        break;
                    }
                    case "org.apache.kafka.connect.data.decimal": {
                        if (value instanceof byte[]) {
                            converted = Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])((byte[])value));
                            break;
                        }
                        if (value instanceof ByteBuffer) {
                            converted = Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])((ByteBuffer)value).array());
                            break;
                        }
                        throw new DataException("Invalid type for Decimal, underlying representation should be bytes but was " + value.getClass());
                    }
                }
            }
            return converted;
        }
        catch (ClassCastException e) {
            String schemaType = schema != null ? schema.type().toString() : "null";
            throw new DataException("Invalid type for " + schemaType + ": " + value.getClass());
        }
    }

    public org.apache.kafka.connect.data.Schema toConnectSchema(Schema schema) {
        SchemaBuilder builder;
        String type = schema.getProp(CONNECT_TYPE_PROP);
        String logicalType = schema.getProp(AVRO_LOGICAL_TYPE_PROP);
        switch (schema.getType()) {
            case BOOLEAN: {
                builder = SchemaBuilder.bool();
                break;
            }
            case BYTES: 
            case FIXED: {
                if (AVRO_LOGICAL_DECIMAL.equalsIgnoreCase(logicalType)) {
                    Object scaleNode = schema.getObjectProp(AVRO_LOGICAL_DECIMAL_SCALE_PROP);
                    int scale = scaleNode instanceof Number ? ((Number)scaleNode).intValue() : 0;
                    builder = Decimal.builder((int)scale);
                    Object precisionNode = schema.getObjectProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP);
                    if (null != precisionNode) {
                        if (!(precisionNode instanceof Number)) {
                            throw new DataException("precision is not an integer.");
                        }
                        int n = ((Number)precisionNode).intValue();
                        if (n != CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT) {
                            builder.parameter(CONNECT_AVRO_DECIMAL_PRECISION_PROP, String.valueOf(n));
                        }
                    }
                } else {
                    builder = SchemaBuilder.bytes();
                }
                if (schema.getType() != Schema.Type.FIXED) break;
                builder.parameter(CONNECT_AVRO_FIXED_SIZE_PROP, String.valueOf(schema.getFixedSize()));
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case INT: {
                if (type == null && logicalType == null) {
                    builder = SchemaBuilder.int32();
                    break;
                }
                if (logicalType != null) {
                    if (AVRO_LOGICAL_DATE.equalsIgnoreCase(logicalType)) {
                        builder = Date.builder();
                        break;
                    }
                    if (AVRO_LOGICAL_TIME_MILLIS.equalsIgnoreCase(logicalType)) {
                        builder = Time.builder();
                        break;
                    }
                    builder = SchemaBuilder.int32();
                    break;
                }
                Schema.Type connectType = NON_AVRO_TYPES_BY_TYPE_CODE.get(type);
                if (connectType == null) {
                    throw new DataException("Connect type for Avro int field is not found");
                }
                builder = SchemaBuilder.type((Schema.Type)connectType);
                break;
            }
            case LONG: {
                if (AVRO_LOGICAL_TIMESTAMP_MILLIS.equalsIgnoreCase(logicalType)) {
                    builder = Timestamp.builder();
                    break;
                }
                builder = SchemaBuilder.int64();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case ARRAY: {
                Schema arrayElementSchema = schema.getElementType();
                if (this.isMapEntry(arrayElementSchema)) {
                    if (arrayElementSchema.getFields().size() != 2 || arrayElementSchema.getField(KEY_FIELD) == null || arrayElementSchema.getField(VALUE_FIELD) == null) {
                        throw new DataException("Expected array of key-value pairs");
                    }
                    builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)this.toConnectSchema(arrayElementSchema.getField(KEY_FIELD).schema()), (org.apache.kafka.connect.data.Schema)this.toConnectSchema(arrayElementSchema.getField(VALUE_FIELD).schema()));
                    break;
                }
                org.apache.kafka.connect.data.Schema arraySchema = this.toConnectSchema(schema.getElementType());
                builder = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)arraySchema);
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)this.toConnectSchema(schema.getValueType()));
                break;
            }
            case RECORD: {
                builder = SchemaBuilder.struct();
                for (Object field : schema.getFields()) {
                    org.apache.kafka.connect.data.Schema schema2 = this.toConnectSchema(field.schema());
                    builder.field(field.name(), schema2);
                }
                break;
            }
            case ENUM: {
                builder = SchemaBuilder.string();
                String paramName = AVRO_TYPE_ENUM;
                builder.parameter(paramName, schema.getFullName());
                for (String string : schema.getEnumSymbols()) {
                    builder.parameter(paramName + "." + string, string);
                }
                break;
            }
            case UNION: {
                if (schema.getTypes().size() == 2 && schema.getTypes().contains(NULL_AVRO_SCHEMA)) {
                    for (Schema schema3 : schema.getTypes()) {
                        if (schema3.equals((Object)NULL_AVRO_SCHEMA)) continue;
                        return this.toConnectSchema(schema3);
                    }
                }
                String unionName = AVRO_TYPE_UNION;
                builder = SchemaBuilder.struct().name(unionName);
                HashSet<String> hashSet = new HashSet<String>();
                int fieldIndex = 0;
                for (Schema memberSchema : schema.getTypes()) {
                    if (memberSchema.getType() == Schema.Type.NULL) {
                        builder.optional();
                    } else {
                        String fieldName = AvroConverterUtils.unionMemberFieldName(memberSchema, fieldIndex);
                        if (hashSet.contains(fieldName)) {
                            throw new DataException("Multiple union schemas map to the Connect union field name");
                        }
                        hashSet.add(fieldName);
                        builder.field(fieldName, this.toConnectSchema(memberSchema));
                    }
                    ++fieldIndex;
                }
                break;
            }
            case NULL: {
                throw new DataException("Null schemas are not supported");
            }
            default: {
                throw new DataException("Unsupported schema type: " + schema.getType().getName());
            }
        }
        Object parameters = schema.getObjectProp(CONNECT_PARAMETERS_PROP);
        if (parameters != null) {
            if (!(parameters instanceof Map)) {
                throw new DataException("Expected JSON object for schema parameters. Got: " + parameters);
            }
            Map params = (Map)parameters;
            for (Map.Entry entry : params.entrySet()) {
                Object jsonValue = entry.getValue();
                if (!(jsonValue instanceof String)) {
                    throw new DataException("Schema parameter value is not a string. Got: " + jsonValue);
                }
                builder.parameter((String)entry.getKey(), (String)jsonValue);
            }
        }
        for (Map.Entry entry : schema.getObjectProps().entrySet()) {
            if (!((String)entry.getKey()).startsWith(AVRO_PROP)) continue;
            builder.parameter((String)entry.getKey(), entry.getValue().toString());
        }
        Object connectNameJson = schema.getObjectProp(CONNECT_NAME_PROP);
        String name = null;
        if (connectNameJson != null) {
            if (!(connectNameJson instanceof String)) {
                throw new DataException("Invalid schema name: " + connectNameJson.toString());
            }
            name = (String)connectNameJson;
        } else if (schema.getType() == Schema.Type.RECORD || schema.getType() == Schema.Type.ENUM || schema.getType() == Schema.Type.FIXED) {
            name = schema.getFullName();
        }
        if (name != null && !name.startsWith(DEFAULT_SCHEMA_FULL_NAME)) {
            if (builder.name() != null) {
                if (!name.equals(builder.name())) {
                    throw new DataException("Schema name that has already been added to SchemaBuilder (" + builder.name() + ") differs from name in source schema (" + name + ")");
                }
            } else {
                builder.name(name);
            }
        }
        return builder.build();
    }

    public Object fromConnectData(org.apache.kafka.connect.data.Schema schema, Schema avroSchema, Object logicalValue, boolean buildGenericRecord) {
        Schema.Type schemaType;
        Schema.Type type = schemaType = schema != null ? schema.type() : AvroConverterUtils.getSchemaFromLogicalValue(logicalValue);
        if (schemaType == null) {
            if (buildGenericRecord) {
                return new GenericRecordBuilder(ANYTHING_SCHEMA).build();
            }
            return null;
        }
        if (logicalValue == null && !schema.isOptional()) {
            throw new DataException("Found null value for non-optional schema");
        }
        if (logicalValue == null) {
            if (buildGenericRecord) {
                return new GenericRecordBuilder(ANYTHING_SCHEMA).build();
            }
            return null;
        }
        Object bytesValue = logicalValue;
        if (schema != null && schema.name() != null) {
            switch (schema.name()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    if (!(bytesValue instanceof BigDecimal)) {
                        throw new DataException("Can't convert type for Decimal, expected BigDecimal but got " + bytesValue.getClass());
                    }
                    bytesValue = Decimal.fromLogical((org.apache.kafka.connect.data.Schema)schema, (BigDecimal)((BigDecimal)logicalValue));
                    break;
                }
                case "org.apache.kafka.connect.data.Date": {
                    if (!(bytesValue instanceof java.util.Date)) {
                        throw new DataException("Can't convert type for Date, expected Date but got " + bytesValue.getClass());
                    }
                    bytesValue = Date.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)logicalValue));
                    break;
                }
                case "org.apache.kafka.connect.data.Time": {
                    if (!(bytesValue instanceof java.util.Date)) {
                        throw new DataException("Can't convert type for Time, expected Date but got " + bytesValue.getClass());
                    }
                    bytesValue = Time.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)logicalValue));
                    break;
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    if (!(bytesValue instanceof java.util.Date)) {
                        throw new DataException("Can't convert type for Timestamp, expected Date but got " + bytesValue.getClass());
                    }
                    bytesValue = Timestamp.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)logicalValue));
                    break;
                }
            }
        }
        try {
            switch (schemaType) {
                case INT8: {
                    Byte byteValue = (Byte)bytesValue;
                    Integer convertedByteValue = byteValue == null ? null : Integer.valueOf(byteValue.intValue());
                    return convertedByteValue;
                }
                case INT16: {
                    Short shortValue = (Short)bytesValue;
                    Integer convertedShortValue = shortValue == null ? null : Integer.valueOf(shortValue.intValue());
                    return convertedShortValue;
                }
                case INT32: {
                    Integer intValue = (Integer)bytesValue;
                    return intValue;
                }
                case INT64: {
                    Long longValue = (Long)bytesValue;
                    return longValue;
                }
                case FLOAT32: {
                    Float floatValue = (Float)bytesValue;
                    return floatValue;
                }
                case FLOAT64: {
                    Double doubleValue = (Double)bytesValue;
                    return doubleValue;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)bytesValue;
                    return boolValue;
                }
                case STRING: {
                    if (schema != null && schema.parameters() != null && schema.parameters().containsKey(AVRO_TYPE_ENUM)) {
                        String enumSchemaName = (String)schema.parameters().get(AVRO_TYPE_ENUM);
                        return this.enumSymbol(avroSchema, bytesValue, enumSchemaName);
                    }
                    String stringValue = (String)bytesValue;
                    return stringValue;
                }
                case BYTES: {
                    Object object = bytesValue = bytesValue instanceof byte[] ? ByteBuffer.wrap((byte[])bytesValue) : (ByteBuffer)bytesValue;
                    if (schema != null && AvroConverterUtils.isFixedSchema(schema)) {
                        int size = Integer.parseInt((String)schema.parameters().get(CONNECT_AVRO_FIXED_SIZE_PROP));
                        Schema fixedSchema = null;
                        if (avroSchema.getType() == Schema.Type.UNION) {
                            int index = 0;
                            for (Schema memberSchema : avroSchema.getTypes()) {
                                if (memberSchema.getType() == Schema.Type.FIXED && memberSchema.getFixedSize() == size && AvroConverterUtils.unionMemberFieldName(memberSchema, index).equals(AvroConverterUtils.unionMemberFieldName(schema, index))) {
                                    fixedSchema = memberSchema;
                                }
                                ++index;
                            }
                            if (fixedSchema == null) {
                                throw new DataException("Fixed size " + size + " not found in union " + avroSchema);
                            }
                        } else {
                            fixedSchema = avroSchema;
                        }
                        bytesValue = new GenericData.Fixed(fixedSchema, ((ByteBuffer)bytesValue).array());
                    }
                    return bytesValue;
                }
                case ARRAY: {
                    Collection list = (Collection)bytesValue;
                    ArrayList<Object> arrayValue = new ArrayList<Object>(list.size());
                    org.apache.kafka.connect.data.Schema arrayElementSchema = schema != null ? schema.valueSchema() : null;
                    Schema underlyingAvroSchema = AvroConverterUtils.getAvroSchema(schema, avroSchema);
                    Schema arrayElementAvroSchema = schema != null ? underlyingAvroSchema.getElementType() : ANYTHING_SCHEMA;
                    for (Object val : list) {
                        arrayValue.add(this.fromConnectData(arrayElementSchema, arrayElementAvroSchema, val, false));
                    }
                    return arrayValue;
                }
                case MAP: {
                    Map map = (Map)bytesValue;
                    if (schema != null && schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                        Schema underlyingAvroSchema = AvroConverterUtils.getAvroSchema(schema, avroSchema);
                        HashMap<String, Object> mapValue = new HashMap<String, Object>();
                        for (Map.Entry entry : map.entrySet()) {
                            Object convertedValue = this.fromConnectData(schema.valueSchema(), underlyingAvroSchema.getValueType(), entry.getValue(), false);
                            mapValue.put((String)entry.getKey(), convertedValue);
                        }
                        return mapValue;
                    }
                    ArrayList<GenericData.Record> mapValue = new ArrayList<GenericData.Record>(map.size());
                    Schema underlyingAvroSchema = AvroConverterUtils.getAvroSchemaWithMapEntry(schema, avroSchema);
                    Schema elementSchema = schema != null ? underlyingAvroSchema.getElementType() : ANYTHING_SCHEMA_MAP_ELEMENT;
                    Schema avroKeySchema = elementSchema.getField(KEY_FIELD).schema();
                    Schema avroValueSchema = elementSchema.getField(VALUE_FIELD).schema();
                    for (Map.Entry entry : map.entrySet()) {
                        Object keyConverted = this.fromConnectData(schema != null ? schema.keySchema() : null, avroKeySchema, entry.getKey(), false);
                        Object valueConverted = this.fromConnectData(schema != null ? schema.valueSchema() : null, avroValueSchema, entry.getValue(), false);
                        mapValue.add(new GenericRecordBuilder(elementSchema).set(KEY_FIELD, keyConverted).set(VALUE_FIELD, valueConverted).build());
                    }
                    return mapValue;
                }
                case STRUCT: {
                    Struct struct = (Struct)bytesValue;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching struct schema");
                    }
                    if (AVRO_TYPE_UNION.equals(schema.name())) {
                        for (Field field : schema.fields()) {
                            Object object = struct.get(field);
                            if (object == null) continue;
                            return this.fromConnectData(field.schema(), avroSchema, object, false);
                        }
                        return this.fromConnectData(schema, avroSchema, null, true);
                    }
                    Schema underlyingAvroSchema = AvroConverterUtils.getAvroSchema(schema, avroSchema);
                    GenericRecordBuilder convertedBuilder = new GenericRecordBuilder(underlyingAvroSchema);
                    for (Field field : schema.fields()) {
                        String fieldName = field.name();
                        Schema.Field schemaField = underlyingAvroSchema.getField(fieldName);
                        Schema fieldAvroSchema = schemaField.schema();
                        Object fieldValue = struct.get(field);
                        convertedBuilder.set(fieldName, this.fromConnectData(field.schema(), fieldAvroSchema, fieldValue, false));
                    }
                    return convertedBuilder.build();
                }
            }
            throw new DataException("Unknown schema type: " + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + bytesValue.getClass());
        }
    }

    public Schema fromConnectSchema(org.apache.kafka.connect.data.Schema schema, boolean setOptional) {
        Schema avroSchema;
        if (schema == null) {
            return ANYTHING_SCHEMA;
        }
        switch (schema.type()) {
            case INT8: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT16: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT32: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT64: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
                break;
            }
            case FLOAT32: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().floatType();
                break;
            }
            case FLOAT64: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().doubleType();
                break;
            }
            case BOOLEAN: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().booleanType();
                break;
            }
            case STRING: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
                break;
            }
            case BYTES: {
                String namespace;
                if (AvroConverterUtils.isFixedSchema(schema)) {
                    Pair<String, String> names = this.getNameOrDefault(schema.name());
                    namespace = (String)names.getKey();
                    String name = (String)names.getValue();
                    avroSchema = (Schema)((SchemaBuilder.FixedBuilder)org.apache.avro.SchemaBuilder.builder().fixed(name).namespace(namespace)).size(Integer.parseInt((String)schema.parameters().get(CONNECT_AVRO_FIXED_SIZE_PROP)));
                } else {
                    avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
                }
                if (!"org.apache.kafka.connect.data.Decimal".equalsIgnoreCase(schema.name())) break;
                int scale = Integer.parseInt((String)schema.parameters().get(AVRO_LOGICAL_DECIMAL_SCALE_PROP));
                avroSchema.addProp(AVRO_LOGICAL_DECIMAL_SCALE_PROP, (Object)new IntNode(scale));
                if (schema.parameters().containsKey(CONNECT_AVRO_DECIMAL_PRECISION_PROP)) {
                    String precisionValue = (String)schema.parameters().get(CONNECT_AVRO_DECIMAL_PRECISION_PROP);
                    int precision = Integer.parseInt(precisionValue);
                    avroSchema.addProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP, (Object)new IntNode(precision));
                    break;
                }
                avroSchema.addProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP, (Object)new IntNode(CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT.intValue()));
                break;
            }
            case ARRAY: {
                avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items(this.fromConnectSchema(schema.valueSchema(), false));
                break;
            }
            case MAP: {
                Schema mapSchema;
                if (schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                    avroSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values(this.fromConnectSchema(schema.valueSchema(), false));
                    break;
                }
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                if (schema.name() == null) {
                    mapSchema = Schema.createRecord((String)MAP_ENTRY_TYPE_NAME, null, (String)NAMESPACE, (boolean)false);
                } else {
                    Pair<String, String> names = this.getNameOrDefault(schema.name());
                    String namespace = (String)names.getKey();
                    String name = (String)names.getValue();
                    mapSchema = Schema.createRecord((String)name, null, (String)namespace, (boolean)false);
                    mapSchema.addProp(CONNECT_INTERNAL_TYPE_NAME, MAP_ENTRY_TYPE_NAME);
                }
                this.addAvroRecordField(fields, KEY_FIELD, schema.keySchema(), null);
                this.addAvroRecordField(fields, VALUE_FIELD, schema.valueSchema(), null);
                mapSchema.setFields(fields);
                avroSchema = Schema.createArray((Schema)mapSchema);
                break;
            }
            case STRUCT: {
                if (AVRO_TYPE_UNION.equals(schema.name())) {
                    ArrayList<Schema> unionSchemas = new ArrayList<Schema>();
                    if (schema.isOptional()) {
                        unionSchemas.add((Schema)org.apache.avro.SchemaBuilder.builder().nullType());
                    }
                    for (Field field : schema.fields()) {
                        unionSchemas.add(this.fromConnectSchema(field.schema(), false));
                    }
                    avroSchema = Schema.createUnion(unionSchemas);
                    break;
                }
                if (schema.isOptional()) {
                    ArrayList<Schema> unionSchemas = new ArrayList<Schema>();
                    unionSchemas.add((Schema)org.apache.avro.SchemaBuilder.builder().nullType());
                    unionSchemas.add(this.fromConnectSchema(schema, false));
                    avroSchema = Schema.createUnion(unionSchemas);
                    break;
                }
                Pair<String, String> names = this.getNameOrDefault(schema.name());
                String namespace = (String)names.getKey();
                String name = (String)names.getValue();
                String doc = schema.parameters() != null ? (String)schema.parameters().get(AVRO_RECORD_DOC_PROP) : null;
                avroSchema = Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)false);
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                for (Field field : schema.fields()) {
                    String fieldName = field.name();
                    String fieldDoc = null;
                    if (schema.parameters() != null) {
                        fieldDoc = (String)schema.parameters().get(AVRO_FIELD_DOC_PREFIX_PROP + field.name());
                    }
                    this.addAvroRecordField(fields, fieldName, field.schema(), fieldDoc);
                }
                avroSchema.setFields(fields);
                break;
            }
            default: {
                throw new DataException("Unknown schema type: " + schema.type());
            }
        }
        if (!avroSchema.getType().equals((Object)Schema.Type.UNION)) {
            if (schema.name() != null) {
                if ("org.apache.kafka.connect.data.Decimal".equalsIgnoreCase(schema.name())) {
                    String precisionString = (String)schema.parameters().get(CONNECT_AVRO_DECIMAL_PRECISION_PROP);
                    String scaleString = (String)schema.parameters().get(AVRO_LOGICAL_DECIMAL_SCALE_PROP);
                    int precision = precisionString == null ? CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT : Integer.parseInt(precisionString);
                    int scale = scaleString == null ? 0 : Integer.parseInt(scaleString);
                    LogicalTypes.decimal((int)precision, (int)scale).addToSchema(avroSchema);
                } else if ("org.apache.kafka.connect.data.Time".equalsIgnoreCase(schema.name())) {
                    LogicalTypes.timeMillis().addToSchema(avroSchema);
                } else if ("org.apache.kafka.connect.data.Timestamp".equalsIgnoreCase(schema.name())) {
                    LogicalTypes.timestampMillis().addToSchema(avroSchema);
                } else if ("org.apache.kafka.connect.data.Date".equalsIgnoreCase(schema.name())) {
                    LogicalTypes.date().addToSchema(avroSchema);
                }
            }
            if (schema.parameters() != null) {
                for (Map.Entry entry : schema.parameters().entrySet()) {
                    if (!((String)entry.getKey()).startsWith(AVRO_PROP)) continue;
                    avroSchema.addProp((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        if (setOptional) {
            return this.MakeOptional(schema, avroSchema);
        }
        return avroSchema;
    }

    private static boolean schemaEquals(org.apache.kafka.connect.data.Schema src, org.apache.kafka.connect.data.Schema that) {
        return AvroConverterUtils.schemaEquals(src, that, new HashMap<Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>, Boolean>());
    }

    private static boolean schemaEquals(org.apache.kafka.connect.data.Schema src, org.apache.kafka.connect.data.Schema that, Map<Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>, Boolean> cache) {
        if (src == that) {
            return true;
        }
        if (src == null || that == null) {
            return false;
        }
        Pair sp = Pair.of((Object)src, (Object)that);
        Boolean cacheHit = cache.putIfAbsent((Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>)sp, true);
        if (cacheHit != null) {
            return cacheHit;
        }
        boolean equals = Objects.equals(src.isOptional(), that.isOptional()) && Objects.equals(src.version(), that.version()) && Objects.equals(src.name(), that.name()) && Objects.equals(src.doc(), that.doc()) && Objects.equals(src.type(), that.type()) && Objects.deepEquals(src.defaultValue(), that.defaultValue()) && Objects.equals(src.parameters(), that.parameters());
        switch (src.type()) {
            case STRUCT: {
                equals = equals && AvroConverterUtils.fieldListEquals(src.fields(), that.fields(), cache);
                break;
            }
            case ARRAY: {
                equals = equals && AvroConverterUtils.schemaEquals(src.valueSchema(), that.valueSchema(), cache);
                break;
            }
            case MAP: {
                equals = equals && AvroConverterUtils.schemaEquals(src.valueSchema(), that.valueSchema(), cache) && AvroConverterUtils.schemaEquals(src.keySchema(), that.keySchema(), cache);
                break;
            }
        }
        cache.put((Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>)sp, equals);
        return equals;
    }

    private static boolean fieldListEquals(List<Field> one, List<Field> two, Map<Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>, Boolean> cache) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        ListIterator<Field> itOne = one.listIterator();
        ListIterator<Field> itTwo = two.listIterator();
        while (itOne.hasNext() && itTwo.hasNext()) {
            if (AvroConverterUtils.fieldEquals(itOne.next(), itTwo.next(), cache)) continue;
            return false;
        }
        return itOne.hasNext() == itTwo.hasNext();
    }

    private static boolean fieldEquals(Field one, Field two, Map<Pair<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema>, Boolean> cache) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.getClass() == two.getClass() && Objects.equals(one.index(), two.index()) && Objects.equals(one.name(), two.name()) && AvroConverterUtils.schemaEquals(one.schema(), two.schema(), cache);
    }

    private static String unionMemberFieldName(Schema schema, int index) {
        if (schema.getType() == Schema.Type.RECORD || schema.getType() == Schema.Type.ENUM || schema.getType() == Schema.Type.FIXED) {
            return AvroConverterUtils.splitName(schema.getName())[1];
        }
        return schema.getType().getName();
    }

    private boolean isMapEntry(Schema mapElementSchema) {
        if (!mapElementSchema.getType().equals((Object)Schema.Type.RECORD)) {
            return false;
        }
        if (NAMESPACE.equals(mapElementSchema.getNamespace()) && MAP_ENTRY_TYPE_NAME.equals(mapElementSchema.getName())) {
            return true;
        }
        return Objects.equals(mapElementSchema.getProp(CONNECT_INTERNAL_TYPE_NAME), MAP_ENTRY_TYPE_NAME);
    }

    private static Schema getAvroSchemaWithMapEntry(org.apache.kafka.connect.data.Schema schema, Schema avroSchema) {
        if (schema != null && schema.isOptional()) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                for (Schema typeSchema : avroSchema.getTypes()) {
                    if (typeSchema.getType().equals((Object)Schema.Type.NULL) || !Schema.Type.ARRAY.getName().equals(typeSchema.getType().getName())) continue;
                    return typeSchema;
                }
            } else {
                throw new DataException("An optional schema should have a Union type, not " + schema.type());
            }
        }
        return avroSchema;
    }

    private static Schema getAvroSchema(org.apache.kafka.connect.data.Schema schema, Schema avroSchema) {
        if (schema != null && schema.isOptional()) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                for (Schema typeSchema : avroSchema.getTypes()) {
                    if (typeSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                    return typeSchema;
                }
            } else {
                throw new DataException("An optional schema should have a Union type, not " + schema.type());
            }
        }
        return avroSchema;
    }

    private static Schema.Type getSchemaFromLogicalValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return Schema.Type.INT8;
        }
        if (value instanceof Short) {
            return Schema.Type.INT16;
        }
        if (value instanceof Integer) {
            return Schema.Type.INT32;
        }
        if (value instanceof Long) {
            return Schema.Type.INT64;
        }
        if (value instanceof Float) {
            return Schema.Type.FLOAT32;
        }
        if (value instanceof Double) {
            return Schema.Type.FLOAT64;
        }
        if (value instanceof Boolean) {
            return Schema.Type.BOOLEAN;
        }
        if (value instanceof String) {
            return Schema.Type.STRING;
        }
        if (value instanceof Collection) {
            return Schema.Type.ARRAY;
        }
        if (value instanceof Map) {
            return Schema.Type.MAP;
        }
        throw new DataException("Unknown Java type for schemaless data: " + value.getClass());
    }

    private void addAvroRecordField(List<Schema.Field> fields, String fieldName, org.apache.kafka.connect.data.Schema fieldSchema, String fieldDoc) {
        Schema.Field field;
        Object defaultVal = null;
        if (fieldSchema.defaultValue() != null) {
            defaultVal = JacksonUtils.toObject((JsonNode)this.getDefaultValueFromConnect(fieldSchema, fieldSchema.defaultValue()));
        } else if (fieldSchema.isOptional()) {
            defaultVal = JsonProperties.NULL_VALUE;
        }
        Schema schema = this.fromConnectSchema(fieldSchema, true);
        try {
            field = new Schema.Field(fieldName, schema, fieldDoc != null ? fieldDoc : fieldSchema.doc(), defaultVal);
        }
        catch (AvroTypeException e) {
            field = new Schema.Field(fieldName, schema, fieldDoc != null ? fieldDoc : fieldSchema.doc());
        }
        fields.add(field);
    }

    private JsonNode getDefaultValueFromConnect(org.apache.kafka.connect.data.Schema schema, Object value) {
        try {
            if (value == null) {
                return NullNode.getInstance();
            }
            Object defaultVal = value;
            switch (schema.type()) {
                case INT8: {
                    return JsonNodeFactory.instance.numberNode(((Byte)defaultVal).intValue());
                }
                case INT16: {
                    return JsonNodeFactory.instance.numberNode(((Short)defaultVal).intValue());
                }
                case INT32: {
                    return JsonNodeFactory.instance.numberNode((Integer)defaultVal);
                }
                case INT64: {
                    return JsonNodeFactory.instance.numberNode((Long)defaultVal);
                }
                case FLOAT32: {
                    return JsonNodeFactory.instance.numberNode((Float)defaultVal);
                }
                case FLOAT64: {
                    return JsonNodeFactory.instance.numberNode((Double)defaultVal);
                }
                case BOOLEAN: {
                    return JsonNodeFactory.instance.booleanNode(((Boolean)defaultVal).booleanValue());
                }
                case STRING: {
                    return JsonNodeFactory.instance.textNode((String)defaultVal);
                }
                case BYTES: {
                    if (defaultVal instanceof byte[]) {
                        return JsonNodeFactory.instance.textNode(new String((byte[])defaultVal, StandardCharsets.ISO_8859_1));
                    }
                    return JsonNodeFactory.instance.textNode(new String(((ByteBuffer)defaultVal).array(), StandardCharsets.ISO_8859_1));
                }
                case ARRAY: {
                    ArrayNode array = JsonNodeFactory.instance.arrayNode();
                    for (Object elem : (Collection)defaultVal) {
                        array.add(this.getDefaultValueFromConnect(schema.valueSchema(), elem));
                    }
                    return array;
                }
                case MAP: {
                    if (schema.keySchema().type() == Schema.Type.STRING) {
                        ObjectNode node = JsonNodeFactory.instance.objectNode();
                        for (Map.Entry entry : ((Map)defaultVal).entrySet()) {
                            JsonNode entryDef = this.getDefaultValueFromConnect(schema.valueSchema(), entry.getValue());
                            node.set((String)entry.getKey(), entryDef);
                        }
                        return node;
                    }
                    ArrayNode array = JsonNodeFactory.instance.arrayNode();
                    for (Map.Entry entry : ((Map)defaultVal).entrySet()) {
                        JsonNode keyDefault = this.getDefaultValueFromConnect(schema.keySchema(), entry.getKey());
                        JsonNode valDefault = this.getDefaultValueFromConnect(schema.valueSchema(), entry.getValue());
                        ArrayNode jsonEntry = JsonNodeFactory.instance.arrayNode();
                        jsonEntry.add(keyDefault);
                        jsonEntry.add(valDefault);
                        array.add((JsonNode)jsonEntry);
                    }
                    return array;
                }
                case STRUCT: {
                    boolean isUnion = AVRO_TYPE_UNION.equals(schema.name());
                    ObjectNode node = JsonNodeFactory.instance.objectNode();
                    Struct struct = (Struct)defaultVal;
                    for (Field field : schema.fields()) {
                        String fieldName = field.name();
                        JsonNode fieldDef = this.getDefaultValueFromConnect(field.schema(), struct.get(field));
                        if (isUnion) {
                            return fieldDef;
                        }
                        node.set(fieldName, fieldDef);
                    }
                    return node;
                }
            }
            throw new DataException("Unknown schema type:" + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type used for default value of " + schema.type() + " field: " + schema.defaultValue().getClass());
        }
    }

    private Pair<String, String> getNameOrDefault(String name) {
        if (name != null) {
            String[] split = AvroConverterUtils.splitName(name);
            return Pair.of((Object)split[0], (Object)split[1]);
        }
        return Pair.of((Object)NAMESPACE, (Object)DEFAULT_SCHEMA_NAME);
    }

    private static String[] splitName(String fullName) {
        String[] result = new String[2];
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            result[0] = fullName.substring(0, indexLastDot);
            result[1] = fullName.substring(indexLastDot + 1);
        } else {
            result[0] = null;
            result[1] = fullName;
        }
        return result;
    }

    private boolean isInstanceOfAvroSchemaTypeForSimpleSchema(org.apache.kafka.connect.data.Schema fieldSchema, Object value, int index) {
        if (AvroConverterUtils.isEnumSchema(fieldSchema)) {
            String paramName = AVRO_TYPE_ENUM;
            String enumSchemaName = (String)fieldSchema.parameters().get(paramName);
            if (value instanceof GenericData.EnumSymbol) {
                return ((GenericData.EnumSymbol)value).getSchema().getFullName().equals(enumSchemaName);
            }
            return value.getClass().getName().equals(enumSchemaName);
        }
        List<Class> classes = SIMPLE_AVRO_SCHEMA_TYPES.get(fieldSchema.type());
        if (classes == null) {
            return false;
        }
        for (Class type : classes) {
            if (!type.isInstance(value)) continue;
            if (AvroConverterUtils.isFixedSchema(fieldSchema)) {
                if (!this.fixedValueSizeMatch(fieldSchema, value, Integer.parseInt((String)fieldSchema.parameters().get(CONNECT_AVRO_FIXED_SIZE_PROP)), index)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean fixedValueSizeMatch(org.apache.kafka.connect.data.Schema fieldSchema, Object value, int size, int index) {
        if (value instanceof byte[]) {
            return ((byte[])value).length == size;
        }
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).remaining() == size;
        }
        if (value instanceof GenericFixed) {
            return AvroConverterUtils.unionMemberFieldName(((GenericFixed)value).getSchema(), index).equals(AvroConverterUtils.unionMemberFieldName(fieldSchema, index));
        }
        throw new DataException("Invalid class for fixed, expecting GenericFixed, byte[] or ByteBuffer but found " + value.getClass());
    }

    private static String unionMemberFieldName(org.apache.kafka.connect.data.Schema schema, int index) {
        if (schema.type() == Schema.Type.STRUCT || AvroConverterUtils.isEnumSchema(schema) || AvroConverterUtils.isFixedSchema(schema)) {
            return AvroConverterUtils.splitName(schema.name())[1];
        }
        return CONNECT_TYPES_TO_AVRO_TYPES.get(schema.type()).getName();
    }

    private static boolean isFixedSchema(org.apache.kafka.connect.data.Schema schema) {
        return schema.type() == Schema.Type.BYTES && schema.name() != null && schema.parameters() != null && schema.parameters().containsKey(CONNECT_AVRO_FIXED_SIZE_PROP);
    }

    private static boolean isEnumSchema(org.apache.kafka.connect.data.Schema schema) {
        return schema.type() == Schema.Type.STRING && schema.parameters() != null && schema.parameters().containsKey(AVRO_TYPE_ENUM);
    }

    private Schema MakeOptional(org.apache.kafka.connect.data.Schema schema, Schema baseSchema) {
        if (!schema.isOptional()) {
            return baseSchema;
        }
        if (schema.defaultValue() != null) {
            return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(baseSchema)).and().nullType()).endUnion();
        }
        return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().type(baseSchema)).endUnion();
    }

    private GenericData.EnumSymbol enumSymbol(Schema avroSchema, Object value, String enumSchemaName) {
        Schema enumSchema;
        if (avroSchema.getType() == Schema.Type.UNION) {
            int enumIndex = avroSchema.getIndexNamed(enumSchemaName);
            enumSchema = (Schema)avroSchema.getTypes().get(enumIndex);
        } else {
            enumSchema = avroSchema;
        }
        return new GenericData.EnumSymbol(enumSchema, (String)value);
    }

    static {
        NON_AVRO_TYPES_BY_TYPE_CODE.put(CONNECT_TYPE_INT8, Schema.Type.INT8);
        NON_AVRO_TYPES_BY_TYPE_CODE.put(CONNECT_TYPE_INT16, Schema.Type.INT16);
        SIMPLE_AVRO_SCHEMA_TYPES = new HashMap<Schema.Type, List<Class>>();
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.INT32, Arrays.asList(Integer.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.INT64, Arrays.asList(Long.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.FLOAT32, Arrays.asList(Float.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.FLOAT64, Arrays.asList(Double.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.BOOLEAN, Arrays.asList(Boolean.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.STRING, Arrays.asList(CharSequence.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.BYTES, Arrays.asList(ByteBuffer.class, byte[].class, GenericFixed.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.ARRAY, Arrays.asList(Collection.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.MAP, Arrays.asList(Map.class));
        CONNECT_TYPES_TO_AVRO_TYPES = new HashMap<Schema.Type, Schema.Type>();
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.INT32, Schema.Type.INT);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.INT64, Schema.Type.LONG);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.FLOAT32, Schema.Type.FLOAT);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.FLOAT64, Schema.Type.DOUBLE);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.BOOLEAN, Schema.Type.BOOLEAN);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.STRING, Schema.Type.STRING);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.BYTES, Schema.Type.BYTES);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.ARRAY, Schema.Type.ARRAY);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.MAP, Schema.Type.MAP);
        CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT = 64;
        NULL_AVRO_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        ANYTHING_SCHEMA = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)AVRO_TYPE_ANYTHING).namespace(NAMESPACE)).fields().optionalBoolean(ANYTHING_SCHEMA_BOOLEAN_FIELD).optionalBytes(ANYTHING_SCHEMA_BYTES_FIELD).optionalDouble(ANYTHING_SCHEMA_DOUBLE_FIELD).optionalFloat(ANYTHING_SCHEMA_FLOAT_FIELD).optionalInt(ANYTHING_SCHEMA_INT_FIELD).optionalLong(ANYTHING_SCHEMA_LONG_FIELD).optionalString(ANYTHING_SCHEMA_STRING_FIELD).name(ANYTHING_SCHEMA_ARRAY_FIELD).type().optional().array().items().type(AVRO_TYPE_ANYTHING)).name(ANYTHING_SCHEMA_MAP_FIELD).type().optional().array().items().record(MAP_ENTRY_TYPE_NAME).namespace(NAMESPACE)).fields().name(KEY_FIELD).type(AVRO_TYPE_ANYTHING).noDefault().name(VALUE_FIELD).type(AVRO_TYPE_ANYTHING).noDefault().endRecord()).endRecord();
        ANYTHING_SCHEMA_MAP_ELEMENT = ((Schema)ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_MAP_FIELD).schema().getTypes().get(1)).getElementType();
    }
}

