/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.credential.TokenCredential;
import com.azure.core.models.MessageContent;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.KafkaAvroSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroKStreamSerializer<T>
implements Serializer<T> {
    private SchemaRegistryApacheAvroSerializer serializer;

    public void configure(Map<String, ?> props, boolean isKey) {
        KafkaAvroSerializerConfig config = new KafkaAvroSerializerConfig(props);
        TokenCredential tokenCredential = config.getCredential();
        if (tokenCredential == null) {
            if (config.createDefaultAzureCredential().booleanValue()) {
                tokenCredential = new DefaultAzureCredentialBuilder().build();
            } else {
                throw new RuntimeException("TokenCredential not created for serializer. Please provide a TokenCredential in config or set \"use.azure.credential\" to true.");
            }
        }
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryClient(new SchemaRegistryClientBuilder().fullyQualifiedNamespace(config.getSchemaRegistryUrl()).credential(tokenCredential).clientOptions(new ClientOptions().setApplicationId("java-avro-kafka-ser-1.0")).buildAsyncClient()).schemaGroup(config.getSchemaGroup()).autoRegisterSchemas(config.getAutoRegisterSchemas().booleanValue()).buildSerializer();
    }

    public byte[] serialize(String topic, T record) {
        if (record == null) {
            return null;
        }
        MessageContent message = this.serializer.serialize(record, TypeReference.createInstance(MessageContent.class));
        byte[] contentTypeHeaderBytes = message.getContentType().getBytes();
        byte[] body = message.getBodyAsBinaryData().toBytes();
        byte[] bytes = new byte[1 + contentTypeHeaderBytes.length + body.length];
        bytes[0] = (byte)contentTypeHeaderBytes.length;
        System.arraycopy(contentTypeHeaderBytes, 0, bytes, 1, contentTypeHeaderBytes.length);
        System.arraycopy(body, 0, bytes, 1 + contentTypeHeaderBytes.length, body.length);
        return bytes;
    }

    public byte[] serialize(String topic, Headers headers, T record) {
        if (record == null) {
            return null;
        }
        MessageContent message = this.serializer.serialize(record, TypeReference.createInstance(MessageContent.class));
        byte[] contentTypeHeaderBytes = message.getContentType().getBytes();
        headers.add("content-type", contentTypeHeaderBytes);
        return message.getBodyAsBinaryData().toBytes();
    }

    public void close() {
    }
}

