/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ServiceBusJmsConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private final JmsConnectionFactory factory;
    private ConnectionStringBuilder builder;

    public ServiceBusJmsConnectionFactory(String connectionString, ServiceBusJmsConnectionFactorySettings settings) {
        this(new ConnectionStringBuilder(connectionString), settings);
    }

    public ServiceBusJmsConnectionFactory(ConnectionStringBuilder connectionStringBuilder, ServiceBusJmsConnectionFactorySettings settings) {
        this(connectionStringBuilder.getSasKeyName(), connectionStringBuilder.getSasKey(), connectionStringBuilder.getEndpoint().getHost(), settings);
        this.builder = connectionStringBuilder;
    }

    public ServiceBusJmsConnectionFactory(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        if (sasKeyName == null || sasKeyName == null || host == null) {
            throw new IllegalArgumentException("SAS Key, SAS KeyName and the host cannot be null for a ServiceBus connection factory.");
        }
        String query = settings == null ? "" : settings.toQuery();
        this.factory = new JmsConnectionFactory(sasKeyName, sasKey, "amqps://" + host + query);
        this.factory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> {
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("com.microsoft:is-client-provider", true);
            return properties;
        });
    }

    JmsConnectionFactory getConectionFactory() {
        return this.factory;
    }

    public ConnectionStringBuilder getConnectionStringBuilder() {
        return this.builder;
    }

    public String getClientId() {
        return this.factory.getClientID();
    }

    public void setClientId(String clientId) {
        this.factory.setClientID(clientId);
    }

    public Connection createConnection() throws JMSException {
        return this.factory.createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.factory.createConnection(userName, password);
    }

    public JMSContext createContext() {
        return this.factory.createContext();
    }

    public JMSContext createContext(int sessionMode) {
        return this.factory.createContext(sessionMode);
    }

    public JMSContext createContext(String userName, String password) {
        return this.factory.createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.factory.createContext(userName, password, sessionMode);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.factory.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.factory.createTopicConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.factory.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.factory.createQueueConnection(userName, password);
    }
}

