package com.microsoft.azure.servicebus.jms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.jms.*;

import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsQueue;
import com.microsoft.azure.servicebus.ClientFactory;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageReceiver;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.TransactionContext;
import com.microsoft.azure.servicebus.management.ManagementClientAsync;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.primitives.Util;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import com.microsoft.azure.servicebus.rules.SqlFilter;

import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;

public class Sandbox {
    static Connection connection;
    
    public static void main(String[] args) throws Exception {
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings();
//        settings.setShouldReconnect(true);
//        settings.setMaxReconnectAttempts(30);
//        settings.setInitialReconnectDelay(100);
//        String[] hosts = new String[] { "contoso2.servicebus.onebox.windows-int.net", "bailiu-servicebus-test-premium.servicebus.windows.net"};
//        settings.setReconnectHosts(hosts);
//        settings.setReconnectRandomize(true);
//      ConnectionFactory cf = new JmsConnectionFactory("guest", "guest", "failover:(amqps://localhost:5672)");

//        ConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", settings);
//        connection = cf.createConnection();
//        connection.start();

//        tempQueue();
//        ServiceBusJmsConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://bailiu-servicebus-test-premium.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=YAiBfPVw+ffqk16I2mOJGWgn/+Y4x9iM11U+Q7/vtNc=", settings);
//        ServiceBusJmsConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", settings);
//        Connection connection = cf.createConnection();
////        connection.setClientID("myclientid");
//        Session session = connection.createSession();
//        
//        String topicName = "mytopic-" + UUID.randomUUID().toString().substring(0, 10);
//        Topic t = session.createTopic(topicName);
//        session.createProducer(t);
//        session.createConsumer(t);
//        System.out.println("Start Sleeping");
//        Thread.sleep(330000);
//        System.out.println("Stop Sleeping");
//        connection.close();
        
//        sendviaTest();
//        transactedSession();
//        JmsTransactedReplyTo();
        
        QueueReceive10MB();
    }

    static void sendviaTest() throws Exception {
        ConnectionStringBuilder builder = new ConnectionStringBuilder("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=");
        ManagementClientAsync managementClient = new ManagementClientAsync(builder);
        String guid = UUID.randomUUID().toString().substring(0, 10);
        QueueDescription qd = new QueueDescription("sendviaQueue-" + guid);
        QueueDescription qd2 = new QueueDescription("destinationQueue-" + guid);
        QueueDescription qd3 = new QueueDescription("destinationQueue2-" + guid);
        qd.setEnablePartitioning(true);
        qd2.setEnablePartitioning(true);
        qd3.setEnablePartitioning(true);

        try {
            managementClient.createQueueAsync(qd).join();
            managementClient.createQueueAsync(qd2).join();
            managementClient.createQueueAsync(qd3).join();
            MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder(builder);
            System.out.println("Creating first sender");
//            IMessageSender viaSender = ClientFactory.createMessageSenderFromEntityPathAsync(factory, qd2.getPath()).get();
            IMessageSender viaSender = ClientFactory.createTransferMessageSenderFromEntityPathAsync(factory, qd2.getPath(), qd.getPath()).get();
            System.out.println("Creating second sender");
//            IMessageSender viaSender2 = ClientFactory.createMessageSenderFromEntityPathAsync(factory, qd3.getPath()).get();
            IMessageSender viaSender2 = ClientFactory.createTransferMessageSenderFromEntityPathAsync(factory, qd3.getPath(), qd.getPath()).get();
//            System.out.println("Creating receiver");
//            IMessageReceiver q2Receiver = ClientFactory.createMessageReceiverFromEntityPath(factory, qd2.getPath(), ReceiveMode.PEEKLOCK);
            
            System.out.println("Creating transaction");
            TransactionContext transaction = factory.startTransactionAsync().get();
            System.out.println("Created transaction");
          
          com.microsoft.azure.servicebus.Message message = new com.microsoft.azure.servicebus.Message("my message");
          message.setPartitionKey("asd");
          message.setViaPartitionKey("asd");
          System.out.println("First sender sending");
          viaSender.send(message, transaction);
          System.out.println("Second sender sending");
          viaSender2.send(message, transaction);
          System.out.println("deleting");
//          managementClient.deleteQueueAsync(qd.getPath()).join();
//          System.out.println("deleted");

          Thread.sleep(2000);
          System.out.println("Committing");
          transaction.commit();
          System.out.println("Committed");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            managementClient.deleteQueueAsync(qd.getPath()).join();
            managementClient.deleteQueueAsync(qd2.getPath()).join();
            managementClient.close();
        }
    }
    
    static void transactedSession() throws Exception {
      Session session = connection.createSession(true, Session.CLIENT_ACKNOWLEDGE);
      Session session2 = connection.createSession();
      String guid = UUID.randomUUID().toString().substring(0, 10);
      Queue viaQueue = session.createQueue("viaQueue-" + guid);
      Queue destinationQueue = session.createQueue("desintationQueue-" + guid);
      MessageConsumer consumer1 = session2.createConsumer(destinationQueue);
      MessageConsumer viaConsumer = session.createConsumer(viaQueue);
      MessageProducer viaProducer = session.createProducer(viaQueue);
      
      Message message = session.createTextMessage("my message " + guid);
      message.setJMSReplyTo(destinationQueue);
      System.out.println("Sending to viaQueue");
      viaProducer.send(message);
      System.out.println("Commiting send to viaQueue");
      session.commit();
      System.out.println("Committed send to viaQueue");
  
      TextMessage received = (TextMessage)viaConsumer.receive();
      received.acknowledge();
      System.out.println("viaQueue received message: " + received.getText());
      Destination replyTo = received.getJMSReplyTo();
      Message message2 = session.createTextMessage("my message2 " + guid);
      
      MessageConsumer destinationConsumer = session2.createConsumer(destinationQueue);
      MessageProducer producer2 = session.createProducer(replyTo);
      System.out.println("Sending to desintationQueue");
      producer2.send(message2);
      System.out.println("Committing send to desintationQueue");
      session.commit();
      System.out.println("Committed send to desintationQueue");
      
      TextMessage received2 = (TextMessage)destinationConsumer.receive(2000);
      System.out.println("desintationQueue received message: " + received2.getText());
      
      message.acknowledge();
      session.commit();
      connection.close();
    }
    
    public static void JmsTransactedReplyTo() throws JMSException {
        String queueName = "MyQueue";
        String queueName2 = "MyQueue2";
        ConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", null);

        try (Connection connection = cf.createConnection()) {
            connection.start();
            
            System.out.println("Creating transacted session.");
            Session transactedSession = connection.createSession(true, Session.SESSION_TRANSACTED);
            System.out.println("Creating non transacted session for testing purposes.");
            Session nonTransactedSession = connection.createSession();
            
            Queue queue = transactedSession.createQueue(queueName);
            Queue queue2 = transactedSession.createQueue(queueName2);
            
            System.out.println("Creating non-transacted sender and transacted receiver on " + queueName);
            MessageProducer nonTransactedQueueProducer = nonTransactedSession.createProducer(queue);
            MessageConsumer transactedQueueConsumer = transactedSession.createConsumer(queue);
            
            System.out.println("Sending the message to " + queueName + " with ReplyTo set to " + queueName2);
            Message message = transactedSession.createTextMessage("Message with ReplyTo");
            message.setJMSReplyTo(queue2);
            nonTransactedQueueProducer.send(message);
            
            System.out.println("Receiving the message and sending to the ReplyTo destination as part of a transaction.");
            Message replyToMessage = transactedQueueConsumer.receive(5000);
            Destination replyToDestination = replyToMessage.getJMSReplyTo();
            replyToMessage.acknowledge();

            System.out.println("Sending to the ReplyTo destination within the same transaction");
            MessageProducer transactedReplyToProducer = transactedSession.createProducer(replyToDestination);
            MessageConsumer nonTransactedReplyToConsumer = nonTransactedSession.createConsumer(replyToDestination);
            transactedReplyToProducer.send(replyToMessage);
            
            System.out.println("Committing the transaction");
            transactedSession.commit();
            
            System.out.println("Receiving the messages to verify.");
            Message received = nonTransactedReplyToConsumer.receive(2000);
            if (received != null) {
                System.out.println("Received the message from consumer on ReplyTo destination.");
            } else {
                System.err.println("Did not receive the message from consumer on ReplyTo destination.");
            }
        }
    }
    
    public static void CrossEntityTransactionedSend() throws JMSException {
        String queueName = "MyQueue";
        String queueName2 = "MyQueue2";
        ConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", null);
        Connection connection = null; 
        
        try {
            connection = cf.createConnection();
            connection.start();
            
            // This creates the transacted session from the service
            Session session = connection.createSession(true, Session.SESSION_TRANSACTED);
            
            Queue queue = session.createQueue(queueName);
            // Creating this producer will create the queue from the service side, and will establish it as the "root" entity implicitly
            // Creating the consumer with this queue here will also establish the queue as the "root" entity implicitly
            System.out.println("Creating the transacted producer for " + queueName + ", establishing it as the root entity for this transaction");
            MessageProducer producer = session.createProducer(queue);
            
            // Create a different producer under a different queue with the same transacted session
            // Messages sent through this producer2 will be sent "root" the queue established earlier
            Queue queue2 = session.createQueue(queueName2);
            System.out.println("Creating the transacted producer for " + queueName2);
            MessageProducer producer2 = session.createProducer(queue2);
            
            // Creating non transacted consumers to verify the messages
            System.out.println("Creating non transacted session and consumers to verify the messages.");
            Session nonTransactedSession = connection.createSession();
            MessageConsumer consumer = nonTransactedSession.createConsumer(queue);
            MessageConsumer consumer2 = nonTransactedSession.createConsumer(queue2);
            
            // Send messages and commit the session
            System.out.println("Sending message to both queues.");
            producer.send(session.createTextMessage("message for " + queueName));
            producer2.send(session.createTextMessage("message for " + queueName2));
            session.commit();
            
            // Receive the messages to verify
            System.out.println("Receiving the messages to verify.");
            Message received = consumer.receive(2000);
            Message received2 = consumer2.receive(2000);
            
            if (received != null) {
                System.out.println("Received message from " + queueName);
            } else {
                System.err.println("Did not receive message from " + queueName);
            }
            
            if (received2 != null) {
                System.out.println("Received message from " + queueName2);
            } else {
                System.err.println("Did not receive message from " + queueName2);
            }
        } finally {
            connection.close();
        }
    }
    
//    static void partitionedViaTest() {
//        ConnectionStringBuilder builder = new ConnectionStringBuilder("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=");
//        ManagementClientAsync managementClient = new ManagementClientAsync(builder);
//        String guid = UUID.randomUUID().toString().substring(0, 10);
//        QueueDescription qd = new QueueDescription("sendviaQueue-" + guid);
//        QueueDescription qd2 = new QueueDescription("destinationQueue-" + guid);
//        QueueDescription qd3 = new QueueDescription("destinationQueue2-" + guid);
//        MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder(builder);
//
//        try {
//            managementClient.createQueueAsync(qd).join();
//            managementClient.createQueueAsync(qd2).join();
//            managementClient.createQueueAsync(qd3).join();
//
//    }
    
    static void tempQueue() throws Exception {
        Session session = connection.createSession();
        TemporaryQueue q = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer(q);
        MessageProducer producer = session.createProducer(q);
        producer.send(session.createMessage());
        
        System.out.println("====sleep start====");
        Thread.sleep(300000);
        System.out.println("====sleep end====");
        
        Message message = consumer.receive(2000);
        if (message == null) {
            throw new JMSException("null message");
        }
        connection.close(); 
    }
    
    static void transactedReceivers() throws Exception {
        Session session = connection.createSession(true, Session.CLIENT_ACKNOWLEDGE);
        String guid = UUID.randomUUID().toString().substring(0, 10);
        Queue q1 = session.createQueue("q1-" + guid);
        Queue q2 = session.createQueue("q2-" + guid);
        
        MessageConsumer consumer1 = session.createConsumer(q1, "MyProp = '1'");
        MessageConsumer consumer2 = session.createConsumer(q2, "MyProp = '2'");
        MessageProducer producer1 = session.createProducer(q1);
        MessageProducer producer2 = session.createProducer(q2);
        
        TextMessage message = session.createTextMessage("my message1 " + guid);
        message.setStringProperty("MyProp", "1");
        TextMessage message2 = session.createTextMessage("my message2 " + guid);
        message2.setStringProperty("MyProp", "2");
        producer1.send(message);
        producer2.send(message2);
        session.commit();
        TextMessage received1 = (TextMessage) consumer1.receive(1000);
        System.out.println("consumer1 received " + received1.getText());
        TextMessage received2 = (TextMessage) consumer2.receive(1000);
        System.out.println("consumer2 received " + received2.getText());
        session.commit();
        consumer1.close();
        consumer2.close();
        
        MessageConsumer consumer3 = session.createConsumer(q1);
        TextMessage received3 = (TextMessage) consumer3.receive(1000);
        System.out.println("consumer3 received " + received3.getText());
        session.commit();
    }
    
    private static final int DELIVERY_MODE = DeliveryMode.PERSISTENT;
    public static void QueueReceive10MB() throws Exception {
        
        Random rnd = new Random();
        int count = 10;
        int timeout = 1000;
        String qName = "QueueReceive10MB";
        PrintStream out = new PrintStream(new FileOutputStream(count + "messages-" + timeout + "ms" + ".txt"));
        System.setOut(out);

        try {
            /*
             * Initialize the JMS Connection and Session.
             */
            ConnectionFactory factory = new ServiceBusJmsConnectionFactory("Endpoint=sb://bailiu-servicebus-test-premium.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=YAiBfPVw+ffqk16I2mOJGWgn/+Y4x9iM11U+Q7/vtNc=", new ServiceBusJmsConnectionFactorySettings());
            Connection connection = factory.createConnection();

            Destination queue = new JmsQueue(qName);

            connection.setExceptionListener(new MyExceptionListener());
            connection.start();

            Session session = connection.createSession(false, Session.CLIENT_ACKNOWLEDGE);

            /*
             * Sending
             */

            MessageProducer messageProducer = session.createProducer(queue);

            long start = System.currentTimeMillis();
            for (int i = 1; i <= count; i++) {
                BytesMessage message = session.createBytesMessage();
                message.setStringProperty("MyMsgProperty", "MyMessageProp" + i);
                for (int j = 0; j < 10*1024; j++) {
                    byte[] bytes = new byte[1024];
                    rnd.nextBytes(bytes);
                    message.writeBytes(bytes); 
                } 
                
                messageProducer.send(message, DELIVERY_MODE, Message.DEFAULT_PRIORITY, Message.DEFAULT_TIME_TO_LIVE);

                if (i % 100 == 0) {
                    System.out.println("Sent message " + i);
                }
            }

            long finish = System.currentTimeMillis();
            long taken = finish - start;
            System.out.println("Sent " + count + " messages in " + taken + "ms");

            /*
             * Receiving
             */

            MessageConsumer messageConsumer = session.createConsumer(queue);
            Thread.sleep(2000);
            start = System.currentTimeMillis();

            int actualCount = 0;
            boolean deductTimeout = false;
            for (int i = 1; i <= count; i++, actualCount++) {
                System.out.println("Starting to receive message " + i);
                Message message = messageConsumer.receive(timeout);
                if (message == null) {
                    System.out.println("Message " + i + " not received within timeout, stopping.");
                    deductTimeout = true;
                    break;
                }
                message.acknowledge();
                System.out.println("Got message " + i);
            }

            finish = System.currentTimeMillis();
            taken = finish - start;
            if (deductTimeout) {
                taken -= timeout;
            }
            System.out.println("Received " + actualCount + " messages in " + taken + "ms");

            connection.close();
        } catch (Exception exp) {
            System.out.println("Caught exception, exiting.");
            exp.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private static class MyExceptionListener implements ExceptionListener {
        public void onException(JMSException exception) {
            System.out.println("Connection ExceptionListener fired, exiting.");
            exception.printStackTrace(System.out);
            System.exit(1);
        }
    }
}
