/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.ClientFactory;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.TransactionContext;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.microsoft.azure.servicebus.management.ManagementClientAsync;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Random;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.qpid.jms.JmsQueue;

public class Sandbox {
    static Connection connection;
    private static final int DELIVERY_MODE = 2;

    public static void main(String[] args) throws Exception {
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings();
        Sandbox.QueueReceive10MB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendviaTest() throws Exception {
        ConnectionStringBuilder builder = new ConnectionStringBuilder("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=");
        ManagementClientAsync managementClient = new ManagementClientAsync(builder);
        String guid = UUID.randomUUID().toString().substring(0, 10);
        QueueDescription qd = new QueueDescription("sendviaQueue-" + guid);
        QueueDescription qd2 = new QueueDescription("destinationQueue-" + guid);
        QueueDescription qd3 = new QueueDescription("destinationQueue2-" + guid);
        qd.setEnablePartitioning(true);
        qd2.setEnablePartitioning(true);
        qd3.setEnablePartitioning(true);
        try {
            managementClient.createQueueAsync(qd).join();
            managementClient.createQueueAsync(qd2).join();
            managementClient.createQueueAsync(qd3).join();
            MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder((ConnectionStringBuilder)builder);
            System.out.println("Creating first sender");
            IMessageSender viaSender = (IMessageSender)ClientFactory.createTransferMessageSenderFromEntityPathAsync((MessagingFactory)factory, (String)qd2.getPath(), (String)qd.getPath()).get();
            System.out.println("Creating second sender");
            IMessageSender viaSender2 = (IMessageSender)ClientFactory.createTransferMessageSenderFromEntityPathAsync((MessagingFactory)factory, (String)qd3.getPath(), (String)qd.getPath()).get();
            System.out.println("Creating transaction");
            TransactionContext transaction = (TransactionContext)factory.startTransactionAsync().get();
            System.out.println("Created transaction");
            Message message = new Message("my message");
            message.setPartitionKey("asd");
            message.setViaPartitionKey("asd");
            System.out.println("First sender sending");
            viaSender.send((IMessage)message, transaction);
            System.out.println("Second sender sending");
            viaSender2.send((IMessage)message, transaction);
            System.out.println("deleting");
            Thread.sleep(2000L);
            System.out.println("Committing");
            transaction.commit();
            System.out.println("Committed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            managementClient.deleteQueueAsync(qd.getPath()).join();
            managementClient.deleteQueueAsync(qd2.getPath()).join();
            managementClient.close();
        }
    }

    static void transactedSession() throws Exception {
        Session session = connection.createSession(true, 2);
        Session session2 = connection.createSession();
        String guid = UUID.randomUUID().toString().substring(0, 10);
        Queue viaQueue = session.createQueue("viaQueue-" + guid);
        Queue destinationQueue = session.createQueue("desintationQueue-" + guid);
        MessageConsumer consumer1 = session2.createConsumer((Destination)destinationQueue);
        MessageConsumer viaConsumer = session.createConsumer((Destination)viaQueue);
        MessageProducer viaProducer = session.createProducer((Destination)viaQueue);
        TextMessage message = session.createTextMessage("my message " + guid);
        message.setJMSReplyTo((Destination)destinationQueue);
        System.out.println("Sending to viaQueue");
        viaProducer.send((javax.jms.Message)message);
        System.out.println("Commiting send to viaQueue");
        session.commit();
        System.out.println("Committed send to viaQueue");
        TextMessage received = (TextMessage)viaConsumer.receive();
        received.acknowledge();
        System.out.println("viaQueue received message: " + received.getText());
        Destination replyTo = received.getJMSReplyTo();
        TextMessage message2 = session.createTextMessage("my message2 " + guid);
        MessageConsumer destinationConsumer = session2.createConsumer((Destination)destinationQueue);
        MessageProducer producer2 = session.createProducer(replyTo);
        System.out.println("Sending to desintationQueue");
        producer2.send((javax.jms.Message)message2);
        System.out.println("Committing send to desintationQueue");
        session.commit();
        System.out.println("Committed send to desintationQueue");
        TextMessage received2 = (TextMessage)destinationConsumer.receive(2000L);
        System.out.println("desintationQueue received message: " + received2.getText());
        message.acknowledge();
        session.commit();
        connection.close();
    }

    public static void JmsTransactedReplyTo() throws JMSException {
        String queueName = "MyQueue";
        String queueName2 = "MyQueue2";
        ServiceBusJmsConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", null);
        try (Connection connection = cf.createConnection();){
            connection.start();
            System.out.println("Creating transacted session.");
            Session transactedSession = connection.createSession(true, 0);
            System.out.println("Creating non transacted session for testing purposes.");
            Session nonTransactedSession = connection.createSession();
            Queue queue = transactedSession.createQueue(queueName);
            Queue queue2 = transactedSession.createQueue(queueName2);
            System.out.println("Creating non-transacted sender and transacted receiver on " + queueName);
            MessageProducer nonTransactedQueueProducer = nonTransactedSession.createProducer((Destination)queue);
            MessageConsumer transactedQueueConsumer = transactedSession.createConsumer((Destination)queue);
            System.out.println("Sending the message to " + queueName + " with ReplyTo set to " + queueName2);
            TextMessage message = transactedSession.createTextMessage("Message with ReplyTo");
            message.setJMSReplyTo((Destination)queue2);
            nonTransactedQueueProducer.send((javax.jms.Message)message);
            System.out.println("Receiving the message and sending to the ReplyTo destination as part of a transaction.");
            javax.jms.Message replyToMessage = transactedQueueConsumer.receive(5000L);
            Destination replyToDestination = replyToMessage.getJMSReplyTo();
            replyToMessage.acknowledge();
            System.out.println("Sending to the ReplyTo destination within the same transaction");
            MessageProducer transactedReplyToProducer = transactedSession.createProducer(replyToDestination);
            MessageConsumer nonTransactedReplyToConsumer = nonTransactedSession.createConsumer(replyToDestination);
            transactedReplyToProducer.send(replyToMessage);
            System.out.println("Committing the transaction");
            transactedSession.commit();
            System.out.println("Receiving the messages to verify.");
            javax.jms.Message received = nonTransactedReplyToConsumer.receive(2000L);
            if (received != null) {
                System.out.println("Received the message from consumer on ReplyTo destination.");
            } else {
                System.err.println("Did not receive the message from consumer on ReplyTo destination.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CrossEntityTransactionedSend() throws JMSException {
        String queueName = "MyQueue";
        String queueName2 = "MyQueue2";
        ServiceBusJmsConnectionFactory cf = new ServiceBusJmsConnectionFactory("Endpoint=sb://contoso.servicebus.onebox.windows-int.net/;SharedAccessKeyName=DefaultNamespaceSasAllKeyName;SharedAccessKey=8864/auVd3qDC75iTjBL1GJ4D2oXC6bIttRd0jzDZ+g=", null);
        try (Connection connection = null;){
            connection = cf.createConnection();
            connection.start();
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(queueName);
            System.out.println("Creating the transacted producer for " + queueName + ", establishing it as the root entity for this transaction");
            MessageProducer producer = session.createProducer((Destination)queue);
            Queue queue2 = session.createQueue(queueName2);
            System.out.println("Creating the transacted producer for " + queueName2);
            MessageProducer producer2 = session.createProducer((Destination)queue2);
            System.out.println("Creating non transacted session and consumers to verify the messages.");
            Session nonTransactedSession = connection.createSession();
            MessageConsumer consumer = nonTransactedSession.createConsumer((Destination)queue);
            MessageConsumer consumer2 = nonTransactedSession.createConsumer((Destination)queue2);
            System.out.println("Sending message to both queues.");
            producer.send((javax.jms.Message)session.createTextMessage("message for " + queueName));
            producer2.send((javax.jms.Message)session.createTextMessage("message for " + queueName2));
            session.commit();
            System.out.println("Receiving the messages to verify.");
            javax.jms.Message received = consumer.receive(2000L);
            javax.jms.Message received2 = consumer2.receive(2000L);
            if (received != null) {
                System.out.println("Received message from " + queueName);
            } else {
                System.err.println("Did not receive message from " + queueName);
            }
            if (received2 != null) {
                System.out.println("Received message from " + queueName2);
            } else {
                System.err.println("Did not receive message from " + queueName2);
            }
        }
    }

    static void tempQueue() throws Exception {
        Session session = connection.createSession();
        TemporaryQueue q = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)q);
        MessageProducer producer = session.createProducer((Destination)q);
        producer.send(session.createMessage());
        System.out.println("====sleep start====");
        Thread.sleep(300000L);
        System.out.println("====sleep end====");
        javax.jms.Message message = consumer.receive(2000L);
        if (message == null) {
            throw new JMSException("null message");
        }
        connection.close();
    }

    static void transactedReceivers() throws Exception {
        Session session = connection.createSession(true, 2);
        String guid = UUID.randomUUID().toString().substring(0, 10);
        Queue q1 = session.createQueue("q1-" + guid);
        Queue q2 = session.createQueue("q2-" + guid);
        MessageConsumer consumer1 = session.createConsumer((Destination)q1, "MyProp = '1'");
        MessageConsumer consumer2 = session.createConsumer((Destination)q2, "MyProp = '2'");
        MessageProducer producer1 = session.createProducer((Destination)q1);
        MessageProducer producer2 = session.createProducer((Destination)q2);
        TextMessage message = session.createTextMessage("my message1 " + guid);
        message.setStringProperty("MyProp", "1");
        TextMessage message2 = session.createTextMessage("my message2 " + guid);
        message2.setStringProperty("MyProp", "2");
        producer1.send((javax.jms.Message)message);
        producer2.send((javax.jms.Message)message2);
        session.commit();
        TextMessage received1 = (TextMessage)consumer1.receive(1000L);
        System.out.println("consumer1 received " + received1.getText());
        TextMessage received2 = (TextMessage)consumer2.receive(1000L);
        System.out.println("consumer2 received " + received2.getText());
        session.commit();
        consumer1.close();
        consumer2.close();
        MessageConsumer consumer3 = session.createConsumer((Destination)q1);
        TextMessage received3 = (TextMessage)consumer3.receive(1000L);
        System.out.println("consumer3 received " + received3.getText());
        session.commit();
    }

    public static void QueueReceive10MB() throws Exception {
        Random rnd = new Random();
        int count = 10;
        int timeout = 1000;
        String qName = "QueueReceive10MB";
        PrintStream out = new PrintStream(new FileOutputStream(count + "messages-" + timeout + "ms.txt"));
        System.setOut(out);
        try {
            ServiceBusJmsConnectionFactory factory = new ServiceBusJmsConnectionFactory("Endpoint=sb://bailiu-servicebus-test-premium.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=YAiBfPVw+ffqk16I2mOJGWgn/+Y4x9iM11U+Q7/vtNc=", new ServiceBusJmsConnectionFactorySettings());
            Connection connection = factory.createConnection();
            JmsQueue queue = new JmsQueue(qName);
            connection.setExceptionListener((ExceptionListener)new MyExceptionListener());
            connection.start();
            Session session = connection.createSession(false, 2);
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            long start = System.currentTimeMillis();
            for (int i = 1; i <= count; ++i) {
                BytesMessage message = session.createBytesMessage();
                message.setStringProperty("MyMsgProperty", "MyMessageProp" + i);
                for (int j = 0; j < 10240; ++j) {
                    byte[] bytes = new byte[1024];
                    rnd.nextBytes(bytes);
                    message.writeBytes(bytes);
                }
                messageProducer.send((javax.jms.Message)message, 2, 4, 0L);
                if (i % 100 != 0) continue;
                System.out.println("Sent message " + i);
            }
            long finish = System.currentTimeMillis();
            long taken = finish - start;
            System.out.println("Sent " + count + " messages in " + taken + "ms");
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            Thread.sleep(2000L);
            start = System.currentTimeMillis();
            int actualCount = 0;
            boolean deductTimeout = false;
            int i = 1;
            while (i <= count) {
                System.out.println("Starting to receive message " + i);
                javax.jms.Message message = messageConsumer.receive((long)timeout);
                if (message == null) {
                    System.out.println("Message " + i + " not received within timeout, stopping.");
                    deductTimeout = true;
                    break;
                }
                message.acknowledge();
                System.out.println("Got message " + i);
                ++i;
                ++actualCount;
            }
            finish = System.currentTimeMillis();
            taken = finish - start;
            if (deductTimeout) {
                taken -= (long)timeout;
            }
            System.out.println("Received " + actualCount + " messages in " + taken + "ms");
            connection.close();
        }
        catch (Exception exp) {
            System.out.println("Caught exception, exiting.");
            exp.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private static class MyExceptionListener
    implements ExceptionListener {
        private MyExceptionListener() {
        }

        public void onException(JMSException exception) {
            System.out.println("Connection ExceptionListener fired, exiting.");
            exception.printStackTrace(System.out);
            System.exit(1);
        }
    }
}

