/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnection;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsContext;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsQueueConnection;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsTopicConnection;
import com.microsoft.azure.servicebus.jms.jndi.JNDIStorable;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ServiceBusJmsConnectionFactory
extends JNDIStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final String CONNECTION_STRING_PROPERTY = "connectionString";
    private static final String CLIENT_ID_PROPERTY = "clientId";
    private static final int MaxCustomUserAgentLength = 128;
    private final ServiceBusJmsConnectionFactorySettings settings;
    private volatile boolean initialized;
    private JmsConnectionFactory factory;
    private ConnectionStringBuilder builder;
    private String customUserAgent;

    public ServiceBusJmsConnectionFactory() {
        this.settings = null;
    }

    public ServiceBusJmsConnectionFactory(String connectionString, ServiceBusJmsConnectionFactorySettings settings) {
        this(new ConnectionStringBuilder(connectionString), settings);
    }

    public ServiceBusJmsConnectionFactory(ConnectionStringBuilder connectionStringBuilder, ServiceBusJmsConnectionFactorySettings settings) {
        this.builder = connectionStringBuilder;
        this.settings = settings;
        this.initialize(connectionStringBuilder.getSasKeyName(), connectionStringBuilder.getSasKey(), connectionStringBuilder.getEndpoint().getHost(), settings);
    }

    public ServiceBusJmsConnectionFactory(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        this.settings = settings;
        this.initialize(sasKeyName, sasKey, host, settings);
    }

    private void initialize(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        if (sasKeyName == null || sasKeyName == null || host == null) {
            throw new IllegalArgumentException("SAS Key, SAS KeyName and the host cannot be null for a ServiceBus connection factory.");
        }
        if (settings == null) {
            settings = new ServiceBusJmsConnectionFactorySettings();
        }
        if (this.builder == null) {
            try {
                this.builder = new ConnectionStringBuilder(new URI(host), null, sasKeyName, sasKey);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        String destinationUri = "amqps://" + host;
        if (settings.shouldReconnect()) {
            destinationUri = this.getReconnectUri(destinationUri, settings);
        }
        String serviceBusQuery = settings.getServiceBusQuery();
        destinationUri = destinationUri + serviceBusQuery;
        this.factory = new JmsConnectionFactory(sasKeyName, sasKey, destinationUri);
        this.factory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("com.microsoft:is-client-provider", true);
            String servicebusJmsVersion = "";
            Properties applicationProperties = new Properties();
            try {
                applicationProperties.load(this.getClass().getClassLoader().getResourceAsStream("application.properties"));
                servicebusJmsVersion = applicationProperties.getProperty("azure.servicebus.jms.version");
            }
            catch (IOException e) {
                servicebusJmsVersion = "unknown";
            }
            StringBuilder userAgent = new StringBuilder("ServiceBusJms");
            userAgent.append("-").append(servicebusJmsVersion);
            if (this.customUserAgent != null && this.customUserAgent.length() > 0) {
                userAgent.append("/").append(this.customUserAgent);
            }
            properties.put("user-agent", userAgent.toString());
            return properties;
        });
        Supplier<ProxyHandler> proxyHandlerSupplier = settings.getProxyHandlerSupplier();
        if (proxyHandlerSupplier != null) {
            this.factory.setExtension(JmsConnectionExtensions.PROXY_HANDLER_SUPPLIER.toString(), (connection, remote) -> proxyHandlerSupplier);
        }
        this.initialized = true;
    }

    public ConnectionStringBuilder getConnectionStringBuilder() {
        return this.builder;
    }

    public String getClientId() {
        return this.factory.getClientID();
    }

    public void setClientId(String clientId) {
        this.factory.setClientID(clientId);
    }

    public ServiceBusJmsConnectionFactorySettings getSettings() {
        return this.settings;
    }

    public Connection createConnection() throws JMSException {
        this.ensureInitialized();
        Connection innerConnection = this.factory.createConnection();
        return new ServiceBusJmsConnection(innerConnection);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        this.ensureInitialized();
        Connection innerConnection = this.factory.createConnection(userName, password);
        return new ServiceBusJmsConnection(innerConnection);
    }

    public JMSContext createContext() {
        this.ensureInitialized();
        JMSContext innerContext = this.factory.createContext();
        return new ServiceBusJmsContext(innerContext);
    }

    public JMSContext createContext(int sessionMode) {
        this.ensureInitialized();
        JMSContext innerContext = this.factory.createContext(sessionMode);
        return new ServiceBusJmsContext(innerContext);
    }

    public JMSContext createContext(String userName, String password) {
        this.ensureInitialized();
        JMSContext innerContext = this.factory.createContext(userName, password);
        return new ServiceBusJmsContext(innerContext);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        this.ensureInitialized();
        JMSContext innerContext = this.factory.createContext(userName, password, sessionMode);
        return new ServiceBusJmsContext(innerContext);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.ensureInitialized();
        TopicConnection innerTopicConnection = this.factory.createTopicConnection();
        return new ServiceBusJmsTopicConnection(innerTopicConnection);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        this.ensureInitialized();
        TopicConnection innerTopicConnection = this.factory.createTopicConnection(userName, password);
        return new ServiceBusJmsTopicConnection(innerTopicConnection);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.ensureInitialized();
        QueueConnection innerQueueConnection = this.factory.createQueueConnection();
        return new ServiceBusJmsQueueConnection(innerQueueConnection);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        this.ensureInitialized();
        QueueConnection innerQueueConnection = this.factory.createQueueConnection(userName, password);
        return new ServiceBusJmsQueueConnection(innerQueueConnection);
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String connectionString = this.builder == null ? null : this.builder.toString();
        properties.put(CONNECTION_STRING_PROPERTY, connectionString);
        if (this.factory != null && StringUtil.isNullOrEmpty((String)this.getClientId())) {
            properties.put(CLIENT_ID_PROPERTY, this.getClientId());
        }
        return Collections.unmodifiableMap(properties);
    }

    @Override
    protected void setProperties(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("The given properties should not be null.");
        }
        String connectionString = null;
        String clientId = null;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            if (propertyName == null) continue;
            if (propertyName.equalsIgnoreCase(CONNECTION_STRING_PROPERTY)) {
                connectionString = property.getValue();
            }
            if (!propertyName.equalsIgnoreCase(CLIENT_ID_PROPERTY)) continue;
            clientId = property.getValue();
        }
        this.checkRequiredProperty(CONNECTION_STRING_PROPERTY, connectionString);
        this.builder = new ConnectionStringBuilder(connectionString);
        this.initialize(this.builder.getSasKeyName(), this.builder.getSasKey(), this.builder.getEndpoint().getHost(), null);
        if (!StringUtil.isNullOrEmpty((String)clientId)) {
            this.setClientId(clientId);
        }
    }

    ConnectionFactory getConectionFactory() {
        return this.factory;
    }

    protected String getCustomUserAgent() {
        return this.customUserAgent;
    }

    protected void setCustomUserAgent(String customUserAgent) {
        if (customUserAgent != null && customUserAgent.length() > 128) {
            throw new IllegalArgumentException("The length of the custom userAgent cannot exceed 128");
        }
        this.customUserAgent = customUserAgent;
    }

    private String getReconnectUri(String originalHost, ServiceBusJmsConnectionFactorySettings settings) {
        StringBuilder builder = new StringBuilder("failover:(");
        builder.append(originalHost);
        String[] reconnectHosts = settings.getReconnectHosts();
        if (settings.getReconnectHosts() != null) {
            String serviceBusQuery = settings.getServiceBusQuery();
            for (String reconnectHost : reconnectHosts) {
                builder.append(",");
                builder.append("amqps://");
                builder.append(reconnectHost);
                builder.append(serviceBusQuery);
            }
        }
        builder.append(")");
        builder.append(settings.getReconnectQuery());
        return builder.toString();
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new RuntimeException("This ServiceBusJmsConnectionFactory object is not initialized with the proper parameters.");
        }
    }
}

