/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ReconnectAmqpOpenServerListAction;
import io.netty.handler.proxy.ProxyHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ServiceBusJmsConnectionFactorySettings {
    private static Map<String, String> DefaultConfigurationOptions = ServiceBusJmsConnectionFactorySettings.getDefaultConfigurationOptions();
    static final String IsClientProvider = "com.microsoft:is-client-provider";
    private long connectionIdleTimeoutMS;
    private Supplier<ProxyHandler> proxyHandlerSupplier;
    private boolean traceFrames;
    private Map<String, String> configurationOptions;
    private boolean shouldReconnect = true;
    private String[] reconnectHosts;
    private Long initialReconnectDelay;
    private Long reconnectDelay;
    private Long maxReconnectDelay;
    private Boolean useReconnectBackOff;
    private Double reconnectBackOffMultiplier;
    private Integer maxReconnectAttempts;
    private Integer startupMaxReconnectAttempts;
    private Integer warnAfterReconnectAttempts;
    private Boolean reconnectRandomize;
    private ReconnectAmqpOpenServerListAction reconnectAmqpOpenServerListAction;

    public ServiceBusJmsConnectionFactorySettings() {
    }

    public ServiceBusJmsConnectionFactorySettings(long connectionIdleTimeoutMS, boolean traceFrames) {
        this.connectionIdleTimeoutMS = connectionIdleTimeoutMS;
        this.traceFrames = traceFrames;
    }

    public ServiceBusJmsConnectionFactorySettings(Map<String, String> configurationOptions) {
        this.configurationOptions = configurationOptions;
    }

    public long getConnectionIdleTimeoutMS() {
        return this.connectionIdleTimeoutMS;
    }

    public void setConnectionIdleTimeoutMS(long connectionIdleTimeoutMS) {
        this.connectionIdleTimeoutMS = connectionIdleTimeoutMS;
    }

    public Supplier<ProxyHandler> getProxyHandlerSupplier() {
        return this.proxyHandlerSupplier;
    }

    public void setProxyHandlerSupplier(Supplier<ProxyHandler> proxyHandlerSupplier) {
        this.proxyHandlerSupplier = proxyHandlerSupplier;
    }

    public boolean isTraceFrames() {
        return this.traceFrames;
    }

    public void setTraceFrames(boolean traceFrames) {
        this.traceFrames = traceFrames;
    }

    public Map<String, String> getConfigurationOptions() {
        return this.configurationOptions;
    }

    public boolean shouldReconnect() {
        return this.shouldReconnect;
    }

    public void setShouldReconnect(boolean shouldReconnect) {
        this.shouldReconnect = shouldReconnect;
    }

    public String[] getReconnectHosts() {
        return this.reconnectHosts;
    }

    public void setReconnectHosts(String[] reconnectHosts) {
        this.reconnectHosts = reconnectHosts;
    }

    public Long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public Long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public Long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public Boolean useReconnectBackOff() {
        return this.useReconnectBackOff;
    }

    public void setUseReconnectBackOff(boolean useReconnectBackOff) {
        this.useReconnectBackOff = useReconnectBackOff;
    }

    public Double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public Integer getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public Integer getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public Integer getWarnAfterReconnectAttempts() {
        return this.warnAfterReconnectAttempts;
    }

    public void setWarnAfterReconnectAttempts(int warnAfterReconnectAttempts) {
        this.warnAfterReconnectAttempts = warnAfterReconnectAttempts;
    }

    public Boolean shouldReconnectRandomize() {
        return this.reconnectRandomize;
    }

    public void setReconnectRandomize(boolean randomize) {
        this.reconnectRandomize = randomize;
    }

    public ReconnectAmqpOpenServerListAction getReconnectAmqpOpenServerListAction() {
        return this.reconnectAmqpOpenServerListAction;
    }

    public void setReconnectAmqpOpenServerListAction(ReconnectAmqpOpenServerListAction amqpOpenServerListAction) {
        this.reconnectAmqpOpenServerListAction = amqpOpenServerListAction;
    }

    String getServiceBusQuery() {
        StringBuilder builder = new StringBuilder();
        if (this.connectionIdleTimeoutMS > 0L) {
            this.appendQuery(builder, "amqp.idleTimeout", String.valueOf(this.connectionIdleTimeoutMS));
        }
        if (this.traceFrames) {
            this.appendQuery(builder, "amqp.traceFrames", "true");
        }
        if (this.configurationOptions == null) {
            this.configurationOptions = new HashMap<String, String>();
        }
        for (String defaultOption : DefaultConfigurationOptions.keySet()) {
            if (this.configurationOptions.containsKey(defaultOption)) continue;
            this.configurationOptions.put(defaultOption, DefaultConfigurationOptions.get(defaultOption));
        }
        for (String option : this.configurationOptions.keySet()) {
            this.appendQuery(builder, option, this.configurationOptions.get(option));
        }
        return builder.toString();
    }

    String getReconnectQuery() {
        StringBuilder queryBuilder = new StringBuilder();
        if (this.initialReconnectDelay != null) {
            this.appendQuery(queryBuilder, "failover.initialReconnectDelay", String.valueOf(this.initialReconnectDelay));
        }
        if (this.reconnectDelay != null) {
            this.appendQuery(queryBuilder, "failover.reconnectDelay", String.valueOf(this.reconnectDelay));
        }
        if (this.maxReconnectDelay != null) {
            this.appendQuery(queryBuilder, "failover.maxReconnectDelay", String.valueOf(this.maxReconnectDelay));
        }
        if (this.useReconnectBackOff != null) {
            this.appendQuery(queryBuilder, "failover.useReconnectBackOff", String.valueOf(this.useReconnectBackOff));
        }
        if (this.reconnectBackOffMultiplier != null) {
            this.appendQuery(queryBuilder, "failover.reconnectBackOffMultiplier", String.valueOf(this.reconnectBackOffMultiplier));
        }
        if (this.maxReconnectAttempts != null) {
            this.appendQuery(queryBuilder, "failover.maxReconnectAttempts", String.valueOf(this.maxReconnectAttempts));
        }
        if (this.startupMaxReconnectAttempts != null) {
            this.appendQuery(queryBuilder, "failover.startupMaxReconnectAttempts", String.valueOf(this.startupMaxReconnectAttempts));
        }
        if (this.warnAfterReconnectAttempts != null) {
            this.appendQuery(queryBuilder, "failover.warnAfterReconnectAttempts", String.valueOf(this.warnAfterReconnectAttempts));
        }
        if (this.reconnectRandomize != null) {
            this.appendQuery(queryBuilder, "failover.randomize", String.valueOf(this.reconnectRandomize));
        }
        if (this.reconnectAmqpOpenServerListAction != null) {
            this.appendQuery(queryBuilder, "failover.amqpOpenServerListAction", this.reconnectAmqpOpenServerListAction.name());
        }
        return queryBuilder.toString();
    }

    private void appendQuery(StringBuilder builder, String key, String value) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        builder.append(builder.length() == 0 ? "?" : "&").append(key).append("=").append(value);
    }

    private static Map<String, String> getDefaultConfigurationOptions() {
        HashMap<String, String> defaultConfigurationOptions = new HashMap<String, String>();
        defaultConfigurationOptions.put("jms.prefetchPolicy.all", "0");
        return defaultConfigurationOptions;
    }
}

