/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.IllegalConnectionStringFormatException;
import com.microsoft.azure.servicebus.jms.StringUtil;
import com.microsoft.azure.servicebus.jms.TransportType;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionStringBuilder {
    private static final String END_POINT_RAW_FORMAT = "amqps://%s";
    private static final String HOSTNAME_CONFIG_NAME = "Hostname";
    private static final String ENDPOINT_CONFIG_NAME = "Endpoint";
    private static final String SHARED_ACCESS_KEY_NAME_CONFIG_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY_CONFIG_NAME = "SharedAccessKey";
    private static final String ALTERNATE_SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME = "SharedAccessSignature";
    private static final String SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME = "SharedAccessSignatureToken";
    private static final String TRANSPORT_TYPE_CONFIG_NAME = "TransportType";
    private static final String ENTITY_PATH_CONFIG_NAME = "EntityPath";
    private static final String OPERATION_TIMEOUT_CONFIG_NAME = "OperationTimeout";
    private static final String AUTHENTICATION_CONFIG_NAME = "Authentication";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String KEY_VALUE_PAIR_DELIMITER = ";";
    private static final String ALL_KEY_ENUMERATE_REGEX = "(" + String.join((CharSequence)"|", "Hostname", "Endpoint", "SharedAccessKeyName", "SharedAccessKey", "SharedAccessSignatureToken", "EntityPath", "OperationTimeout", "SharedAccessSignature", "TransportType", "Authentication", ")");
    private static final String KEYS_WITH_DELIMITERS_REGEX = ";" + ALL_KEY_ENUMERATE_REGEX + "=";
    private String connectionString;
    private URI endpoint;
    private String authentication;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String sharedAccessSignatureToken;
    private String sharedAccessSignatureTokenKeyName;
    private String entityPath;
    private Duration operationTimeout;
    private TransportType transportType;
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(30L);

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, Duration operationTimeout) {
        this.endpoint = endpointAddress;
        this.operationTimeout = operationTimeout;
        this.entityPath = entityPath;
    }

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout) {
        this(endpointAddress, entityPath, operationTimeout);
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessSignatureToken, Duration operationTimeout) {
        this(endpointAddress, entityPath, operationTimeout);
        this.sharedAccessSignatureToken = sharedAccessSignatureToken;
    }

    private ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout) {
        this(ConnectionStringBuilder.convertNamespaceToEndPointURI(namespaceName), entityPath, sharedAccessKeyName, sharedAccessKey, operationTimeout);
    }

    private ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessSignatureToken, Duration operationTimeout) {
        this(ConnectionStringBuilder.convertNamespaceToEndPointURI(namespaceName), entityPath, sharedAccessSignatureToken, operationTimeout);
    }

    public ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(namespaceName, entityPath, sharedAccessKeyName, sharedAccessKey, DefaultOperationTimeout);
    }

    public ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessSignature) {
        this(namespaceName, entityPath, sharedAccessSignature, DefaultOperationTimeout);
    }

    public ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(endpointAddress, entityPath, sharedAccessKeyName, sharedAccessKey, DefaultOperationTimeout);
    }

    public ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessSignature) {
        this(endpointAddress, entityPath, sharedAccessSignature, DefaultOperationTimeout);
    }

    public ConnectionStringBuilder(String connectionString) {
        this.parseConnectionString(connectionString);
    }

    public ConnectionStringBuilder(String namespaceConnectionString, String entityPath) {
        this(namespaceConnectionString);
        this.entityPath = entityPath;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getSasKey() {
        return this.sharedAccessKey;
    }

    public String getSasKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessSignatureToken() {
        return this.sharedAccessSignatureToken;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout == null ? DefaultOperationTimeout : this.operationTimeout;
    }

    public void setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public TransportType getTransportType() {
        return this.transportType == null ? TransportType.AMQP : this.transportType;
    }

    public ConnectionStringBuilder setTransportType(TransportType transportType) {
        this.transportType = transportType;
        return this;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String toString() {
        if (StringUtil.isNullOrWhiteSpace(this.connectionString)) {
            StringBuilder connectionStringBuilder = new StringBuilder();
            if (this.endpoint != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENDPOINT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.endpoint.toString(), KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENTITY_PATH_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.entityPath, KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SHARED_ACCESS_KEY_NAME_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKeyName, KEY_VALUE_PAIR_DELIMITER));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s", SHARED_ACCESS_KEY_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKey));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessSignatureToken)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s", this.sharedAccessSignatureTokenKeyName, KEY_VALUE_SEPARATOR, this.sharedAccessSignatureToken));
            }
            if (this.operationTimeout != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KEY_VALUE_PAIR_DELIMITER, OPERATION_TIMEOUT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.operationTimeout.toString()));
            }
            if (this.transportType != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KEY_VALUE_PAIR_DELIMITER, TRANSPORT_TYPE_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.transportType.toString()));
            }
            if (this.authentication != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KEY_VALUE_PAIR_DELIMITER, AUTHENTICATION_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.authentication));
            }
            this.connectionString = connectionStringBuilder.toString();
        }
        return this.connectionString;
    }

    public String toLoggableString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        if (this.endpoint != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENDPOINT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.endpoint.toString(), KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENTITY_PATH_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.entityPath, KEY_VALUE_PAIR_DELIMITER));
        }
        return connectionStringBuilder.toString();
    }

    private static URI convertNamespaceToEndPointURI(String namespaceName) {
        try {
            return new URI(String.format(Locale.US, "amqps://%s.servicebus.windows.net", namespaceName));
        }
        catch (URISyntaxException exception) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid namespace name: %s", namespaceName), exception);
        }
    }

    private void parseConnectionString(String connectionString) {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalConnectionStringFormatException(String.format("connectionString cannot be empty", new Object[0]));
        }
        String connection = KEY_VALUE_PAIR_DELIMITER + connectionString;
        Pattern keyValuePattern = Pattern.compile(KEYS_WITH_DELIMITERS_REGEX, 2);
        String[] values = keyValuePattern.split(connection);
        Matcher keys = keyValuePattern.matcher(connection);
        if (values == null || values.length <= 1 || keys.groupCount() == 0) {
            throw new IllegalConnectionStringFormatException("Connection String cannot be parsed.");
        }
        if (!StringUtil.isNullOrWhiteSpace(values[0])) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Cannot parse part of ConnectionString: %s", values[0]));
        }
        int valueIndex = 0;
        while (keys.find()) {
            String key = keys.group();
            key = key.substring(1, key.length() - 1);
            if (values.length < ++valueIndex + 1) {
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Value for the connection string parameter name: %s, not found", key));
            }
            if (key.equalsIgnoreCase(ENDPOINT_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOSTNAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(values[valueIndex]);
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be in format scheme://fullyQualifiedServiceBusNamespaceEndpointName", ENDPOINT_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(HOSTNAME_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOSTNAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(String.format(Locale.US, END_POINT_RAW_FORMAT, values[valueIndex]));
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be a fully quantified host name address", HOSTNAME_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_NAME_CONFIG_NAME)) {
                if (this.authentication != null) {
                    throw new IllegalConnectionStringFormatException(String.format("Cannot have values specified for properties '%s' and '%s' at the same time", SHARED_ACCESS_KEY_NAME_CONFIG_NAME, AUTHENTICATION_CONFIG_NAME));
                }
                this.sharedAccessKeyName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_CONFIG_NAME)) {
                if (this.authentication != null) {
                    throw new IllegalConnectionStringFormatException(String.format("Cannot have values specified for properties '%s' and '%s' at the same time", SHARED_ACCESS_KEY_CONFIG_NAME, AUTHENTICATION_CONFIG_NAME));
                }
                this.sharedAccessKey = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME)) {
                if (this.authentication != null) {
                    throw new IllegalConnectionStringFormatException(String.format("Cannot have values specified for properties '%s' and '%s' at the same time", SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME, AUTHENTICATION_CONFIG_NAME));
                }
                this.sharedAccessSignatureToken = values[valueIndex];
                this.sharedAccessSignatureTokenKeyName = SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME;
                continue;
            }
            if (key.equalsIgnoreCase(ALTERNATE_SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME)) {
                if (this.authentication != null) {
                    throw new IllegalConnectionStringFormatException(String.format("Cannot have values specified for properties '%s' and '%s' at the same time", ALTERNATE_SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME, AUTHENTICATION_CONFIG_NAME));
                }
                this.sharedAccessSignatureToken = values[valueIndex];
                this.sharedAccessSignatureTokenKeyName = ALTERNATE_SHARED_ACCESS_SIGNATURE_TOKEN_CONFIG_NAME;
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH_CONFIG_NAME)) {
                this.entityPath = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(OPERATION_TIMEOUT_CONFIG_NAME)) {
                try {
                    this.operationTimeout = Duration.parse(values[valueIndex]);
                    continue;
                }
                catch (DateTimeParseException exception) {
                    throw new IllegalConnectionStringFormatException("Invalid value specified for property 'Duration' in the ConnectionString.", exception);
                }
            }
            if (key.equalsIgnoreCase(TRANSPORT_TYPE_CONFIG_NAME)) {
                try {
                    this.transportType = TransportType.fromString(values[valueIndex]);
                    continue;
                }
                catch (IllegalArgumentException exception) {
                    throw new IllegalConnectionStringFormatException(String.format("Invalid value specified for property '%s' in the ConnectionString.", TRANSPORT_TYPE_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(AUTHENTICATION_CONFIG_NAME)) {
                if (this.sharedAccessKeyName != null || this.sharedAccessKey != null || this.sharedAccessSignatureToken != null) {
                    throw new IllegalConnectionStringFormatException(String.format("Cannot have values specified for properties '%s' and Shared Access Token at the same time", AUTHENTICATION_CONFIG_NAME));
                }
                this.authentication = values[valueIndex];
                continue;
            }
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
    }
}

