/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.jndi.JNDIStorable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Queue;
import org.apache.qpid.jms.JmsQueue;

public final class ServiceBusJmsQueue
extends JNDIStorable
implements Queue {
    static final String NAME_PROPERTY = "physicalName";
    private Queue innerQueue;

    public ServiceBusJmsQueue() {
    }

    ServiceBusJmsQueue(Queue innerQueue) {
        this.innerQueue = innerQueue;
    }

    public String getQueueName() throws JMSException {
        return this.innerQueue.getQueueName();
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            String name = this.getQueueName();
            properties.put(NAME_PROPERTY, name);
        }
        catch (JMSException exception) {
            String errorMsg = "Cannot get queue name due to exception: " + exception.getMessage();
            throw new JMSRuntimeException(errorMsg, "", (Throwable)exception);
        }
        return Collections.unmodifiableMap(properties);
    }

    @Override
    protected void setProperties(Map<String, String> properties) {
        String name = null;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(NAME_PROPERTY)) continue;
            name = entry.getValue();
        }
        this.checkRequiredProperty(NAME_PROPERTY, name);
        JmsQueue innerQueue = new JmsQueue(name);
        this.innerQueue = innerQueue;
    }
}

