/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.jndi.JNDIStorable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Topic;
import org.apache.qpid.jms.JmsTopic;

public final class ServiceBusJmsTopic
extends JNDIStorable
implements Topic {
    static final String NAME_PROPERTY = "physicalName";
    private Topic innerTopic;

    public ServiceBusJmsTopic() {
    }

    ServiceBusJmsTopic(Topic innerTopic) {
        this.innerTopic = innerTopic;
    }

    public String getTopicName() throws JMSException {
        return this.innerTopic.getTopicName();
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            String name = this.getTopicName();
            properties.put(NAME_PROPERTY, name);
        }
        catch (JMSException exception) {
            String errorMsg = "Cannot get topic name due to exception: " + exception.getMessage();
            throw new JMSRuntimeException(errorMsg, "", (Throwable)exception);
        }
        return Collections.unmodifiableMap(properties);
    }

    @Override
    protected void setProperties(Map<String, String> properties) {
        String name = null;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(NAME_PROPERTY)) continue;
            name = entry.getValue();
        }
        this.checkRequiredProperty(NAME_PROPERTY, name);
        JmsTopic innerTopic = new JmsTopic(name);
        this.innerTopic = innerTopic;
    }
}

