/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterResponseAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.servicebus.ServiceBusContract;
import com.microsoft.windowsazure.services.servicebus.implementation.BrokerProperties;
import com.microsoft.windowsazure.services.servicebus.implementation.BrokerPropertiesMapper;
import com.microsoft.windowsazure.services.servicebus.implementation.CustomPropertiesMapper;
import com.microsoft.windowsazure.services.servicebus.implementation.Entry;
import com.microsoft.windowsazure.services.servicebus.implementation.Feed;
import com.microsoft.windowsazure.services.servicebus.implementation.SasFilter;
import com.microsoft.windowsazure.services.servicebus.implementation.ServiceBusConnectionSettings;
import com.microsoft.windowsazure.services.servicebus.implementation.WrapFilter;
import com.microsoft.windowsazure.services.servicebus.models.AbstractListOptions;
import com.microsoft.windowsazure.services.servicebus.models.BrokeredMessage;
import com.microsoft.windowsazure.services.servicebus.models.CreateEventHubResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateQueueResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateRuleResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateSubscriptionResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateTopicResult;
import com.microsoft.windowsazure.services.servicebus.models.EventHubInfo;
import com.microsoft.windowsazure.services.servicebus.models.GetEventHubResult;
import com.microsoft.windowsazure.services.servicebus.models.GetQueueResult;
import com.microsoft.windowsazure.services.servicebus.models.GetRuleResult;
import com.microsoft.windowsazure.services.servicebus.models.GetSubscriptionResult;
import com.microsoft.windowsazure.services.servicebus.models.GetTopicResult;
import com.microsoft.windowsazure.services.servicebus.models.ListEventHubsOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListEventHubsResult;
import com.microsoft.windowsazure.services.servicebus.models.ListQueuesOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListQueuesResult;
import com.microsoft.windowsazure.services.servicebus.models.ListRulesOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListRulesResult;
import com.microsoft.windowsazure.services.servicebus.models.ListSubscriptionsOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListSubscriptionsResult;
import com.microsoft.windowsazure.services.servicebus.models.ListTopicsOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListTopicsResult;
import com.microsoft.windowsazure.services.servicebus.models.QueueInfo;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveMessageOptions;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveQueueMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveSubscriptionMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.RuleInfo;
import com.microsoft.windowsazure.services.servicebus.models.SubscriptionInfo;
import com.microsoft.windowsazure.services.servicebus.models.TopicInfo;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;

public class ServiceBusRestProxy
implements ServiceBusContract {
    private Client channel;
    private final String uri;
    private final BrokerPropertiesMapper mapper;
    private final CustomPropertiesMapper customPropertiesMapper;
    private ClientFilter[] filters;

    @Inject
    public ServiceBusRestProxy(Client channel, WrapFilter authFilter, SasFilter sasAuthFilter, UserAgentFilter userAgentFilter, ServiceBusConnectionSettings connectionSettings, BrokerPropertiesMapper mapper) {
        this.channel = channel;
        this.filters = new ClientFilter[0];
        this.uri = connectionSettings.getUri();
        this.mapper = mapper;
        this.customPropertiesMapper = new CustomPropertiesMapper();
        if (connectionSettings.isSasAuthentication()) {
            channel.addFilter((ClientFilter)sasAuthFilter);
        } else {
            channel.addFilter((ClientFilter)authFilter);
        }
        channel.addFilter((ClientFilter)new ClientFilterRequestAdapter((ServiceRequestFilter)userAgentFilter));
    }

    public ServiceBusRestProxy(Client channel, ClientFilter[] filters, String uri, BrokerPropertiesMapper mapper) {
        this.channel = channel;
        this.filters = filters;
        this.uri = uri;
        this.mapper = mapper;
        this.customPropertiesMapper = new CustomPropertiesMapper();
    }

    public ServiceBusContract withFilter(ServiceFilter filter) {
        ClientFilter[] newFilters = Arrays.copyOf(this.filters, this.filters.length + 1);
        newFilters[this.filters.length] = new ClientFilterAdapter(filter);
        return new ServiceBusRestProxy(this.channel, newFilters, this.uri, this.mapper);
    }

    public ServiceBusContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.filters;
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new ServiceBusRestProxy(this.channel, newFilters, this.uri, this.mapper);
    }

    public ServiceBusContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.filters;
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new ServiceBusRestProxy(this.channel, newFilters, this.uri, this.mapper);
    }

    public ServiceBusContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.filters;
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new ServiceBusRestProxy(this.channel, newFilters, this.uri, this.mapper);
    }

    public ServiceBusContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.filters;
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new ServiceBusRestProxy(this.channel, newFilters, this.uri, this.mapper);
    }

    public Client getChannel() {
        return this.channel;
    }

    public void setChannel(Client channel) {
        this.channel = channel;
    }

    private WebResource getResource() {
        return this.getResourceWithApiVersion("2013-07");
    }

    private WebResource getResourceWithApiVersion(String version) {
        WebResource resource = this.getChannel().resource(this.uri).queryParam("api-version", version);
        for (ClientFilter filter : this.filters) {
            resource.addFilter(filter);
        }
        return resource;
    }

    @Override
    public void sendMessage(String path, BrokeredMessage message) {
        WebResource.Builder request = this.getResource().path(path).path("messages").getRequestBuilder();
        if (message.getContentType() != null) {
            request = (WebResource.Builder)request.type(message.getContentType());
        }
        if (message.getBrokerProperties() != null) {
            request = (WebResource.Builder)request.header("BrokerProperties", (Object)this.mapper.toString(message.getBrokerProperties()));
        }
        for (Map.Entry<String, Object> entry : message.getProperties().entrySet()) {
            request.header(entry.getKey(), (Object)this.customPropertiesMapper.toString(entry.getValue()));
        }
        request.post((Object)message.getBody());
    }

    @Override
    public void sendQueueMessage(String path, BrokeredMessage message) throws ServiceException {
        this.sendMessage(path, message);
    }

    @Override
    public ReceiveQueueMessageResult receiveQueueMessage(String queueName) throws ServiceException {
        return this.receiveQueueMessage(queueName, ReceiveMessageOptions.DEFAULT);
    }

    @Override
    public ReceiveQueueMessageResult receiveQueueMessage(String queuePath, ReceiveMessageOptions options) throws ServiceException {
        WebResource resource = this.getResource().path(queuePath).path("messages").path("head");
        BrokeredMessage message = this.receiveMessage(options, resource);
        return new ReceiveQueueMessageResult(message);
    }

    @Override
    public ReceiveMessageResult receiveMessage(String path) throws ServiceException {
        return this.receiveMessage(path, ReceiveMessageOptions.DEFAULT);
    }

    @Override
    public ReceiveMessageResult receiveMessage(String path, ReceiveMessageOptions options) throws ServiceException {
        WebResource resource = this.getResource().path(path).path("messages").path("head");
        BrokeredMessage message = this.receiveMessage(options, resource);
        return new ReceiveMessageResult(message);
    }

    private BrokeredMessage receiveMessage(ReceiveMessageOptions options, WebResource resource) {
        InputStream body;
        Date date;
        ClientResponse clientResult;
        if (options.getTimeout() != null) {
            resource = resource.queryParam("timeout", Integer.toString(options.getTimeout()));
        }
        if (options.isReceiveAndDelete()) {
            clientResult = (ClientResponse)resource.delete(ClientResponse.class);
        } else if (options.isPeekLock()) {
            clientResult = (ClientResponse)resource.post(ClientResponse.class, (Object)"0");
        } else {
            throw new RuntimeException("Unknown ReceiveMode");
        }
        if (clientResult.getStatus() == 204) {
            return null;
        }
        BrokerProperties brokerProperties = clientResult.getHeaders().containsKey((Object)"BrokerProperties") ? this.mapper.fromString((String)clientResult.getHeaders().getFirst((Object)"BrokerProperties")) : new BrokerProperties();
        String location = (String)clientResult.getHeaders().getFirst((Object)"Location");
        if (location != null) {
            brokerProperties.setLockLocation(location);
        }
        BrokeredMessage message = new BrokeredMessage(brokerProperties);
        MediaType contentType = clientResult.getType();
        if (contentType != null) {
            message.setContentType(contentType.toString());
        }
        if ((date = clientResult.getResponseDate()) != null) {
            message.setDate(date);
        }
        if ((body = clientResult.getEntityInputStream()) != null) {
            message.setBody(body);
        }
        for (String key : clientResult.getHeaders().keySet()) {
            Object value = clientResult.getHeaders().getFirst((Object)key);
            try {
                value = this.customPropertiesMapper.fromString(value.toString());
                message.setProperty(key, value);
            }
            catch (ParseException parseException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return message;
    }

    @Override
    public void sendTopicMessage(String topicName, BrokeredMessage message) throws ServiceException {
        this.sendMessage(topicName, message);
    }

    @Override
    public ReceiveSubscriptionMessageResult receiveSubscriptionMessage(String topicName, String subscriptionName) throws ServiceException {
        return this.receiveSubscriptionMessage(topicName, subscriptionName, ReceiveMessageOptions.DEFAULT);
    }

    @Override
    public ReceiveSubscriptionMessageResult receiveSubscriptionMessage(String topicName, String subscriptionName, ReceiveMessageOptions options) throws ServiceException {
        WebResource resource = this.getResource().path(topicName).path("subscriptions").path(subscriptionName).path("messages").path("head");
        BrokeredMessage message = this.receiveMessage(options, resource);
        return new ReceiveSubscriptionMessageResult(message);
    }

    @Override
    public void unlockMessage(BrokeredMessage message) throws ServiceException {
        this.getChannel().resource(message.getLockLocation()).put((Object)"0");
    }

    @Override
    public void deleteMessage(BrokeredMessage message) throws ServiceException {
        this.getChannel().resource(message.getLockLocation()).delete();
    }

    @Override
    public CreateQueueResult createQueue(QueueInfo queueInfo) throws ServiceException {
        WebResource.Builder webResourceBuilder = this.getResource().path(queueInfo.getPath()).type("application/atom+xml;type=entry;charset=utf-8");
        if (queueInfo.getForwardTo() != null && !queueInfo.getForwardTo().isEmpty()) {
            webResourceBuilder.header("ServiceBusSupplementaryAuthorization", (Object)queueInfo.getForwardTo());
        }
        return new CreateQueueResult((QueueInfo)webResourceBuilder.put(QueueInfo.class, (Object)queueInfo));
    }

    @Override
    public void deleteQueue(String queuePath) throws ServiceException {
        this.getResource().path(queuePath).delete();
    }

    @Override
    public GetQueueResult getQueue(String queuePath) throws ServiceException {
        return new GetQueueResult((QueueInfo)this.getResource().path(queuePath).get(QueueInfo.class));
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesOptions options) throws ServiceException {
        Feed feed = (Feed)this.listOptions(options, this.getResource().path("$Resources/Queues")).get(Feed.class);
        ArrayList<QueueInfo> queues = new ArrayList<QueueInfo>();
        for (Entry entry : feed.getEntries()) {
            queues.add(new QueueInfo(entry));
        }
        ListQueuesResult result = new ListQueuesResult();
        result.setItems(queues);
        return result;
    }

    @Override
    public QueueInfo updateQueue(QueueInfo queueInfo) throws ServiceException {
        WebResource.Builder webResourceBuilder = (WebResource.Builder)this.getResource().path(queueInfo.getPath()).type("application/atom+xml;type=entry;charset=utf-8").header("If-Match", (Object)"*");
        if (queueInfo.getForwardTo() != null && !queueInfo.getForwardTo().isEmpty()) {
            webResourceBuilder.header("ServiceBusSupplementaryAuthorization", (Object)queueInfo.getForwardTo());
        }
        return (QueueInfo)webResourceBuilder.put(QueueInfo.class, (Object)queueInfo);
    }

    private WebResource listOptions(AbstractListOptions<?> options, WebResource path) {
        if (options.getTop() != null) {
            path = path.queryParam("$top", options.getTop().toString());
        }
        if (options.getSkip() != null) {
            path = path.queryParam("$skip", options.getSkip().toString());
        }
        if (options.getFilter() != null) {
            path = path.queryParam("$filter", options.getFilter());
        }
        return path;
    }

    @Override
    public CreateEventHubResult createEventHub(EventHubInfo entry) throws ServiceException {
        return new CreateEventHubResult((EventHubInfo)this.getResourceWithApiVersion("2014-01").path(entry.getPath()).type("application/atom+xml;type=entry;charset=utf-8").put(EventHubInfo.class, (Object)entry));
    }

    @Override
    public void deleteEventHub(String eventHubPath) throws ServiceException {
        this.getResourceWithApiVersion("2014-01").path(eventHubPath).delete();
    }

    @Override
    public GetEventHubResult getEventHub(String eventHubPath) throws ServiceException {
        return new GetEventHubResult((EventHubInfo)this.getResourceWithApiVersion("2014-01").path(eventHubPath).get(EventHubInfo.class));
    }

    @Override
    public ListEventHubsResult listEventHubs(ListEventHubsOptions options) throws ServiceException {
        Feed feed = (Feed)this.listOptions(options, this.getResourceWithApiVersion("2014-01").path("$Resources/EventHubs")).get(Feed.class);
        ArrayList<EventHubInfo> eventHubs = new ArrayList<EventHubInfo>();
        for (Entry entry : feed.getEntries()) {
            eventHubs.add(new EventHubInfo(entry));
        }
        ListEventHubsResult result = new ListEventHubsResult();
        result.setItems(eventHubs);
        return result;
    }

    @Override
    public ListEventHubsResult listEventHubs() throws ServiceException {
        return this.listEventHubs(ListEventHubsOptions.DEFAULT);
    }

    @Override
    public CreateTopicResult createTopic(TopicInfo entry) throws ServiceException {
        return new CreateTopicResult((TopicInfo)this.getResource().path(entry.getPath()).type("application/atom+xml;type=entry;charset=utf-8").put(TopicInfo.class, (Object)entry));
    }

    @Override
    public void deleteTopic(String topicPath) throws ServiceException {
        this.getResource().path(topicPath).delete();
    }

    @Override
    public GetTopicResult getTopic(String topicPath) throws ServiceException {
        return new GetTopicResult((TopicInfo)this.getResource().path(topicPath).get(TopicInfo.class));
    }

    @Override
    public ListTopicsResult listTopics(ListTopicsOptions options) throws ServiceException {
        Feed feed = (Feed)this.listOptions(options, this.getResource().path("$Resources/Topics")).get(Feed.class);
        ArrayList<TopicInfo> topics = new ArrayList<TopicInfo>();
        for (Entry entry : feed.getEntries()) {
            topics.add(new TopicInfo(entry));
        }
        ListTopicsResult result = new ListTopicsResult();
        result.setItems(topics);
        return result;
    }

    @Override
    public TopicInfo updateTopic(TopicInfo topicInfo) throws ServiceException {
        return (TopicInfo)((WebResource.Builder)this.getResource().path(topicInfo.getPath()).type("application/atom+xml;type=entry;charset=utf-8").header("If-Match", (Object)"*")).put(TopicInfo.class, (Object)topicInfo);
    }

    @Override
    public CreateSubscriptionResult createSubscription(String topicPath, SubscriptionInfo subscriptionInfo) {
        WebResource.Builder webResourceBuilder = this.getResource().path(topicPath).path("subscriptions").path(subscriptionInfo.getName()).type("application/atom+xml;type=entry;charset=utf-8");
        if (subscriptionInfo.getForwardTo() != null && !subscriptionInfo.getForwardTo().isEmpty()) {
            webResourceBuilder.header("ServiceBusSupplementaryAuthorization", (Object)subscriptionInfo.getForwardTo());
        }
        return new CreateSubscriptionResult((SubscriptionInfo)webResourceBuilder.put(SubscriptionInfo.class, (Object)subscriptionInfo));
    }

    @Override
    public void deleteSubscription(String topicPath, String subscriptionName) {
        this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).delete();
    }

    @Override
    public GetSubscriptionResult getSubscription(String topicPath, String subscriptionName) {
        return new GetSubscriptionResult((SubscriptionInfo)this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).get(SubscriptionInfo.class));
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String topicPath, ListSubscriptionsOptions options) {
        Feed feed = (Feed)this.listOptions(options, this.getResource().path(topicPath).path("subscriptions")).get(Feed.class);
        ArrayList<SubscriptionInfo> list = new ArrayList<SubscriptionInfo>();
        for (Entry entry : feed.getEntries()) {
            list.add(new SubscriptionInfo(entry));
        }
        ListSubscriptionsResult result = new ListSubscriptionsResult();
        result.setItems(list);
        return result;
    }

    @Override
    public SubscriptionInfo updateSubscription(String topicName, SubscriptionInfo subscriptionInfo) throws ServiceException {
        WebResource.Builder webResourceBuilder = (WebResource.Builder)this.getResource().path(topicName).path("subscriptions").path(subscriptionInfo.getName()).type("application/atom+xml;type=entry;charset=utf-8").header("If-Match", (Object)"*");
        if (subscriptionInfo.getForwardTo() != null && !subscriptionInfo.getForwardTo().isEmpty()) {
            webResourceBuilder.header("ServiceBusSupplementaryAuthorization", (Object)subscriptionInfo.getForwardTo());
        }
        return (SubscriptionInfo)webResourceBuilder.put(SubscriptionInfo.class, (Object)subscriptionInfo);
    }

    @Override
    public CreateRuleResult createRule(String topicPath, String subscriptionName, RuleInfo rule) {
        return new CreateRuleResult((RuleInfo)this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).path("rules").path(rule.getName()).type("application/atom+xml;type=entry;charset=utf-8").put(RuleInfo.class, (Object)rule));
    }

    @Override
    public void deleteRule(String topicPath, String subscriptionName, String ruleName) {
        this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).path("rules").path(ruleName).delete();
    }

    @Override
    public GetRuleResult getRule(String topicPath, String subscriptionName, String ruleName) {
        return new GetRuleResult((RuleInfo)this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).path("rules").path(ruleName).get(RuleInfo.class));
    }

    @Override
    public ListRulesResult listRules(String topicPath, String subscriptionName, ListRulesOptions options) {
        Feed feed = (Feed)this.listOptions(options, this.getResource().path(topicPath).path("subscriptions").path(subscriptionName).path("rules")).get(Feed.class);
        ArrayList<RuleInfo> list = new ArrayList<RuleInfo>();
        for (Entry entry : feed.getEntries()) {
            list.add(new RuleInfo(entry));
        }
        ListRulesResult result = new ListRulesResult();
        result.setItems(list);
        return result;
    }

    @Override
    public ListQueuesResult listQueues() throws ServiceException {
        return this.listQueues(ListQueuesOptions.DEFAULT);
    }

    @Override
    public ListTopicsResult listTopics() throws ServiceException {
        return this.listTopics(ListTopicsOptions.DEFAULT);
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String topicName) throws ServiceException {
        return this.listSubscriptions(topicName, ListSubscriptionsOptions.DEFAULT);
    }

    @Override
    public ListRulesResult listRules(String topicName, String subscriptionName) throws ServiceException {
        return this.listRules(topicName, subscriptionName, ListRulesOptions.DEFAULT);
    }

    @Override
    public void renewQueueLock(String queueName, String messageId, String lockToken) throws ServiceException {
        ClientResponse clientResponse = (ClientResponse)this.getResource().path(queueName).path("messages").path(messageId).path(lockToken).post(ClientResponse.class, (Object)"0");
        PipelineHelpers.throwIfNotSuccess((ClientResponse)clientResponse);
    }

    @Override
    public void renewSubscriptionLock(String topicName, String subscriptionName, String messageId, String lockToken) throws ServiceException {
        ClientResponse clientResponse = (ClientResponse)this.getResource().path(topicName).path("Subscriptions").path(subscriptionName).path("messages").path(messageId).path(lockToken).post(ClientResponse.class, (Object)"0");
        PipelineHelpers.throwIfNotSuccess((ClientResponse)clientResponse);
    }
}

