/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.google.gson.Gson;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SecurityTokenType;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceIdentityTokenProvider
extends TokenProvider {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ManagedServiceIdentityTokenProvider.class);
    private static final String STATIC_LOCAL_REST_MSI_ENDPOINT_URL = "http://169.254.169.254/metadata/identity/oauth2/token";
    private static final String APIVERSION = "api-version=2018-02-01";
    private static final String MSI_ENDPOINT_ENV_VARIABLE = "MSI_ENDPOINT";
    private static final String MSI_SECRET_ENV_VARIABLE = "MSI_SECRET";
    private static final String MSI_URL_FORMAT = "%s?resource=%s&%s";
    private static final String METADATA_HEADER_NAME = "Metadata";
    private static final String SECRET_HEADER_NAME = "Secret";

    @Override
    public CompletableFuture<SecurityToken> getSecurityTokenAsync(String audience) {
        String addAudienceForSB = "https://servicebus.azure.net/";
        CompletableFuture<SecurityToken> tokenGeneratingFuture = new CompletableFuture<SecurityToken>();
        MessagingFactory.INTERNAL_THREAD_POOL.execute(() -> {
            try {
                MSIToken msiToken = ManagedServiceIdentityTokenProvider.getMSIToken(addAudienceForSB);
                SecurityToken generatedToken = new SecurityToken(SecurityTokenType.JWT, audience, msiToken.getAccessToken(), Instant.EPOCH.plus(Duration.ofSeconds(msiToken.getNotBefore())), Instant.now().plus(Duration.ofSeconds(msiToken.getExpiresIn())));
                tokenGeneratingFuture.complete(generatedToken);
            }
            catch (IOException ioe) {
                TRACE_LOGGER.error("ManagedServiceIdentity token generation failed.", (Throwable)ioe);
                tokenGeneratingFuture.completeExceptionally(ioe);
            }
        });
        return tokenGeneratingFuture;
    }

    private static MSIToken getMSIToken(String audience) throws IOException {
        HttpURLConnection httpConnection;
        URL msiURL;
        String localMSIURLForResouce;
        String localMsiEndPointURL = System.getenv(MSI_ENDPOINT_ENV_VARIABLE);
        String msiSecret = System.getenv(MSI_SECRET_ENV_VARIABLE);
        boolean useStaticHttpUrl = localMsiEndPointURL == null || localMsiEndPointURL.isEmpty() || msiSecret == null || msiSecret.isEmpty();
        if (useStaticHttpUrl) {
            localMSIURLForResouce = String.format(MSI_URL_FORMAT, STATIC_LOCAL_REST_MSI_ENDPOINT_URL, audience, APIVERSION);
            msiURL = new URL(localMSIURLForResouce);
            httpConnection = (HttpURLConnection)msiURL.openConnection();
            httpConnection.setRequestProperty(METADATA_HEADER_NAME, "true");
        } else {
            localMSIURLForResouce = String.format(MSI_URL_FORMAT, localMsiEndPointURL, audience, APIVERSION);
            msiURL = new URL(localMSIURLForResouce);
            httpConnection = (HttpURLConnection)msiURL.openConnection();
            httpConnection.setRequestProperty(SECRET_HEADER_NAME, msiSecret);
        }
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoInput(true);
        httpConnection.connect();
        StringBuilder responseBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(httpConnection.getInputStream(), StandardCharsets.UTF_8);){
            char[] buffer = new char[1024];
            int numBytesRead = -1;
            while ((numBytesRead = reader.read(buffer)) != -1) {
                responseBuilder.append(buffer, 0, numBytesRead);
            }
        }
        Gson gson = new Gson();
        MSIToken msiToken = (MSIToken)gson.fromJson(responseBuilder.toString(), MSIToken.class);
        return msiToken;
    }

    private static class MSIToken {
        private String access_token;
        private String refresh_token;
        private int expires_in;
        private long expires_on;
        private long not_before;
        private String resource;
        private String token_type;

        private MSIToken() {
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public int getExpiresIn() {
            return this.expires_in;
        }

        public long getExpiresOn() {
            return this.expires_on;
        }

        public long getNotBefore() {
            return this.not_before;
        }

        public String getResource() {
            return this.resource;
        }

        public String getTokenType() {
            return this.token_type;
        }
    }
}

