/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageBrowser;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.MessageConverter;
import com.microsoft.azure.servicebus.MessageReceiver;
import com.microsoft.azure.servicebus.MessageSender;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageBrowser
implements IMessageBrowser {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MessageBrowser.class);
    private long lastPeekedSequenceNumber = 0L;
    private boolean isReceiveSideBrowser = false;
    private MessageReceiver messageReceiver = null;
    private MessageSender messageSender = null;

    public MessageBrowser(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
        this.isReceiveSideBrowser = true;
    }

    public MessageBrowser(MessageSender messageSender) {
        this.messageSender = messageSender;
        this.isReceiveSideBrowser = false;
    }

    @Override
    public IMessage peek() throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.peekAsync());
    }

    @Override
    public IMessage peek(long fromSequenceNumber) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.peekAsync(fromSequenceNumber));
    }

    @Override
    public Collection<IMessage> peekBatch(int messageCount) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.peekBatchAsync(messageCount));
    }

    @Override
    public Collection<IMessage> peekBatch(long fromSequenceNumber, int messageCount) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.peekBatchAsync(fromSequenceNumber, messageCount));
    }

    @Override
    public CompletableFuture<IMessage> peekAsync() {
        return this.peekAsync(this.lastPeekedSequenceNumber + 1L);
    }

    @Override
    public CompletableFuture<IMessage> peekAsync(long fromSequenceNumber) {
        return this.peekBatchAsync(fromSequenceNumber, 1).thenApplyAsync(c -> {
            IMessage message = null;
            Iterator iterator = c.iterator();
            if (iterator.hasNext()) {
                message = (IMessage)iterator.next();
                iterator.remove();
            }
            return message;
        });
    }

    @Override
    public CompletableFuture<Collection<IMessage>> peekBatchAsync(int messageCount) {
        return this.peekBatchAsync(this.lastPeekedSequenceNumber + 1L, messageCount);
    }

    @Override
    public CompletableFuture<Collection<IMessage>> peekBatchAsync(long fromSequenceNumber, int messageCount) {
        CompletableFuture<Collection<org.apache.qpid.proton.message.Message>> peekFuture;
        if (this.isReceiveSideBrowser) {
            String sessionId = this.messageReceiver.isSessionReceiver() ? this.messageReceiver.getInternalReceiver().getSessionId() : null;
            TRACE_LOGGER.debug("Browsing '{}' messages from entity '{}' in sessionId '{}' from sequence number '{}'", new Object[]{messageCount, this.messageReceiver.getEntityPath(), sessionId, fromSequenceNumber});
            peekFuture = this.messageReceiver.getInternalReceiver().peekMessagesAsync(fromSequenceNumber, messageCount, sessionId);
        } else {
            TRACE_LOGGER.debug("Browsing '{}' messages from entity '{}' from sequence number '{}'", new Object[]{messageCount, this.messageSender.getEntityPath(), fromSequenceNumber});
            peekFuture = this.messageSender.getInternalSender().peekMessagesAsync(fromSequenceNumber, messageCount);
        }
        return peekFuture.thenApplyAsync(peekedMessages -> {
            ArrayList<Message> convertedMessages = new ArrayList<Message>();
            if (peekedMessages != null) {
                TRACE_LOGGER.debug("Browsing messages from sequence number '{}' returned '{}' messages", (Object)fromSequenceNumber, (Object)peekedMessages.size());
                long sequenceNumberOfLastMessage = 0L;
                for (org.apache.qpid.proton.message.Message message : peekedMessages) {
                    Message convertedMessage = MessageConverter.convertAmqpMessageToBrokeredMessage(message);
                    sequenceNumberOfLastMessage = convertedMessage.getSequenceNumber();
                    convertedMessages.add(convertedMessage);
                }
                if (sequenceNumberOfLastMessage > 0L) {
                    this.lastPeekedSequenceNumber = sequenceNumberOfLastMessage;
                }
            } else {
                TRACE_LOGGER.debug("Browsing messages from sequence number '{}' returned no messages", (Object)fromSequenceNumber);
            }
            return convertedMessages;
        });
    }
}

