/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.TimeoutTracker;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;

class WorkItem<T> {
    private final TimeoutTracker tracker;
    private final CompletableFuture<T> work;
    private ScheduledFuture<?> timeoutTask;
    private Exception lastKnownException;

    public WorkItem(CompletableFuture<T> completableFuture, Duration timeout) {
        this(completableFuture, TimeoutTracker.create(timeout));
    }

    public WorkItem(CompletableFuture<T> completableFuture, TimeoutTracker tracker) {
        this.work = completableFuture;
        this.tracker = tracker;
    }

    public TimeoutTracker getTimeoutTracker() {
        return this.tracker;
    }

    public CompletableFuture<T> getWork() {
        return this.work;
    }

    public ScheduledFuture<?> getTimeoutTask() {
        return this.timeoutTask;
    }

    public void setTimeoutTask(ScheduledFuture<?> timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public boolean cancelTimeoutTask(boolean mayInterruptIfRunning) {
        if (this.timeoutTask != null) {
            return this.timeoutTask.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    public Exception getLastKnownException() {
        return this.lastKnownException;
    }

    public void setLastKnownException(Exception exception) {
        this.lastKnownException = exception;
    }
}

