/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SecurityTokenType;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureActiveDirectoryTokenProvider
extends TokenProvider {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(AzureActiveDirectoryTokenProvider.class);
    private AuthenticationMode authenticationMode;
    private AuthenticationContext authenticationContext;
    private ClientCredential clientCredential;
    private AsymmetricKeyCredential asymmetricKeyCredential;
    private String clientId;
    private String userName;
    private String password;

    public AzureActiveDirectoryTokenProvider(AuthenticationContext authenticationContext, ClientCredential clientCredential) {
        this.authenticationMode = AuthenticationMode.CLIENT_CREDENTIAL;
        this.authenticationContext = authenticationContext;
        this.clientCredential = clientCredential;
    }

    public AzureActiveDirectoryTokenProvider(AuthenticationContext authenticationContext, AsymmetricKeyCredential asymmetricKeyCredential) {
        this.authenticationMode = AuthenticationMode.CERTIFICATE;
        this.authenticationContext = authenticationContext;
        this.asymmetricKeyCredential = asymmetricKeyCredential;
    }

    public AzureActiveDirectoryTokenProvider(AuthenticationContext authenticationContext, String clientId, String userName, String password) {
        this.authenticationMode = AuthenticationMode.USER_PASSWORD_CREDENTIAL;
        this.authenticationContext = authenticationContext;
        this.clientId = clientId;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public CompletableFuture<SecurityToken> getSecurityTokenAsync(String audience) {
        String addAudienceForSB = "https://servicebus.azure.net/";
        CompletableFuture<SecurityToken> tokenGeneratingFuture = new CompletableFuture<SecurityToken>();
        switch (this.authenticationMode) {
            case CLIENT_CREDENTIAL: {
                this.authenticationContext.acquireToken(addAudienceForSB, this.clientCredential, (AuthenticationCallback)new FutureCompletingAuthenticationCallback(tokenGeneratingFuture, audience));
                break;
            }
            case USER_PASSWORD_CREDENTIAL: {
                this.authenticationContext.acquireToken(addAudienceForSB, this.clientId, this.userName, this.password, (AuthenticationCallback)new FutureCompletingAuthenticationCallback(tokenGeneratingFuture, audience));
                break;
            }
            case CERTIFICATE: {
                this.authenticationContext.acquireToken(addAudienceForSB, this.asymmetricKeyCredential, (AuthenticationCallback)new FutureCompletingAuthenticationCallback(tokenGeneratingFuture, audience));
            }
        }
        return tokenGeneratingFuture;
    }

    private static class FutureCompletingAuthenticationCallback
    implements AuthenticationCallback {
        private CompletableFuture<SecurityToken> tokenGeneratingFutue;
        private String audience;

        public FutureCompletingAuthenticationCallback(CompletableFuture<SecurityToken> tokenGeneratingFutue, String audience) {
            this.tokenGeneratingFutue = tokenGeneratingFutue;
            this.audience = audience;
        }

        public void onFailure(Throwable authException) {
            TRACE_LOGGER.error("Getting token from Azure Active Directory failed", authException);
            this.tokenGeneratingFutue.completeExceptionally(authException);
        }

        public void onSuccess(AuthenticationResult authResult) {
            SecurityToken generatedToken = new SecurityToken(SecurityTokenType.JWT, this.audience, authResult.getAccessToken(), Instant.now(), Instant.now().plus(Duration.ofSeconds(authResult.getExpiresAfter())));
            this.tokenGeneratingFutue.complete(generatedToken);
        }
    }

    static enum AuthenticationMode {
        CLIENT_CREDENTIAL,
        USER_PASSWORD_CREDENTIAL,
        CERTIFICATE;

    }
}

