/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.BrowsableMessageSession;
import com.microsoft.azure.servicebus.IMessageSession;
import com.microsoft.azure.servicebus.primitives.MessagingEntityType;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.MiscRequestResponseOperationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionBrowser {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SessionBrowser.class);
    private static final int PAGESIZE = 100;
    private static final Date MAXDATE = new Date(253402300800000L);
    private final MessagingFactory messagingFactory;
    private final String entityPath;
    private final MessagingEntityType entityType;
    private MiscRequestResponseOperationHandler miscRequestResponseHandler;

    SessionBrowser(MessagingFactory messagingFactory, String entityPath, MessagingEntityType entityType, MiscRequestResponseOperationHandler miscRequestResponseHandler) {
        this.messagingFactory = messagingFactory;
        this.entityPath = entityPath;
        this.entityType = entityType;
        this.miscRequestResponseHandler = miscRequestResponseHandler;
    }

    public CompletableFuture<Collection<IMessageSession>> getMessageSessionsAsync() {
        return this.getMessageSessionsAsync(MAXDATE);
    }

    public CompletableFuture<Collection<IMessageSession>> getMessageSessionsAsync(Date lastUpdatedTime) {
        return this.getMessageSessionsAsync(lastUpdatedTime, 0, null);
    }

    private CompletableFuture<Collection<IMessageSession>> getMessageSessionsAsync(Date lastUpdatedTime, int lastReceivedSkip, String lastSessionId) {
        TRACE_LOGGER.debug("Getting '{}' browsable sessions from entity '{}', lastUpdatedTime '{}', lastReceivedSkip '{}', lastSessionId '{}'", new Object[]{100, this.entityPath, lastUpdatedTime, lastReceivedSkip, lastSessionId});
        return this.miscRequestResponseHandler.getMessageSessionsAsync(lastUpdatedTime, lastReceivedSkip, 100, lastSessionId).thenComposeAsync(p -> {
            int newLastReceivedSkip = (Integer)p.getSecondItem();
            String[] sessionIds = (String[])p.getFirstItem();
            ArrayList<BrowsableMessageSession> sessionsList = new ArrayList<BrowsableMessageSession>();
            if (sessionIds != null && sessionIds.length > 0) {
                TRACE_LOGGER.debug("Got '{}' browsable sessions from entity '{}', receivedSkip '{}'", new Object[]{sessionIds.length, this.entityPath, newLastReceivedSkip});
                CompletableFuture[] initFutures = new CompletableFuture[sessionIds.length];
                int initFutureIndex = 0;
                String newLastSessionId = sessionIds[sessionIds.length - 1];
                for (String sessionId : sessionIds) {
                    BrowsableMessageSession browsableSession = new BrowsableMessageSession(sessionId, this.messagingFactory, this.entityPath, this.entityType);
                    sessionsList.add(browsableSession);
                    initFutures[initFutureIndex++] = browsableSession.initializeAsync();
                }
                CompletableFuture<Void> allInitFuture = CompletableFuture.allOf(initFutures);
                return ((CompletableFuture)allInitFuture.thenComposeAsync(v -> this.getMessageSessionsAsync(lastUpdatedTime, newLastReceivedSkip, newLastSessionId))).thenApply(c -> {
                    sessionsList.addAll((Collection<BrowsableMessageSession>)c);
                    return sessionsList;
                });
            }
            TRACE_LOGGER.debug("Got no browsable sessions from entity '{}'", (Object)this.entityPath);
            return CompletableFuture.completedFuture(sessionsList);
        });
    }
}

