/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class Utils {
    public static <T> T completeFuture(CompletableFuture<T> future) throws InterruptedException, ServiceBusException {
        try {
            return future.get();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof ServiceBusException) {
                throw (ServiceBusException)cause;
            }
            throw new ServiceBusException(true, cause);
        }
    }

    static void assertNonNull(String argumentName, Object argument) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + argumentName + "' is null.");
        }
    }
}

