/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.ManagementClientConstants;

public class EntityNameHelper {
    private static final String pathDelimiter = "/";
    private static final String subscriptionsSubPath = "Subscriptions";
    private static final String rulesSubPath = "Rules";
    private static final String subQueuePrefix = "$";
    private static final String deadLetterQueueSuffix = "DeadLetterQueue";
    private static final String deadLetterQueueName = "$DeadLetterQueue";
    private static final String transfer = "Transfer";
    private static final String transferDeadLetterQueueName = "$Transfer/$DeadLetterQueue";

    public static String formatDeadLetterPath(String entityPath) {
        return EntityNameHelper.formatSubQueuePath(entityPath, deadLetterQueueName);
    }

    public static String formatSubscriptionPath(String topicPath, String subscriptionName) {
        return String.join((CharSequence)pathDelimiter, topicPath, subscriptionsSubPath, subscriptionName);
    }

    public static String formatRulePath(String topicPath, String subscriptionName, String ruleName) {
        return String.join((CharSequence)pathDelimiter, topicPath, subscriptionsSubPath, subscriptionName, rulesSubPath, ruleName);
    }

    public static String formatTransferDeadLetterPath(String entityPath) {
        return String.join((CharSequence)pathDelimiter, entityPath, transferDeadLetterQueueName);
    }

    static String formatSubQueuePath(String entityPath, String subQueueName) {
        return entityPath + pathDelimiter + subQueueName;
    }

    static void checkValidQueueName(String queueName) {
        EntityNameHelper.checkValidEntityName(queueName, ManagementClientConstants.QUEUE_NAME_MAX_LENGTH, true);
    }

    static void checkValidTopicName(String topicName) {
        EntityNameHelper.checkValidEntityName(topicName, ManagementClientConstants.TOPIC_NAME_MAX_LENGTH, true);
    }

    static void checkValidSubscriptionName(String subscriptionName) {
        EntityNameHelper.checkValidEntityName(subscriptionName, ManagementClientConstants.SUBSCRIPTION_NAME_MAX_LENGTH, false);
    }

    static void checkValidRuleName(String ruleName) {
        EntityNameHelper.checkValidEntityName(ruleName, ManagementClientConstants.RULE_NAME_MAX_LENGTH, false);
    }

    private static void checkValidEntityName(String entityName, int maxEntityNameLength, boolean allowSeparator) {
        if (entityName == null || entityName.isEmpty()) {
            throw new IllegalArgumentException("Entity name cannot be null");
        }
        String tempName = entityName.replace('\\', '/');
        if (tempName.length() > maxEntityNameLength) {
            throw new IllegalArgumentException("Entity path " + entityName + " exceeds the " + maxEntityNameLength + " character limit");
        }
        if (tempName.startsWith(pathDelimiter) || tempName.endsWith(pathDelimiter)) {
            throw new IllegalArgumentException("The entity name cannot contain '/' as prefix or suffix.");
        }
        if (!allowSeparator && tempName.contains(pathDelimiter)) {
            throw new IllegalArgumentException("The entity name contains an invalid character '/'");
        }
        for (char key : ManagementClientConstants.InvalidEntityPathCharacters) {
            if (entityName.indexOf(key) < 0) continue;
            throw new IllegalArgumentException(entityName + " contains character '" + key + "' which is not allowedbecause it is reserved in the Uri scheme.");
        }
    }
}

