/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.AuthorizationRuleSerializer;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.TopicDescription;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class TopicDescriptionSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(TopicDescriptionSerializer.class);

    TopicDescriptionSerializer() {
    }

    static String serialize(TopicDescription topicDescription) throws ServiceBusException {
        DocumentBuilder dBuilder;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElementNS(ManagementClientConstants.ATOM_NS, "entry");
        doc.appendChild(rootElement);
        Element contentElement = doc.createElementNS(ManagementClientConstants.ATOM_NS, "content");
        rootElement.appendChild(contentElement);
        contentElement.setAttribute("type", "application/xml");
        Element tdElement = doc.createElementNS(ManagementClientConstants.SB_NS, "TopicDescription");
        contentElement.appendChild(tdElement);
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "MaxSizeInMegabytes").appendChild(doc.createTextNode(Long.toString(topicDescription.maxSizeInMB))).getParentNode());
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "RequiresDuplicateDetection").appendChild(doc.createTextNode(Boolean.toString(topicDescription.requiresDuplicateDetection))).getParentNode());
        if (topicDescription.defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "DefaultMessageTimeToLive").appendChild(doc.createTextNode(topicDescription.defaultMessageTimeToLive.toString())).getParentNode());
        }
        if (topicDescription.requiresDuplicateDetection && topicDescription.duplicationDetectionHistoryTimeWindow.compareTo(Duration.ZERO) > 0) {
            tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "DuplicateDetectionHistoryTimeWindow").appendChild(doc.createTextNode(topicDescription.duplicationDetectionHistoryTimeWindow.toString())).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "EnableBatchedOperations").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enableBatchedOperations))).getParentNode());
        if (topicDescription.authorizationRules != null) {
            tdElement.appendChild(AuthorizationRuleSerializer.serializeRules(topicDescription.authorizationRules, doc));
        }
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "Status").appendChild(doc.createTextNode(topicDescription.status.name())).getParentNode());
        if (topicDescription.userMetadata != null) {
            tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "UserMetadata").appendChild(doc.createTextNode(topicDescription.userMetadata)).getParentNode());
        }
        if (topicDescription.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "AutoDeleteOnIdle").appendChild(doc.createTextNode(topicDescription.autoDeleteOnIdle.toString())).getParentNode());
        }
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "SupportOrdering").appendChild(doc.createTextNode(Boolean.toString(topicDescription.supportOrdering))).getParentNode());
        tdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "EnablePartitioning").appendChild(doc.createTextNode(Boolean.toString(topicDescription.enablePartitioning))).getParentNode());
        StringWriter output = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        return output.toString();
    }

    static List<TopicDescription> parseCollectionFromContent(String xml) {
        ArrayList<TopicDescription> topicList;
        block4: {
            topicList = new ArrayList<TopicDescription>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("entry")) continue;
                    topicList.add(TopicDescriptionSerializer.parseFromEntry(node));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        return topicList;
    }

    static TopicDescription parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if (doc.getTagName() == "entry") {
                    return TopicDescriptionSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Topic was not found");
    }

    private static TopicDescription parseFromEntry(Node xEntry) {
        TopicDescription td = null;
        NodeList nList = xEntry.getChildNodes();
        block34: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    td = new TopicDescription(element.getFirstChild().getNodeValue());
                    continue block34;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block35: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "MaxSizeInMegabytes": {
                                td.maxSizeInMB = Long.parseLong(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "RequiresDuplicateDetection": {
                                td.requiresDuplicateDetection = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "DuplicateDetectionHistoryTimeWindow": {
                                td.duplicationDetectionHistoryTimeWindow = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "DefaultMessageTimeToLive": {
                                td.defaultMessageTimeToLive = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "EnableBatchedOperations": {
                                td.enableBatchedOperations = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "Status": {
                                td.status = EntityStatus.valueOf(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "AutoDeleteOnIdle": {
                                td.autoDeleteOnIdle = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "EnablePartitioning": {
                                td.enablePartitioning = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block35;
                            }
                            case "UserMetadata": {
                                td.userMetadata = element.getFirstChild().getNodeValue();
                                continue block35;
                            }
                            case "AuthorizationRules": {
                                td.authorizationRules = AuthorizationRuleSerializer.parseAuthRules(element);
                                continue block35;
                            }
                            case "SupportOrdering": {
                                td.supportOrdering = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                            }
                        }
                    }
                    continue block34;
                }
            }
        }
        return td;
    }
}

