/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.IllegalConnectionStringFormatException;
import com.microsoft.azure.servicebus.primitives.Pair;
import com.microsoft.azure.servicebus.primitives.PayloadSizeExceededException;
import com.microsoft.azure.servicebus.security.SharedAccessSignatureTokenProvider;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.Message;

public class Util {
    private static final long EPOCHINDOTNETTICKS = 621355968000000000L;
    private static final int GUIDSIZE = 16;

    private Util() {
    }

    static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return obj.toString().length() << 1;
        }
        if (obj instanceof Symbol) {
            return ((Symbol)obj).length() << 1;
        }
        if (obj instanceof Byte || obj instanceof UnsignedByte) {
            return 1;
        }
        if (obj instanceof Integer || obj instanceof UnsignedInteger) {
            return 4;
        }
        if (obj instanceof Long || obj instanceof UnsignedLong || obj instanceof Date) {
            return 8;
        }
        if (obj instanceof Short || obj instanceof UnsignedShort) {
            return 2;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Character) {
            return 4;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof UUID) {
            return 16;
        }
        if (obj instanceof Decimal32) {
            return 4;
        }
        if (obj instanceof Decimal64) {
            return 8;
        }
        if (obj instanceof Decimal128) {
            return 16;
        }
        if (obj instanceof Binary) {
            return ((Binary)obj).getLength();
        }
        if (obj instanceof Declare) {
            return 7;
        }
        if (obj instanceof Discharge) {
            Discharge discharge = (Discharge)obj;
            return 12 + discharge.getTxnId().getLength();
        }
        if (obj instanceof Map) {
            int size = 8;
            Map map = (Map)obj;
            for (Object value : map.keySet()) {
                size += Util.sizeof(value);
            }
            for (Object value : map.values()) {
                size += Util.sizeof(value);
            }
            return size;
        }
        if (obj instanceof Iterable) {
            int size = 8;
            for (Object innerObject : (Iterable)obj) {
                size += Util.sizeof(innerObject);
            }
            return size;
        }
        if (obj.getClass().isArray()) {
            int size = 8;
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                size += Util.sizeof(Array.get(obj, i));
            }
            return size;
        }
        throw new IllegalArgumentException(String.format(Locale.US, "Encoding Type: %s is not supported", obj.getClass()));
    }

    public static Instant convertDotNetTicksToInstant(long dotNetTicks) {
        long ticksFromEpoch = dotNetTicks - 621355968000000000L;
        long millisecondsFromEpoch = ticksFromEpoch / 10000L;
        long fractionTicks = ticksFromEpoch % 10000L;
        return Instant.ofEpochMilli(millisecondsFromEpoch).plusNanos(fractionTicks * 100L);
    }

    public static long convertInstantToDotNetTicks(Instant instant) {
        return instant.getEpochSecond() * 10000000L + (long)(instant.getNano() / 100) + 621355968000000000L;
    }

    public static UUID convertDotNetBytesToUUID(byte[] dotNetBytes) {
        if (dotNetBytes == null || dotNetBytes.length != 16) {
            return new UUID(0L, 0L);
        }
        byte[] reOrderedBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    int indexInReorderedBytes = 3;
                    break;
                }
                case 1: {
                    int indexInReorderedBytes = 2;
                    break;
                }
                case 2: {
                    int indexInReorderedBytes = 1;
                    break;
                }
                case 3: {
                    int indexInReorderedBytes = 0;
                    break;
                }
                case 4: {
                    int indexInReorderedBytes = 5;
                    break;
                }
                case 5: {
                    int indexInReorderedBytes = 4;
                    break;
                }
                case 6: {
                    int indexInReorderedBytes = 7;
                    break;
                }
                case 7: {
                    int indexInReorderedBytes = 6;
                    break;
                }
                default: {
                    int indexInReorderedBytes = i;
                }
            }
            reOrderedBytes[indexInReorderedBytes] = dotNetBytes[i];
        }
        ByteBuffer buffer = ByteBuffer.wrap(reOrderedBytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static byte[] convertUUIDToDotNetBytes(UUID uniqueId) {
        if (uniqueId == null || uniqueId.equals(ClientConstants.ZEROLOCKTOKEN)) {
            return new byte[16];
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uniqueId.getMostSignificantBits());
        buffer.putLong(uniqueId.getLeastSignificantBits());
        byte[] javaBytes = buffer.array();
        byte[] dotNetBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    int indexInReorderedBytes = 3;
                    break;
                }
                case 1: {
                    int indexInReorderedBytes = 2;
                    break;
                }
                case 2: {
                    int indexInReorderedBytes = 1;
                    break;
                }
                case 3: {
                    int indexInReorderedBytes = 0;
                    break;
                }
                case 4: {
                    int indexInReorderedBytes = 5;
                    break;
                }
                case 5: {
                    int indexInReorderedBytes = 4;
                    break;
                }
                case 6: {
                    int indexInReorderedBytes = 7;
                    break;
                }
                case 7: {
                    int indexInReorderedBytes = 6;
                    break;
                }
                default: {
                    int indexInReorderedBytes = i;
                }
            }
            dotNetBytes[indexInReorderedBytes] = javaBytes[i];
        }
        return dotNetBytes;
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        Section bodySection = msg.getBody();
        if (bodySection instanceof AmqpValue) {
            return Util.sizeof(((AmqpValue)bodySection).getValue());
        }
        if (bodySection instanceof AmqpSequence) {
            return Util.sizeof(((AmqpSequence)bodySection).getValue());
        }
        if (bodySection instanceof Data) {
            Data payloadSection = (Data)bodySection;
            Binary payloadBytes = payloadSection.getValue();
            return Util.sizeof(payloadBytes);
        }
        return 0;
    }

    public static int getDataSerializedSize(Message amqpMessage) {
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = Util.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            annotationsSize += Util.sizeof(messageAnnotations.getValue());
        }
        if (applicationProperties != null) {
            applicationPropertiesSize += Util.sizeof(applicationProperties.getValue());
        }
        return annotationsSize + applicationPropertiesSize + payloadSize;
    }

    static Pair<byte[], Integer> encodeMessageToOptimalSizeArray(Message message, int maxMessageSize) throws PayloadSizeExceededException {
        int payloadSize = Util.getDataSerializedSize(message);
        int allocationSize = Math.min(payloadSize + 512, maxMessageSize);
        byte[] encodedBytes = new byte[allocationSize];
        int encodedSize = Util.encodeMessageToCustomArray(message, encodedBytes, 0, allocationSize);
        return new Pair<byte[], Integer>(encodedBytes, encodedSize);
    }

    static Pair<byte[], Integer> encodeMessageToMaxSizeArray(Message message, int maxMessageSize) throws PayloadSizeExceededException {
        byte[] encodedBytes = new byte[maxMessageSize];
        int encodedSize = Util.encodeMessageToCustomArray(message, encodedBytes, 0, maxMessageSize);
        return new Pair<byte[], Integer>(encodedBytes, encodedSize);
    }

    static int encodeMessageToCustomArray(Message message, byte[] encodedBytes, int offset, int length) throws PayloadSizeExceededException {
        try {
            return message.encode(encodedBytes, offset, length);
        }
        catch (BufferOverflowException exception) {
            throw new PayloadSizeExceededException(String.format("Size of the payload exceeded Maximum message size: %s kb", length / 1024), (Throwable)exception);
        }
    }

    public static Duration adjustServerTimeout(Duration clientTimeout) {
        return clientTimeout.minusMillis(100L);
    }

    static Message readMessageFromDelivery(Receiver receiveLink, Delivery delivery) {
        int msgSize = delivery.pending();
        byte[] buffer = new byte[msgSize];
        int read = receiveLink.recv(buffer, 0, msgSize);
        Message message = Proton.message();
        message.decode(buffer, 0, read);
        return message;
    }

    public static URI convertNamespaceToEndPointURI(String namespaceName) {
        try {
            return new URI(String.format(Locale.US, "amqps://%s.servicebus.windows.net", namespaceName));
        }
        catch (URISyntaxException exception) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid namespace name: %s", namespaceName), exception);
        }
    }

    public static ClientSettings getClientSettingsFromConnectionStringBuilder(ConnectionStringBuilder builder) {
        SharedAccessSignatureTokenProvider tokenProvider = builder.getSharedAccessSignatureToken() == null ? new SharedAccessSignatureTokenProvider(builder.getSasKeyName(), builder.getSasKey(), 1200) : new SharedAccessSignatureTokenProvider(builder.getSharedAccessSignatureToken(), Instant.now().plus(Duration.ofSeconds(1200L)));
        return new ClientSettings(tokenProvider, builder.getRetryPolicy(), builder.getOperationTimeout());
    }

    static int getTokenRenewIntervalInSeconds(int tokenValidityInSeconds) {
        if (tokenValidityInSeconds >= 300) {
            return tokenValidityInSeconds - 30;
        }
        if (tokenValidityInSeconds >= 60) {
            return tokenValidityInSeconds - 10;
        }
        return tokenValidityInSeconds - 1 > 0 ? tokenValidityInSeconds - 1 : 0;
    }

    static int getMaxMessageSizeFromLink(Link link) {
        int maxMessageSizeAsInt;
        UnsignedLong maxMessageSize = link.getRemoteMaxMessageSize();
        if (maxMessageSize != null && (maxMessageSizeAsInt = maxMessageSize.intValue()) > 0) {
            return maxMessageSizeAsInt;
        }
        return 0x100000;
    }
}

