/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import com.microsoft.azure.servicebus.amqp.AmqpErrorCode;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.WebSocketConnectionHandler;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConnectionHandler
extends WebSocketConnectionHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ProxyConnectionHandler.class);
    private final String proxySelectorModifiedError = "Proxy Selector has been modified.";

    public static boolean shouldUseProxy(String hostName) {
        URI uri = ProxyConnectionHandler.createURIFromHostNamePort(hostName, 443);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return false;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return ProxyConnectionHandler.isProxyAddressLegal(proxies);
    }

    public ProxyConnectionHandler(IAmqpConnection messagingFactory) {
        super(messagingFactory);
    }

    @Override
    public void addTransportLayers(Event event, TransportInternal transport) {
        super.addTransportLayers(event, transport);
        ProxyImpl proxy = new ProxyImpl();
        String hostName = event.getConnection().getHostname();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        Map<String, String> proxyHeader = this.getAuthorizationHeader();
        proxy.configure(hostName, proxyHeader, (ProxyHandler)proxyHandler, (Transport)transport);
        transport.addTransportLayer((TransportLayer)proxy);
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("addProxyHandshake: hostname[" + hostName + "]");
        }
    }

    @Override
    protected void notifyTransportErrors(Event event) {
        int port;
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (connection == null || transport == null) {
            return;
        }
        ErrorCondition errorCondition = transport.getCondition();
        String hostName = event.getReactor().getConnectionAddress(connection);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (errorCondition == null || !errorCondition.getCondition().equals(ConnectionError.FRAMING_ERROR) && !errorCondition.getCondition().equals(AmqpErrorCode.ProtonIOError) || proxySelector == null || StringUtil.isNullOrEmpty(hostName)) {
            return;
        }
        String[] hostNameParts = hostName.split(":");
        if (hostNameParts.length != 2) {
            return;
        }
        try {
            port = Integer.parseInt(hostNameParts[1]);
        }
        catch (NumberFormatException ignore) {
            return;
        }
        IOException ioException = ProxyConnectionHandler.reconstructIOException(errorCondition);
        proxySelector.connectFailed(ProxyConnectionHandler.createURIFromHostNamePort(this.getMessagingFactory().getHostName(), this.getProtocolPort()), new InetSocketAddress(hostNameParts[0], port), ioException);
    }

    private Map<String, String> getAuthorizationHeader() {
        String proxyPassword;
        PasswordAuthentication authentication = Authenticator.requestPasswordAuthentication(this.getOutboundSocketHostName(), null, this.getOutboundSocketPort(), null, null, "http", null, Authenticator.RequestorType.PROXY);
        if (authentication == null) {
            return null;
        }
        String proxyUserName = authentication.getUserName();
        String string = proxyPassword = authentication.getPassword() != null ? new String(authentication.getPassword()) : null;
        if (StringUtil.isNullOrEmpty(proxyUserName) || StringUtil.isNullOrEmpty(proxyPassword)) {
            return null;
        }
        HashMap<String, String> proxyAuthorizationHeader = new HashMap<String, String>();
        String usernamePasswordPair = proxyUserName + ":" + proxyPassword;
        proxyAuthorizationHeader.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString(usernamePasswordPair.getBytes()));
        return proxyAuthorizationHeader;
    }

    @Override
    public String getOutboundSocketHostName() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getHostString();
    }

    @Override
    public int getOutboundSocketPort() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getPort();
    }

    private InetSocketAddress getProxyAddress() {
        URI serviceUri = ProxyConnectionHandler.createURIFromHostNamePort(this.getMessagingFactory().getHostName(), this.getProtocolPort());
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            throw new IllegalStateException("Proxy Selector has been modified.");
        }
        List<Proxy> proxies = proxySelector.select(serviceUri);
        if (!ProxyConnectionHandler.isProxyAddressLegal(proxies)) {
            throw new IllegalStateException("Proxy Selector has been modified.");
        }
        Proxy proxy = proxies.get(0);
        return (InetSocketAddress)proxy.address();
    }

    private static URI createURIFromHostNamePort(String hostName, int port) {
        return URI.create(String.format("https://%s:%s", hostName, port));
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).type() == Proxy.Type.HTTP && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }

    private static IOException reconstructIOException(ErrorCondition errorCondition) {
        return new IOException(errorCondition.getDescription());
    }
}

