/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.NamespaceInfo;
import com.microsoft.azure.servicebus.management.NamespaceSku;
import com.microsoft.azure.servicebus.management.NamespaceType;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class NamespaceInfoSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(NamespaceInfoSerializer.class);

    NamespaceInfoSerializer() {
    }

    static NamespaceInfo parseFromContent(String xml) throws ServiceBusException {
        block4: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if (doc.getTagName().equals("entry")) {
                    return NamespaceInfoSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new ServiceBusException(false, "Unable to deserialize the content.");
    }

    private static NamespaceInfo parseFromEntry(Node xEntry) {
        NamespaceInfo namespaceInfo = new NamespaceInfo();
        NodeList nList = xEntry.getChildNodes();
        block32: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "content": {
                    NodeList nsInfoNodes = element.getFirstChild().getChildNodes();
                    block33: for (int j = 0; j < nsInfoNodes.getLength(); ++j) {
                        node = nsInfoNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "CreatedTime": {
                                namespaceInfo.setCreatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block33;
                            }
                            case "ModifiedTime": {
                                namespaceInfo.setModifiedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block33;
                            }
                            case "Name": {
                                namespaceInfo.setName(element.getFirstChild().getNodeValue());
                                continue block33;
                            }
                            case "Alias": {
                                namespaceInfo.setAlias(element.getFirstChild().getNodeValue());
                                continue block33;
                            }
                            case "NamespaceType": {
                                String namespaceType;
                                switch (namespaceType = element.getFirstChild().getNodeValue()) {
                                    case "Mixed": {
                                        namespaceInfo.setNamespaceType(NamespaceType.Mixed);
                                        continue block33;
                                    }
                                    case "Messaging": {
                                        namespaceInfo.setNamespaceType(NamespaceType.ServiceBus);
                                        continue block33;
                                    }
                                }
                                namespaceInfo.setNamespaceType(NamespaceType.Unknown);
                                continue block33;
                            }
                            case "MessagingSKU": {
                                try {
                                    namespaceInfo.setNamespaceSku(NamespaceSku.valueOf(element.getFirstChild().getNodeValue()));
                                    continue block33;
                                }
                                catch (IllegalArgumentException ignored) {
                                    namespaceInfo.setNamespaceSku(NamespaceSku.Unknown);
                                }
                            }
                        }
                    }
                    continue block32;
                }
            }
        }
        return namespaceInfo;
    }
}

