/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.AuthorizationRuleSerializer;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class QueueDescriptionSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(QueueDescriptionSerializer.class);

    QueueDescriptionSerializer() {
    }

    static String serialize(QueueDescription queueDescription) throws ServiceBusException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElementNS(ManagementClientConstants.ATOM_NS, "entry");
        doc.appendChild(rootElement);
        Element contentElement = doc.createElementNS(ManagementClientConstants.ATOM_NS, "content");
        rootElement.appendChild(contentElement);
        contentElement.setAttribute("type", "application/xml");
        Element qdElement = doc.createElementNS(ManagementClientConstants.SB_NS, "QueueDescription");
        contentElement.appendChild(qdElement);
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "LockDuration").appendChild(doc.createTextNode(queueDescription.lockDuration.toString())).getParentNode());
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "MaxSizeInMegabytes").appendChild(doc.createTextNode(Long.toString(queueDescription.maxSizeInMB))).getParentNode());
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "RequiresDuplicateDetection").appendChild(doc.createTextNode(Boolean.toString(queueDescription.requiresDuplicateDetection))).getParentNode());
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "RequiresSession").appendChild(doc.createTextNode(Boolean.toString(queueDescription.requiresSession))).getParentNode());
        if (queueDescription.defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "DefaultMessageTimeToLive").appendChild(doc.createTextNode(queueDescription.defaultMessageTimeToLive.toString())).getParentNode());
        }
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "DeadLetteringOnMessageExpiration").appendChild(doc.createTextNode(Boolean.toString(queueDescription.enableDeadLetteringOnMessageExpiration))).getParentNode());
        if (queueDescription.requiresDuplicateDetection && queueDescription.duplicationDetectionHistoryTimeWindow.compareTo(Duration.ZERO) > 0) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "DuplicateDetectionHistoryTimeWindow").appendChild(doc.createTextNode(queueDescription.duplicationDetectionHistoryTimeWindow.toString())).getParentNode());
        }
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "MaxDeliveryCount").appendChild(doc.createTextNode(Integer.toString(queueDescription.maxDeliveryCount))).getParentNode());
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "EnableBatchedOperations").appendChild(doc.createTextNode(Boolean.toString(queueDescription.enableBatchedOperations))).getParentNode());
        if (queueDescription.authorizationRules != null) {
            qdElement.appendChild(AuthorizationRuleSerializer.serializeRules(queueDescription.authorizationRules, doc));
        }
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "Status").appendChild(doc.createTextNode(queueDescription.status.name())).getParentNode());
        if (queueDescription.forwardTo != null) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "ForwardTo").appendChild(doc.createTextNode(queueDescription.forwardTo)).getParentNode());
        }
        if (queueDescription.userMetadata != null) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "UserMetadata").appendChild(doc.createTextNode(queueDescription.userMetadata)).getParentNode());
        }
        if (queueDescription.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) < 0) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "AutoDeleteOnIdle").appendChild(doc.createTextNode(queueDescription.autoDeleteOnIdle.toString())).getParentNode());
        }
        qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "EnablePartitioning").appendChild(doc.createTextNode(Boolean.toString(queueDescription.enablePartitioning))).getParentNode());
        if (queueDescription.forwardDeadLetteredMessagesTo != null) {
            qdElement.appendChild(doc.createElementNS(ManagementClientConstants.SB_NS, "ForwardDeadLetteredMessagesTo").appendChild(doc.createTextNode(queueDescription.forwardDeadLetteredMessagesTo)).getParentNode());
        }
        StringWriter output = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        return output.toString();
    }

    static List<QueueDescription> parseCollectionFromContent(String xml) {
        ArrayList<QueueDescription> queueList;
        block4: {
            queueList = new ArrayList<QueueDescription>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("entry")) continue;
                    queueList.add(QueueDescriptionSerializer.parseFromEntry(node));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        return queueList;
    }

    static QueueDescription parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if (doc.getTagName() == "entry") {
                    return QueueDescriptionSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Queue was not found");
    }

    private static QueueDescription parseFromEntry(Node xEntry) {
        QueueDescription qd = null;
        NodeList nList = xEntry.getChildNodes();
        block44: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    qd = new QueueDescription(element.getFirstChild().getNodeValue());
                    continue block44;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block45: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "MaxSizeInMegabytes": {
                                qd.maxSizeInMB = Long.parseLong(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "RequiresDuplicateDetection": {
                                qd.requiresDuplicateDetection = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "RequiresSession": {
                                qd.requiresSession = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "DeadLetteringOnMessageExpiration": {
                                qd.enableDeadLetteringOnMessageExpiration = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "DuplicateDetectionHistoryTimeWindow": {
                                qd.duplicationDetectionHistoryTimeWindow = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "LockDuration": {
                                qd.lockDuration = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "DefaultMessageTimeToLive": {
                                qd.defaultMessageTimeToLive = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "MaxDeliveryCount": {
                                qd.maxDeliveryCount = Integer.parseInt(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "EnableBatchedOperations": {
                                qd.enableBatchedOperations = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "Status": {
                                qd.status = EntityStatus.valueOf(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "AutoDeleteOnIdle": {
                                qd.autoDeleteOnIdle = Duration.parse(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "EnablePartitioning": {
                                qd.enablePartitioning = Boolean.parseBoolean(element.getFirstChild().getNodeValue());
                                continue block45;
                            }
                            case "UserMetadata": {
                                qd.userMetadata = element.getFirstChild().getNodeValue();
                                continue block45;
                            }
                            case "ForwardTo": {
                                Node fwd = element.getFirstChild();
                                if (fwd == null) continue block45;
                                qd.forwardTo = fwd.getNodeValue();
                                continue block45;
                            }
                            case "ForwardDeadLetteredMessagesTo": {
                                Node fwdDlq = element.getFirstChild();
                                if (fwdDlq == null) continue block45;
                                qd.forwardDeadLetteredMessagesTo = fwdDlq.getNodeValue();
                                continue block45;
                            }
                            case "AuthorizationRules": {
                                qd.authorizationRules = AuthorizationRuleSerializer.parseAuthRules(element);
                            }
                        }
                    }
                    continue block44;
                }
            }
        }
        return qd;
    }

    static void normalizeDescription(QueueDescription queueDescription, URI baseAddress) {
        if (queueDescription.getForwardTo() != null) {
            queueDescription.setForwardTo(QueueDescriptionSerializer.normalizeForwardToAddress(queueDescription.getForwardTo(), baseAddress));
        }
        if (queueDescription.getForwardDeadLetteredMessagesTo() != null) {
            queueDescription.setForwardDeadLetteredMessagesTo(QueueDescriptionSerializer.normalizeForwardToAddress(queueDescription.getForwardDeadLetteredMessagesTo(), baseAddress));
        }
    }

    private static String normalizeForwardToAddress(String forwardTo, URI baseAddress) {
        try {
            URL url = new URL(forwardTo);
            return forwardTo;
        }
        catch (MalformedURLException e) {
            return baseAddress.resolve(forwardTo).toString();
        }
    }
}

