/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.MessageCountDetails;
import com.microsoft.azure.servicebus.management.QueueDescriptionSerializer;
import com.microsoft.azure.servicebus.management.QueueRuntimeInfo;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueueRuntimeInfoSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(QueueDescriptionSerializer.class);

    static QueueRuntimeInfo parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if (doc.getTagName() == "entry") {
                    return QueueRuntimeInfoSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.error("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Queue was not found");
    }

    private static QueueRuntimeInfo parseFromEntry(Node xEntry) {
        QueueRuntimeInfo qd = null;
        NodeList nList = xEntry.getChildNodes();
        block38: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    qd = new QueueRuntimeInfo(element.getFirstChild().getNodeValue());
                    continue block38;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block39: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "AccessedAt": {
                                qd.setAccessedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "CreatedAt": {
                                qd.setCreatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "UpdatedAt": {
                                qd.setUpdatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "MessageCount": {
                                qd.setMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "SizeInBytes": {
                                qd.setSizeInBytes(Long.parseLong(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "CountDetails": {
                                qd.setMessageCountDetails(new MessageCountDetails());
                                NodeList mcDetails = element.getChildNodes();
                                block40: for (int k = 0; k < mcDetails.getLength(); ++k) {
                                    String localName;
                                    Node node2 = mcDetails.item(k);
                                    if (node2.getNodeType() != 1) continue;
                                    element = (Element)node2;
                                    switch (localName = element.getTagName().substring(element.getTagName().indexOf(58) + 1)) {
                                        case "ActiveMessageCount": {
                                            qd.getMessageCountDetails().setActiveMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "DeadLetterMessageCount": {
                                            qd.getMessageCountDetails().setDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "ScheduledMessageCount": {
                                            qd.getMessageCountDetails().setScheduledMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "TransferMessageCount": {
                                            qd.getMessageCountDetails().setTransferMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "TransferDeadLetterMessageCount": {
                                            qd.getMessageCountDetails().setTransferDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                        }
                                    }
                                }
                                continue block39;
                            }
                        }
                    }
                    continue block38;
                }
            }
        }
        return qd;
    }
}

