/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import java.time.Duration;

public class SerializerUtil {
    public static String serializeDuration(Duration duration) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            return "";
        }
        Duration remainingTime = duration;
        StringBuffer sb = new StringBuffer("P");
        long days = remainingTime.toDays();
        if (days > 0L) {
            sb.append(days).append("D");
            remainingTime = duration.minusDays(days);
        }
        if (!remainingTime.isZero()) {
            long seconds;
            long minutes;
            sb.append("T");
            long hours = remainingTime.toHours();
            if (hours > 0L) {
                sb.append(hours).append("H");
                remainingTime = duration.minusHours(hours);
            }
            if ((minutes = remainingTime.toMinutes()) > 0L) {
                sb.append(minutes).append("M");
                remainingTime = duration.minusMinutes(minutes);
            }
            if ((seconds = remainingTime.getSeconds()) > 0L) {
                sb.append(seconds).append("S");
            }
        }
        return sb.toString();
    }
}

