/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import java.time.Duration;

public class SubscriptionDescription {
    private String topicPath;
    private String subscriptionName;
    Duration lockDuration = ManagementClientConstants.DEFAULT_LOCK_DURATION;
    Duration defaultMessageTimeToLive = ManagementClientConstants.MAX_DURATION;
    Duration autoDeleteOnIdle = ManagementClientConstants.MAX_DURATION;
    int maxDeliveryCount = ManagementClientConstants.DEFAULT_MAX_DELIVERY_COUNT;
    String forwardTo = null;
    String forwardDeadLetteredMessagesTo = null;
    String userMetadata = null;
    boolean enableDeadLetteringOnMessageExpiration = false;
    boolean enableDeadLetteringOnFilterEvaluationException = true;
    boolean requiresSession = false;
    boolean enableBatchedOperations = true;
    EntityStatus status = EntityStatus.Active;
    RuleDescription defaultRule = null;

    public SubscriptionDescription(String topicPath, String subscriptionName) {
        this.setTopicPath(topicPath);
        this.setSubscriptionName(subscriptionName);
    }

    public String getTopicPath() {
        return this.topicPath;
    }

    private void setTopicPath(String topicPath) {
        EntityNameHelper.checkValidTopicName(topicPath);
        this.topicPath = topicPath;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    private void setSubscriptionName(String subscriptionName) {
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        this.subscriptionName = subscriptionName;
    }

    public String getPath() {
        return EntityNameHelper.formatSubscriptionPath(this.topicPath, this.subscriptionName);
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public void setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        if (this.lockDuration.compareTo(ManagementClientConstants.MAX_DURATION) > 0) {
            this.lockDuration = ManagementClientConstants.MAX_DURATION;
        }
    }

    public boolean isRequiresSession() {
        return this.requiresSession;
    }

    public void setRequiresSession(boolean requiresSession) {
        this.requiresSession = requiresSession;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (defaultMessageTimeToLive != null && (defaultMessageTimeToLive.compareTo(ManagementClientConstants.MIN_ALLOWED_TTL) < 0 || defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_ALLOWED_TTL) > 0)) {
            throw new IllegalArgumentException(String.format("The value must be between %s and %s.", ManagementClientConstants.MAX_ALLOWED_TTL, ManagementClientConstants.MIN_ALLOWED_TTL));
        }
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (autoDeleteOnIdle != null && autoDeleteOnIdle.compareTo(ManagementClientConstants.MIN_ALLOWED_AUTODELETE_DURATION) < 0) {
            throw new IllegalArgumentException(String.format("The value must be greater than %s.", ManagementClientConstants.MIN_ALLOWED_AUTODELETE_DURATION));
        }
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        if (this.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) > 0) {
            this.autoDeleteOnIdle = ManagementClientConstants.MAX_DURATION;
        }
    }

    public boolean isEnableDeadLetteringOnMessageExpiration() {
        return this.enableDeadLetteringOnMessageExpiration;
    }

    public void setEnableDeadLetteringOnMessageExpiration(boolean enableDeadLetteringOnMessageExpiration) {
        this.enableDeadLetteringOnMessageExpiration = enableDeadLetteringOnMessageExpiration;
    }

    public boolean isEnableDeadLetteringOnFilterEvaluationException() {
        return this.enableDeadLetteringOnFilterEvaluationException;
    }

    public void setEnableDeadLetteringOnFilterEvaluationException(boolean enableDeadLetteringOnFilterEvaluationException) {
        this.enableDeadLetteringOnFilterEvaluationException = enableDeadLetteringOnFilterEvaluationException;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public void setMaxDeliveryCount(int maxDeliveryCount) {
        if (maxDeliveryCount < ManagementClientConstants.MIN_ALLOWED_MAX_DELIVERYCOUNT) {
            throw new IllegalArgumentException(String.format("The value must be greater than %s.", ManagementClientConstants.MIN_ALLOWED_MAX_DELIVERYCOUNT));
        }
        this.maxDeliveryCount = maxDeliveryCount;
    }

    public boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public void setEnableBatchedOperations(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
    }

    public EntityStatus getEntityStatus() {
        return this.status;
    }

    public void setEntityStatus(EntityStatus status) {
        this.status = status;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public void setForwardTo(String forwardTo) {
        if (forwardTo == null || forwardTo.isEmpty()) {
            this.forwardTo = forwardTo;
            return;
        }
        EntityNameHelper.checkValidQueueName(forwardTo);
        if (this.topicPath.equals(forwardTo)) {
            throw new IllegalArgumentException("Entity cannot have auto-forwarding policy to itself");
        }
        this.forwardTo = forwardTo;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public void setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        if (forwardDeadLetteredMessagesTo == null || forwardDeadLetteredMessagesTo.isEmpty()) {
            this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
            return;
        }
        EntityNameHelper.checkValidQueueName(forwardDeadLetteredMessagesTo);
        if (this.topicPath.equals(forwardDeadLetteredMessagesTo)) {
            throw new IllegalArgumentException("Entity cannot have auto-forwarding policy to itself");
        }
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(String userMetadata) {
        if (userMetadata == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (userMetadata.length() > ManagementClientConstants.MAX_USERMETADATA_LENGTH) {
            throw new IllegalArgumentException("Length cannot cross " + ManagementClientConstants.MAX_USERMETADATA_LENGTH + " characters");
        }
        this.userMetadata = userMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionDescription)) {
            return false;
        }
        SubscriptionDescription other = (SubscriptionDescription)o;
        return this.topicPath.equalsIgnoreCase(other.topicPath) && this.subscriptionName.equalsIgnoreCase(other.subscriptionName) && this.autoDeleteOnIdle.equals(other.autoDeleteOnIdle) && this.defaultMessageTimeToLive.equals(other.defaultMessageTimeToLive) && this.enableBatchedOperations == other.enableBatchedOperations && this.enableDeadLetteringOnMessageExpiration == other.enableDeadLetteringOnMessageExpiration && this.enableDeadLetteringOnFilterEvaluationException == other.enableDeadLetteringOnFilterEvaluationException && (this.forwardTo == null ? other.forwardTo == null : this.forwardTo.equalsIgnoreCase(other.forwardTo)) && (this.forwardDeadLetteredMessagesTo == null ? other.forwardDeadLetteredMessagesTo == null : this.forwardDeadLetteredMessagesTo.equalsIgnoreCase(other.forwardDeadLetteredMessagesTo)) && this.lockDuration.equals(other.lockDuration) && this.maxDeliveryCount == other.maxDeliveryCount && this.requiresSession == other.requiresSession && this.status.equals((Object)other.status) && (this.userMetadata == null ? other.userMetadata == null : this.userMetadata.equals(other.userMetadata));
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

