/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageBrowser;
import com.microsoft.azure.servicebus.IMessageReceiver;
import com.microsoft.azure.servicebus.InitializableEntity;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.MessageBrowser;
import com.microsoft.azure.servicebus.MessageConverter;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.TransactionContext;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.CoreMessageReceiver;
import com.microsoft.azure.servicebus.primitives.MessageWithDeliveryTag;
import com.microsoft.azure.servicebus.primitives.MessageWithLockToken;
import com.microsoft.azure.servicebus.primitives.MessagingEntityType;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.primitives.SettleModePair;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.Timer;
import com.microsoft.azure.servicebus.primitives.TimerType;
import com.microsoft.azure.servicebus.primitives.Util;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageReceiver
extends InitializableEntity
implements IMessageReceiver,
IMessageBrowser {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MessageReceiver.class);
    private static final int DEFAULT_PREFETCH_COUNT_PEEKLOCK = 0;
    private static final int DEFAULT_PREFETCH_COUNT_RECEIVEANDDELETE = 0;
    private final ReceiveMode receiveMode;
    private boolean ownsMessagingFactory;
    private URI namespaceEndpointURI;
    private ClientSettings clientSettings;
    private String entityPath = null;
    private MessagingEntityType entityType = null;
    private MessagingFactory messagingFactory = null;
    private CoreMessageReceiver internalReceiver = null;
    private boolean isInitialized = false;
    private MessageBrowser browser = null;
    private int messagePrefetchCount;
    private ScheduledFuture<?> requestResponseLockTokenPruner = null;
    private final ConcurrentHashMap<UUID, Instant> requestResponseLockTokensToLockTimesMap;

    private MessageReceiver(ReceiveMode receiveMode) {
        super(StringUtil.getShortRandomString());
        this.receiveMode = receiveMode;
        this.requestResponseLockTokensToLockTimesMap = new ConcurrentHashMap();
        this.messagePrefetchCount = receiveMode == ReceiveMode.PEEKLOCK ? 0 : 0;
    }

    private MessageReceiver(MessagingFactory messagingFactory, String entityPath, MessagingEntityType entityType, boolean ownsMessagingFactory, ReceiveMode receiveMode) {
        this(receiveMode);
        this.messagingFactory = messagingFactory;
        this.entityPath = entityPath;
        this.entityType = entityType;
        this.ownsMessagingFactory = ownsMessagingFactory;
    }

    MessageReceiver(URI namespaceEndpointURI, String entityPath, MessagingEntityType entityType, ClientSettings clientSettings, ReceiveMode receiveMode) {
        this(receiveMode);
        this.namespaceEndpointURI = namespaceEndpointURI;
        this.clientSettings = clientSettings;
        this.entityPath = entityPath;
        this.entityType = entityType;
        this.ownsMessagingFactory = true;
    }

    MessageReceiver(MessagingFactory messagingFactory, String entityPath, MessagingEntityType entityType, ReceiveMode receiveMode) {
        this(messagingFactory, entityPath, entityType, false, receiveMode);
    }

    @Override
    synchronized CompletableFuture<Void> initializeAsync() {
        CompletionStage<Object> factoryFuture;
        if (this.isInitialized) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.messagingFactory == null) {
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info("Creating MessagingFactory to namespace '{}'", (Object)this.namespaceEndpointURI.toString());
            }
            factoryFuture = MessagingFactory.createFromNamespaceEndpointURIAsyc(this.namespaceEndpointURI, this.clientSettings).thenAcceptAsync(f -> {
                this.messagingFactory = f;
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info("Created MessagingFactory to namespace '{}'", (Object)this.namespaceEndpointURI.toString());
                }
            });
        } else {
            factoryFuture = CompletableFuture.completedFuture(null);
        }
        return factoryFuture.thenComposeAsync(v -> {
            CompletionStage<Object> acceptReceiverFuture;
            if (this.internalReceiver == null) {
                CompletableFuture<CoreMessageReceiver> receiverFuture;
                if (this.isSessionReceiver()) {
                    TRACE_LOGGER.info("Creating SessionReceiver to entity '{}', requestedSessionId '{}', browsable session '{}', ReceiveMode '{}'", new Object[]{this.entityPath, this.getRequestedSessionId(), this.isBrowsableSession(), this.receiveMode});
                    receiverFuture = CoreMessageReceiver.create(this.messagingFactory, StringUtil.getShortRandomString(), this.entityPath, this.getRequestedSessionId(), this.isBrowsableSession(), this.messagePrefetchCount, MessageReceiver.getSettleModePairForRecevieMode(this.receiveMode), this.entityType);
                } else {
                    TRACE_LOGGER.info("Creating MessageReceiver to entity '{}', ReceiveMode '{}'", (Object)this.entityPath, (Object)this.receiveMode);
                    receiverFuture = CoreMessageReceiver.create(this.messagingFactory, StringUtil.getShortRandomString(), this.entityPath, this.messagePrefetchCount, MessageReceiver.getSettleModePairForRecevieMode(this.receiveMode), this.entityType);
                }
                acceptReceiverFuture = receiverFuture.whenCompleteAsync((r, coreReceiverCreationEx) -> {
                    if (coreReceiverCreationEx == null) {
                        this.internalReceiver = r;
                        if (this.isSessionReceiver()) {
                            TRACE_LOGGER.info("Created SessionReceiver to entity '{}', requestedSessionId '{}', browsable session '{}', acceptedSessionId '{}'", new Object[]{this.entityPath, this.getRequestedSessionId(), this.isBrowsableSession(), this.internalReceiver.getSessionId()});
                        } else {
                            TRACE_LOGGER.info("Created MessageReceiver to entity '{}'", (Object)this.entityPath);
                        }
                    } else if (this.ownsMessagingFactory) {
                        this.messagingFactory.closeAsync();
                    }
                }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
            } else {
                acceptReceiverFuture = CompletableFuture.completedFuture(null);
            }
            return acceptReceiverFuture.thenRunAsync(() -> {
                this.isInitialized = true;
                this.schedulePruningRequestResponseLockTokens();
                this.browser = new MessageBrowser(this);
                if (this.isSessionReceiver()) {
                    TRACE_LOGGER.info("Created MessageBrowser to entity '{}', sessionid '{}'", (Object)this.entityPath, (Object)this.internalReceiver.getSessionId());
                } else {
                    TRACE_LOGGER.info("Created MessageBrowser to entity '{}'", (Object)this.entityPath);
                }
            }, MessagingFactory.INTERNAL_THREAD_POOL);
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    protected boolean isSessionReceiver() {
        return false;
    }

    protected boolean isBrowsableSession() {
        return false;
    }

    protected String getRequestedSessionId() {
        return null;
    }

    protected final CoreMessageReceiver getInternalReceiver() {
        return this.internalReceiver;
    }

    @Override
    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public ReceiveMode getReceiveMode() {
        return this.receiveMode;
    }

    @Override
    public void abandon(UUID lockToken) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.abandonAsync(lockToken));
    }

    @Override
    public void abandon(UUID lockToken, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.abandonAsync(lockToken, transaction));
    }

    @Override
    public void abandon(UUID lockToken, Map<String, Object> propertiesToModify) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.abandonAsync(lockToken, propertiesToModify));
    }

    @Override
    public void abandon(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.abandonAsync(lockToken, propertiesToModify, transaction));
    }

    @Override
    public CompletableFuture<Void> abandonAsync(UUID lockToken) {
        return this.abandonAsync(lockToken, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> abandonAsync(UUID lockToken, TransactionContext transaction) {
        return this.abandonAsync(lockToken, null, transaction);
    }

    @Override
    public CompletableFuture<Void> abandonAsync(UUID lockToken, Map<String, Object> propertiesToModify) {
        return this.abandonAsync(lockToken, propertiesToModify, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> abandonAsync(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) {
        this.ensurePeekLockReceiveMode();
        TRACE_LOGGER.debug("Abandoning message with lock token '{}'", (Object)lockToken);
        return this.checkIfValidRequestResponseLockTokenAsync(lockToken).thenCompose(requestResponseLocked -> {
            if (requestResponseLocked.booleanValue()) {
                return this.internalReceiver.abandonMessageAsync(lockToken, propertiesToModify, transaction).thenRun(() -> this.disposeLockToken(lockToken, transaction));
            }
            return this.internalReceiver.abandonMessageAsync(Util.convertUUIDToDotNetBytes(lockToken), propertiesToModify, transaction);
        });
    }

    @Override
    public void complete(UUID lockToken) throws InterruptedException, ServiceBusException {
        this.complete(lockToken, TransactionContext.NULL_TXN);
    }

    @Override
    public void complete(UUID lockToken, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.completeAsync(lockToken, transaction));
    }

    @Override
    public CompletableFuture<Void> completeAsync(UUID lockToken) {
        return this.completeAsync(lockToken, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> completeAsync(UUID lockToken, TransactionContext transaction) {
        this.ensurePeekLockReceiveMode();
        TRACE_LOGGER.debug("Completing message with lock token '{}'", (Object)lockToken);
        return this.checkIfValidRequestResponseLockTokenAsync(lockToken).thenCompose(requestResponseLocked -> {
            if (requestResponseLocked.booleanValue()) {
                return this.internalReceiver.completeMessageAsync(lockToken, transaction).thenRun(() -> this.disposeLockToken(lockToken, transaction));
            }
            return this.internalReceiver.completeMessageAsync(Util.convertUUIDToDotNetBytes(lockToken), transaction);
        });
    }

    @Override
    public void defer(UUID lockToken) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deferAsync(lockToken));
    }

    @Override
    public void defer(UUID lockToken, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deferAsync(lockToken, transaction));
    }

    @Override
    public void defer(UUID lockToken, Map<String, Object> propertiesToModify) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deferAsync(lockToken, propertiesToModify));
    }

    @Override
    public void defer(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deferAsync(lockToken, propertiesToModify, transaction));
    }

    @Override
    public CompletableFuture<Void> deferAsync(UUID lockToken) {
        return this.deferAsync(lockToken, null, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deferAsync(UUID lockToken, TransactionContext transaction) {
        return this.deferAsync(lockToken, null, transaction);
    }

    @Override
    public CompletableFuture<Void> deferAsync(UUID lockToken, Map<String, Object> propertiesToModify) {
        return this.deferAsync(lockToken, propertiesToModify, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deferAsync(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) {
        this.ensurePeekLockReceiveMode();
        TRACE_LOGGER.debug("Deferring message with lock token '{}'", (Object)lockToken);
        return this.checkIfValidRequestResponseLockTokenAsync(lockToken).thenCompose(requestResponseLocked -> {
            if (requestResponseLocked.booleanValue()) {
                return this.internalReceiver.deferMessageAsync(lockToken, propertiesToModify, transaction).thenRun(() -> this.disposeLockToken(lockToken, transaction));
            }
            return this.internalReceiver.deferMessageAsync(Util.convertUUIDToDotNetBytes(lockToken), propertiesToModify, transaction);
        });
    }

    @Override
    public void deadLetter(UUID lockToken) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken));
    }

    @Override
    public void deadLetter(UUID lockToken, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, transaction));
    }

    @Override
    public void deadLetter(UUID lockToken, Map<String, Object> propertiesToModify) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, propertiesToModify));
    }

    @Override
    public void deadLetter(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, propertiesToModify, transaction));
    }

    @Override
    public void deadLetter(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription));
    }

    @Override
    public void deadLetter(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, transaction));
    }

    @Override
    public void deadLetter(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, propertiesToModify));
    }

    @Override
    public void deadLetter(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, TransactionContext transaction) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, propertiesToModify, transaction));
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken) {
        return this.deadLetterAsync(lockToken, null, null, null, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, TransactionContext transaction) {
        return this.deadLetterAsync(lockToken, null, null, null, transaction);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, Map<String, Object> propertiesToModify) {
        return this.deadLetterAsync(lockToken, null, null, propertiesToModify, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, Map<String, Object> propertiesToModify, TransactionContext transaction) {
        return this.deadLetterAsync(lockToken, null, null, propertiesToModify, transaction);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription) {
        return this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, null, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, TransactionContext transaction) {
        return this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, null, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify) {
        return this.deadLetterAsync(lockToken, deadLetterReason, deadLetterErrorDescription, propertiesToModify, TransactionContext.NULL_TXN);
    }

    @Override
    public CompletableFuture<Void> deadLetterAsync(UUID lockToken, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, TransactionContext transaction) {
        this.ensurePeekLockReceiveMode();
        TRACE_LOGGER.debug("Deadlettering message with lock token '{}'", (Object)lockToken);
        return this.checkIfValidRequestResponseLockTokenAsync(lockToken).thenCompose(requestResponseLocked -> {
            if (requestResponseLocked.booleanValue()) {
                return this.internalReceiver.deadLetterMessageAsync(lockToken, deadLetterReason, deadLetterErrorDescription, propertiesToModify, transaction).thenRun(() -> this.disposeLockToken(lockToken, transaction));
            }
            return this.internalReceiver.deadLetterMessageAsync(Util.convertUUIDToDotNetBytes(lockToken), deadLetterReason, deadLetterErrorDescription, propertiesToModify, transaction);
        });
    }

    @Override
    public IMessage receive() throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.receiveAsync());
    }

    @Override
    public IMessage receive(Duration serverWaitTime) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.receiveAsync(serverWaitTime));
    }

    @Override
    public IMessage receiveDeferredMessage(long sequenceNumber) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.receiveDeferredMessageAsync(sequenceNumber));
    }

    @Override
    public Collection<IMessage> receiveBatch(int maxMessageCount) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.receiveBatchAsync(maxMessageCount));
    }

    @Override
    public Collection<IMessage> receiveBatch(int maxMessageCount, Duration serverWaitTime) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.receiveBatchAsync(maxMessageCount, serverWaitTime));
    }

    @Override
    public Collection<IMessage> receiveDeferredMessageBatch(Collection<Long> sequenceNumbers) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.receiveDeferredMessageBatchAsync(sequenceNumbers));
    }

    @Override
    public CompletableFuture<IMessage> receiveAsync() {
        return this.receiveAsync(this.messagingFactory.getOperationTimeout());
    }

    @Override
    public CompletableFuture<IMessage> receiveAsync(Duration serverWaitTime) {
        return this.internalReceiver.receiveAsync(1, serverWaitTime).thenApplyAsync(c -> {
            if (c == null) {
                return null;
            }
            if (c.isEmpty()) {
                return null;
            }
            return MessageConverter.convertAmqpMessageToBrokeredMessage(c.toArray(new MessageWithDeliveryTag[0])[0]);
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    @Override
    public CompletableFuture<Collection<IMessage>> receiveBatchAsync(int maxMessageCount) {
        return this.receiveBatchAsync(maxMessageCount, this.messagingFactory.getOperationTimeout());
    }

    @Override
    public CompletableFuture<Collection<IMessage>> receiveBatchAsync(int maxMessageCount, Duration serverWaitTime) {
        return this.internalReceiver.receiveAsync(maxMessageCount, serverWaitTime).thenApplyAsync(c -> {
            if (c == null) {
                return null;
            }
            if (c.isEmpty()) {
                return null;
            }
            return this.convertAmqpMessagesWithDeliveryTagsToBrokeredMessages((Collection<MessageWithDeliveryTag>)c);
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    @Override
    public CompletableFuture<IMessage> receiveDeferredMessageAsync(long sequenceNumber) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(sequenceNumber);
        return this.receiveDeferredMessageBatchAsync(list).thenApplyAsync(c -> {
            if (c == null) {
                return null;
            }
            if (c.isEmpty()) {
                return null;
            }
            return c.toArray(new Message[0])[0];
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    @Override
    public CompletableFuture<Collection<IMessage>> receiveDeferredMessageBatchAsync(Collection<Long> sequenceNumbers) {
        TRACE_LOGGER.debug("Receiving messages by sequence numbers '{}' from entity '{}'", sequenceNumbers, (Object)this.entityPath);
        return this.internalReceiver.receiveDeferredMessageBatchAsync(sequenceNumbers.toArray(new Long[0])).thenApplyAsync(c -> {
            if (c == null) {
                return null;
            }
            if (c.isEmpty()) {
                return null;
            }
            return this.convertAmqpMessagesWithLockTokensToBrokeredMessages((Collection<MessageWithLockToken>)c);
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (this.isInitialized) {
            if (this.isSessionReceiver()) {
                TRACE_LOGGER.info("Closing SessionReceiver to entity '{}', browsable session '{}', sessionId '{}'", new Object[]{this.entityPath, this.isBrowsableSession(), this.internalReceiver.getSessionId()});
            } else {
                TRACE_LOGGER.info("Closing MessageReceiver to entity '{}'", (Object)this.entityPath);
            }
            if (this.requestResponseLockTokenPruner != null) {
                this.requestResponseLockTokenPruner.cancel(false);
            }
            CompletableFuture<Void> closeReceiverFuture = this.internalReceiver.closeAsync();
            return closeReceiverFuture.thenComposeAsync(v -> {
                if (this.isSessionReceiver()) {
                    TRACE_LOGGER.info("Closed SessionReceiver to entity '{}', browsable session '{}', sessionId '{}'", new Object[]{this.entityPath, this.isBrowsableSession(), this.internalReceiver.getSessionId()});
                } else {
                    TRACE_LOGGER.info("Closed MessageReceiver to entity '{}'", (Object)this.entityPath);
                }
                if (this.ownsMessagingFactory) {
                    if (TRACE_LOGGER.isInfoEnabled()) {
                        TRACE_LOGGER.info("Closing MessagingFactory associated with namespace '{}'", (Object)this.namespaceEndpointURI.toString());
                    }
                    return this.messagingFactory.closeAsync();
                }
                return CompletableFuture.completedFuture(null);
            }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getPrefetchCount() {
        return this.messagePrefetchCount;
    }

    @Override
    public void setPrefetchCount(int prefetchCount) throws ServiceBusException {
        this.messagePrefetchCount = prefetchCount;
        if (this.isInitialized) {
            if (this.isSessionReceiver()) {
                TRACE_LOGGER.info("Setting prefetch count on session receiver to entity '{}', sessionid '{}' to '{}'", new Object[]{this.entityPath, this.internalReceiver.getSessionId(), prefetchCount});
            } else {
                TRACE_LOGGER.info("Setting prefetch count on session receiver to entity '{}' to '{}'", (Object)this.entityPath, (Object)prefetchCount);
            }
            this.internalReceiver.setPrefetchCount(prefetchCount);
        }
    }

    private void disposeLockToken(UUID lockToken, TransactionContext transaction) {
        if (transaction != TransactionContext.NULL_TXN) {
            transaction.registerHandler(commit -> {
                if (commit) {
                    this.requestResponseLockTokensToLockTimesMap.remove(lockToken);
                }
            });
        } else {
            this.requestResponseLockTokensToLockTimesMap.remove(lockToken);
        }
    }

    private static SettleModePair getSettleModePairForRecevieMode(ReceiveMode receiveMode) {
        if (receiveMode == ReceiveMode.RECEIVEANDDELETE) {
            return new SettleModePair(SenderSettleMode.SETTLED, ReceiverSettleMode.FIRST);
        }
        return new SettleModePair(SenderSettleMode.UNSETTLED, ReceiverSettleMode.SECOND);
    }

    private Collection<IMessage> convertAmqpMessagesWithDeliveryTagsToBrokeredMessages(Collection<MessageWithDeliveryTag> amqpMessages) {
        ArrayList<IMessage> convertedMessages = new ArrayList<IMessage>();
        for (MessageWithDeliveryTag amqpMessageWithDeliveryTag : amqpMessages) {
            convertedMessages.add(MessageConverter.convertAmqpMessageToBrokeredMessage(amqpMessageWithDeliveryTag));
        }
        return convertedMessages;
    }

    private Collection<IMessage> convertAmqpMessagesWithLockTokensToBrokeredMessages(Collection<MessageWithLockToken> amqpMessages) {
        ArrayList<IMessage> convertedMessages = new ArrayList<IMessage>();
        for (MessageWithLockToken amqpMessageWithLockToken : amqpMessages) {
            Message convertedMessage = MessageConverter.convertAmqpMessageToBrokeredMessage(amqpMessageWithLockToken);
            convertedMessages.add(convertedMessage);
            if (convertedMessage.getLockToken().equals(ClientConstants.ZEROLOCKTOKEN)) continue;
            this.requestResponseLockTokensToLockTimesMap.put(convertedMessage.getLockToken(), convertedMessage.getLockedUntilUtc());
        }
        return convertedMessages;
    }

    private void ensurePeekLockReceiveMode() {
        if (this.receiveMode != ReceiveMode.PEEKLOCK) {
            throw new UnsupportedOperationException("Operations Complete/Abandon/DeadLetter/Defer cannot be called on a receiver opened in ReceiveAndDelete mode.");
        }
    }

    private CompletableFuture<Boolean> checkIfValidRequestResponseLockTokenAsync(UUID lockToken) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Instant lockedUntilUtc = this.requestResponseLockTokensToLockTimesMap.get(lockToken);
        if (lockedUntilUtc == null) {
            future.complete(false);
        } else if (lockedUntilUtc.isBefore(Instant.now())) {
            future.completeExceptionally(new ServiceBusException(false, "Lock already expired for the lock token."));
        } else {
            future.complete(true);
        }
        return future;
    }

    @Override
    public CompletableFuture<Instant> renewMessageLockAsync(IMessage message) {
        return this.renewMessageLockAsync(message.getLockToken()).thenApply(newLockedUntilUtc -> {
            ((Message)message).setLockedUntilUtc((Instant)newLockedUntilUtc);
            return newLockedUntilUtc;
        });
    }

    @Override
    public CompletableFuture<Instant> renewMessageLockAsync(UUID lockToken) {
        if (lockToken.equals(ClientConstants.ZEROLOCKTOKEN)) {
            throw new UnsupportedOperationException("Lock of a message received in ReceiveAndDelete mode cannot be renewed.");
        }
        return this.renewMessageLockBatchAsync(new UUID[]{lockToken}).thenApply(c -> c.toArray(new Instant[0])[0]);
    }

    public CompletableFuture<Collection<Instant>> renewMessageLockBatchAsync(Collection<? extends IMessage> messages) {
        this.ensurePeekLockReceiveMode();
        if (messages == null || messages.size() == 0) {
            throw new UnsupportedOperationException("Message collection is null or empty. Locks cannot be renewed.");
        }
        UUID[] lockTokens = new UUID[messages.size()];
        int messageIndex = 0;
        for (IMessage iMessage : messages) {
            UUID lockToken = iMessage.getLockToken();
            if (lockToken.equals(ClientConstants.ZEROLOCKTOKEN)) {
                throw new UnsupportedOperationException("Lock of a message received in ReceiveAndDelete mode cannot be renewed.");
            }
            lockTokens[messageIndex++] = lockToken;
        }
        return this.renewMessageLockBatchAsync(lockTokens);
    }

    private CompletableFuture<Collection<Instant>> renewMessageLockBatchAsync(UUID[] lockTokens) {
        this.ensurePeekLockReceiveMode();
        if (TRACE_LOGGER.isDebugEnabled()) {
            TRACE_LOGGER.debug("Renewing message locks of lock tokens '{}'", (Object)Arrays.toString(lockTokens));
        }
        return this.internalReceiver.renewMessageLocksAsync(lockTokens).thenApplyAsync(newLockedUntilTimes -> {
            if (TRACE_LOGGER.isDebugEnabled()) {
                TRACE_LOGGER.debug("Renewed message locks of lock tokens '{}'", (Object)Arrays.toString(lockTokens));
            }
            Iterator lockTimeIterator = newLockedUntilTimes.iterator();
            for (UUID lockToken : lockTokens) {
                if (!lockTimeIterator.hasNext()) continue;
                Instant lockedUntilUtc = (Instant)lockTimeIterator.next();
                this.requestResponseLockTokensToLockTimesMap.computeIfPresent(lockToken, (k, v) -> lockedUntilUtc);
            }
            return newLockedUntilTimes;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
    }

    public Collection<Instant> renewMessageLockBatch(Collection<? extends IMessage> messages) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.renewMessageLockBatchAsync(messages));
    }

    @Override
    public Instant renewMessageLock(IMessage message) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.renewMessageLockAsync(message));
    }

    @Override
    public Instant renewMessageLock(UUID lockToken) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.renewMessageLockAsync(lockToken));
    }

    @Override
    public IMessage peek() throws InterruptedException, ServiceBusException {
        return this.browser.peek();
    }

    @Override
    public IMessage peek(long fromSequenceNumber) throws InterruptedException, ServiceBusException {
        return this.browser.peek(fromSequenceNumber);
    }

    @Override
    public Collection<IMessage> peekBatch(int messageCount) throws InterruptedException, ServiceBusException {
        return this.browser.peekBatch(messageCount);
    }

    @Override
    public Collection<IMessage> peekBatch(long fromSequenceNumber, int messageCount) throws InterruptedException, ServiceBusException {
        return this.browser.peekBatch(fromSequenceNumber, messageCount);
    }

    @Override
    public CompletableFuture<IMessage> peekAsync() {
        return this.browser.peekAsync();
    }

    @Override
    public CompletableFuture<IMessage> peekAsync(long fromSequenceNumber) {
        return this.browser.peekAsync(fromSequenceNumber);
    }

    @Override
    public CompletableFuture<Collection<IMessage>> peekBatchAsync(int messageCount) {
        return this.browser.peekBatchAsync(messageCount);
    }

    @Override
    public CompletableFuture<Collection<IMessage>> peekBatchAsync(long fromSequenceNumber, int messageCount) {
        return this.browser.peekBatchAsync(fromSequenceNumber, messageCount);
    }

    private void schedulePruningRequestResponseLockTokens() {
        this.requestResponseLockTokenPruner = Timer.schedule(() -> {
            Map.Entry[] copyOfEntries;
            if (this.getIsClosed()) {
                this.requestResponseLockTokenPruner.cancel(true);
                return;
            }
            Instant systemTime = Instant.now();
            for (Map.Entry entry : copyOfEntries = (Map.Entry[])this.requestResponseLockTokensToLockTimesMap.entrySet().toArray()) {
                if (!((Instant)entry.getValue()).isBefore(systemTime)) continue;
                this.requestResponseLockTokensToLockTimesMap.remove(entry.getKey());
            }
        }, Duration.ofSeconds(3600L), TimerType.RepeatRun);
    }

    MessagingFactory getMessagingFactory() {
        return this.messagingFactory;
    }
}

