/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;

public class TransactionContext {
    public static TransactionContext NULL_TXN = new TransactionContext(null, null);
    private ByteBuffer txnId;
    private ITransactionHandler txnHandler = null;
    private MessagingFactory messagingFactory;

    public TransactionContext(ByteBuffer txnId, MessagingFactory messagingFactory) {
        this.txnId = txnId;
        this.messagingFactory = messagingFactory;
    }

    public ByteBuffer getTransactionId() {
        return this.txnId;
    }

    public String toString() {
        return new String(this.txnId.array(), this.txnId.position(), this.txnId.limit(), StandardCharsets.UTF_8);
    }

    public void commit() throws ServiceBusException, InterruptedException {
        if (this.messagingFactory == null) {
            throw new ServiceBusException(false, "MessagingFactory should not be null");
        }
        this.messagingFactory.endTransaction(this, true);
    }

    public CompletableFuture<Void> commitAsync() {
        if (this.messagingFactory == null) {
            CompletableFuture<Void> exceptionCompletion = new CompletableFuture<Void>();
            exceptionCompletion.completeExceptionally(new ServiceBusException(false, "MessagingFactory should not be null"));
            return exceptionCompletion;
        }
        return this.messagingFactory.endTransactionAsync(this, true);
    }

    public void rollback() throws ServiceBusException, InterruptedException {
        if (this.messagingFactory == null) {
            throw new ServiceBusException(false, "MessagingFactory should not be null");
        }
        this.messagingFactory.endTransaction(this, false);
    }

    public CompletableFuture<Void> rollbackAsync() {
        if (this.messagingFactory == null) {
            CompletableFuture<Void> exceptionCompletion = new CompletableFuture<Void>();
            exceptionCompletion.completeExceptionally(new ServiceBusException(false, "MessagingFactory should not be null"));
            return exceptionCompletion;
        }
        return this.messagingFactory.endTransactionAsync(this, false);
    }

    public void notifyTransactionCompletion(boolean commit) {
        if (this.txnHandler != null) {
            this.txnHandler.onTransactionCompleted(commit);
        }
    }

    void registerHandler(ITransactionHandler handler) {
        this.txnHandler = handler;
    }

    static interface ITransactionHandler {
        public void onTransactionCompleted(boolean var1);
    }
}

