/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.rules.CorrelationFilter;
import com.microsoft.azure.servicebus.rules.FalseFilter;
import com.microsoft.azure.servicebus.rules.Filter;
import com.microsoft.azure.servicebus.rules.RuleAction;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import com.microsoft.azure.servicebus.rules.SqlFilter;
import com.microsoft.azure.servicebus.rules.SqlRuleAction;
import com.microsoft.azure.servicebus.rules.TrueFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class RuleDescriptionSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(RuleDescriptionSerializer.class);

    RuleDescriptionSerializer() {
    }

    static String serialize(RuleDescription ruleDescription) throws ServiceBusException {
        DocumentBuilder dBuilder = null;
        try {
            DocumentBuilderFactory dbFactory = SerializerUtil.getDocumentBuilderFactory();
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        doc.appendChild(rootElement);
        Element contentElement = doc.createElementNS("http://www.w3.org/2005/Atom", "content");
        rootElement.appendChild(contentElement);
        contentElement.setAttribute("type", "application/xml");
        contentElement.appendChild(RuleDescriptionSerializer.serializeRule(doc, ruleDescription, "RuleDescription"));
        StringWriter output = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
        return output.toString();
    }

    static Element serializeRule(Document doc, RuleDescription ruleDescription, String rootName) throws ServiceBusException {
        Element rdElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", rootName);
        if (ruleDescription.getFilter() != null) {
            rdElement.appendChild(RuleDescriptionSerializer.serializeFilter(doc, ruleDescription.getFilter()));
        }
        if (ruleDescription.getAction() != null) {
            rdElement.appendChild(RuleDescriptionSerializer.serializeRuleAction(doc, ruleDescription.getAction()));
        }
        if (ruleDescription.getName() != null) {
            rdElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Name").appendChild(doc.createTextNode(ruleDescription.getName())).getParentNode());
        }
        return rdElement;
    }

    private static Element serializeFilter(Document doc, Filter filter) throws ServiceBusException {
        if (filter instanceof TrueFilter) {
            return RuleDescriptionSerializer.serializeSqlFilter(doc, (SqlFilter)filter, "TrueFilter");
        }
        if (filter instanceof FalseFilter) {
            return RuleDescriptionSerializer.serializeSqlFilter(doc, (SqlFilter)filter, "FalseFilter");
        }
        if (filter instanceof SqlFilter) {
            return RuleDescriptionSerializer.serializeSqlFilter(doc, (SqlFilter)filter, "SqlFilter");
        }
        if (filter instanceof CorrelationFilter) {
            return RuleDescriptionSerializer.serializeCorrelationFilter(doc, (CorrelationFilter)filter);
        }
        return null;
    }

    private static Element serializeSqlFilter(Document doc, SqlFilter filter, String filterName) {
        Element filterElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Filter");
        filterElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", filterName);
        filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SqlExpression").appendChild(doc.createTextNode(filter.getSqlExpression())).getParentNode());
        return filterElement;
    }

    private static Element serializeCorrelationFilter(Document doc, CorrelationFilter filter) throws ServiceBusException {
        if (filter.getProperties() != null) {
            throw new ServiceBusException(false, (Throwable)new UnsupportedOperationException("Correlation rules with custom properties is not yet implemented with ManagementClient"));
        }
        Element filterElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Filter");
        filterElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", "CorrelationFilter");
        if (filter.getCorrelationId() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CorrelationId").appendChild(doc.createTextNode(filter.getCorrelationId())).getParentNode());
        }
        if (filter.getMessageId() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageId").appendChild(doc.createTextNode(filter.getMessageId())).getParentNode());
        }
        if (filter.getTo() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "To").appendChild(doc.createTextNode(filter.getTo())).getParentNode());
        }
        if (filter.getReplyTo() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ReplyTo").appendChild(doc.createTextNode(filter.getReplyTo())).getParentNode());
        }
        if (filter.getLabel() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Label").appendChild(doc.createTextNode(filter.getLabel())).getParentNode());
        }
        if (filter.getSessionId() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SessionId").appendChild(doc.createTextNode(filter.getSessionId())).getParentNode());
        }
        if (filter.getReplyToSessionId() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ReplyToSessionId").appendChild(doc.createTextNode(filter.getReplyToSessionId())).getParentNode());
        }
        if (filter.getContentType() != null) {
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ContentType").appendChild(doc.createTextNode(filter.getContentType())).getParentNode());
        }
        return filterElement;
    }

    private static Element serializeRuleAction(Document doc, RuleAction ruleAction) {
        if (ruleAction instanceof SqlRuleAction) {
            Element filterElement = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Action");
            filterElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", "SqlRuleAction");
            filterElement.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SqlExpression").appendChild(doc.createTextNode(((SqlRuleAction)ruleAction).getSqlExpression())).getParentNode());
            return filterElement;
        }
        throw new UnsupportedOperationException("Rule action of type '" + ruleAction.getClass().getName() + "' is not implemented");
    }

    static List<RuleDescription> parseCollectionFromContent(String xml) {
        ArrayList<RuleDescription> ruleList;
        block4: {
            ruleList = new ArrayList<RuleDescription>();
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("entry")) continue;
                    ruleList.add(RuleDescriptionSerializer.parseFromEntry(node));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        return ruleList;
    }

    static RuleDescription parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if ("entry".equals(doc.getTagName())) {
                    return RuleDescriptionSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Rule was not found");
    }

    private static RuleDescription parseFromEntry(Node xEntry) {
        RuleDescription rd = null;
        NodeList nList = xEntry.getChildNodes();
        block18: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    rd = new RuleDescription(element.getFirstChild().getNodeValue());
                    continue block18;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block19: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "Name": {
                                rd.setName(element.getFirstChild().getNodeValue());
                                continue block19;
                            }
                            case "Filter": {
                                rd.setFilter(RuleDescriptionSerializer.parseFilterFromElement(element));
                                continue block19;
                            }
                            case "Action": {
                                rd.setAction(RuleDescriptionSerializer.parseActionFromElement(element));
                                continue block19;
                            }
                        }
                    }
                    continue block18;
                }
            }
        }
        return rd;
    }

    private static Filter parseFilterFromElement(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        String type = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (!attributeNode.getNodeName().endsWith("type")) continue;
            type = attributeNode.getNodeValue();
            break;
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case "SqlFilter": {
                return RuleDescriptionSerializer.parseSqlFilterFromElement(element);
            }
            case "CorrelationFilter": {
                return RuleDescriptionSerializer.parseCorrelationFilterFromElement(element);
            }
            case "TrueFilter": {
                return new TrueFilter();
            }
            case "FalseFilter": {
                return new FalseFilter();
            }
        }
        return null;
    }

    private static Filter parseSqlFilterFromElement(Element filterElement) {
        NodeList nList = filterElement.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "SqlExpression": {
                    return new SqlFilter(element.getFirstChild().getNodeValue());
                }
            }
        }
        return null;
    }

    private static Filter parseCorrelationFilterFromElement(Element filterElement) {
        CorrelationFilter filter = new CorrelationFilter();
        NodeList nList = filterElement.getChildNodes();
        block20: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "CorrelationId": {
                    filter.setCorrelationId(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "MessageId": {
                    filter.setMessageId(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "To": {
                    filter.setTo(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "ReplyTo": {
                    filter.setReplyTo(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "Label": {
                    filter.setLabel(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "SessionId": {
                    filter.setSessionId(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "ReplyToSessionId": {
                    filter.setReplyToSessionId(element.getFirstChild().getNodeValue());
                    continue block20;
                }
                case "ContentType": {
                    filter.setContentType(element.getFirstChild().getNodeValue());
                    continue block20;
                }
            }
        }
        return filter;
    }

    private static RuleAction parseActionFromElement(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        String type = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (!attributeNode.getNodeName().endsWith("type")) continue;
            type = attributeNode.getNodeValue();
            break;
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case "SqlRuleAction": {
                return RuleDescriptionSerializer.parseSqlActionFromElement(element);
            }
        }
        return null;
    }

    private static RuleAction parseSqlActionFromElement(Element filterElement) {
        NodeList nList = filterElement.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "SqlExpression": {
                    return new SqlRuleAction(element.getFirstChild().getNodeValue());
                }
            }
        }
        return null;
    }
}

