/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import java.time.Duration;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class SerializerUtil {
    private static final String XML_FEATURE_DISALLOW_DOC_TYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String XML_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String XML_FEATURE_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String XML_FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature(XML_FEATURE_DISALLOW_DOC_TYPE, true);
        dbf.setFeature(XML_FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        dbf.setFeature(XML_FEATURE_EXTERNAL_PARAM_ENTITIES, false);
        dbf.setFeature(XML_FEATURE_LOAD_EXTERNAL_DTD, false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    public static String serializeDuration(Duration duration) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            return "";
        }
        Duration remainingTime = duration;
        StringBuffer sb = new StringBuffer("P");
        long days = remainingTime.toDays();
        if (days > 0L) {
            sb.append(days).append("D");
            remainingTime = duration.minusDays(days);
        }
        if (!remainingTime.isZero()) {
            long seconds;
            long minutes;
            sb.append("T");
            long hours = remainingTime.toHours();
            if (hours > 0L) {
                sb.append(hours).append("H");
                remainingTime = duration.minusHours(hours);
            }
            if ((minutes = remainingTime.toMinutes()) > 0L) {
                sb.append(minutes).append("M");
                remainingTime = duration.minusMinutes(minutes);
            }
            if ((seconds = remainingTime.getSeconds()) > 0L) {
                sb.append(seconds).append("S");
            }
        }
        return sb.toString();
    }
}

