/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SecurityTokenType;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class AzureActiveDirectoryTokenProvider
extends TokenProvider {
    private final AuthenticationCallback authCallback;
    private final String authority;
    private final Object authCallbackState;

    AzureActiveDirectoryTokenProvider(AuthenticationCallback callback, String authority, Object callbackState) {
        this.authCallback = callback;
        this.authority = authority;
        this.authCallbackState = callbackState;
    }

    @Override
    public CompletableFuture<SecurityToken> getSecurityTokenAsync(String audience) {
        CompletableFuture<String> tokenStringFuture = this.authCallback.acquireTokenAsync("https://servicebus.azure.net/", this.authority, this.authCallbackState);
        return tokenStringFuture.thenApply(tokenString -> {
            try {
                Date expire = SecurityToken.getExpirationDateTimeUtcFromToken(tokenString);
                return new SecurityToken(SecurityTokenType.JWT, audience, (String)tokenString, Instant.now(), expire == null ? null : expire.toInstant());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @FunctionalInterface
    public static interface AuthenticationCallback {
        public CompletableFuture<String> acquireTokenAsync(String var1, String var2, Object var3);
    }
}

