/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpSender;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendLinkHandler
extends BaseLinkHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SendLinkHandler.class);
    private final IAmqpSender msgSender;
    private AtomicBoolean isFirstFlow;

    public SendLinkHandler(IAmqpSender sender) {
        super(sender);
        this.msgSender = sender;
        this.isFirstFlow = new AtomicBoolean(true);
    }

    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link != null && link instanceof Sender) {
            Sender sender = (Sender)link;
            if (link.getRemoteTarget() != null) {
                TRACE_LOGGER.debug("onLinkRemoteOpen: linkName:{}, remoteTarge:{}", (Object)sender.getName(), (Object)link.getRemoteTarget());
                if (this.isFirstFlow.compareAndSet(true, false)) {
                    this.msgSender.onOpenComplete(null);
                }
            } else {
                TRACE_LOGGER.debug("onLinkRemoteOpen: linkName:{}, remoteTarget:{}, remoteSource:{}, action:{}", new Object[]{sender.getName(), null, null, "waitingForError"});
            }
        }
    }

    public void onDelivery(Event event) {
        Delivery delivery = event.getDelivery();
        while (delivery != null) {
            Sender sender = (Sender)delivery.getLink();
            TRACE_LOGGER.debug("onDelivery: linkName:{}, unsettled:{}, credit:{}, deliveryState:{}, delivery.isBuffered:{}, delivery.tag:{}", new Object[]{sender.getName(), sender.getUnsettled(), sender.getRemoteCredit(), delivery.getRemoteState(), delivery.isBuffered(), delivery.getTag()});
            this.msgSender.onSendComplete(delivery);
            delivery.settle();
            delivery = sender.current();
        }
    }

    public void onLinkFlow(Event event) {
        if (this.isFirstFlow.compareAndSet(true, false)) {
            this.msgSender.onOpenComplete(null);
        }
        Sender sender = event.getSender();
        this.msgSender.onFlow(sender.getRemoteCredit());
        TRACE_LOGGER.debug("onLinkFlow: linkName:{}, unsettled:{}, credit:{}", new Object[]{sender.getName(), sender.getUnsettled(), sender.getCredit()});
    }
}

