/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.AuthorizationRule;
import com.microsoft.azure.servicebus.management.AuthorizationRuleSerializer;
import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.UnknownPropertiesHolder;
import java.time.Duration;
import java.util.List;

public class TopicDescription
extends UnknownPropertiesHolder {
    Duration duplicationDetectionHistoryTimeWindow = ManagementClientConstants.DEFAULT_HISTORY_DEDUP_WINDOW;
    String path;
    Duration defaultMessageTimeToLive = ManagementClientConstants.MAX_DURATION;
    Duration autoDeleteOnIdle = ManagementClientConstants.MAX_DURATION;
    String userMetadata = null;
    long maxSizeInMB = 1024L;
    boolean requiresDuplicateDetection = false;
    boolean enableBatchedOperations = true;
    boolean enablePartitioning = false;
    boolean supportOrdering = false;
    EntityStatus status = EntityStatus.Active;
    List<AuthorizationRule> authorizationRules = null;
    boolean isAnonymousAccessible = false;
    boolean filterMessagesBeforePublishing = false;
    String forwardTo = null;
    boolean enableExpress = false;
    boolean enableSubscriptionPartitioning = false;

    public TopicDescription(String path) {
        this.setPath(path);
    }

    public String getPath() {
        return this.path;
    }

    private void setPath(String path) {
        EntityNameHelper.checkValidTopicName(path);
        this.path = path;
    }

    public long getMaxSizeInMB() {
        return this.maxSizeInMB;
    }

    public void setMaxSizeInMB(long maxSize) {
        this.maxSizeInMB = maxSize;
    }

    public boolean isRequiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public void setRequiresDuplicateDetection(boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (defaultMessageTimeToLive == null || defaultMessageTimeToLive.compareTo(ManagementClientConstants.MIN_ALLOWED_TTL) < 0 || defaultMessageTimeToLive.compareTo(ManagementClientConstants.MAX_ALLOWED_TTL) > 0) {
            throw new IllegalArgumentException(String.format("The value must be between %s and %s.", ManagementClientConstants.MAX_ALLOWED_TTL, ManagementClientConstants.MIN_ALLOWED_TTL));
        }
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (autoDeleteOnIdle == null || autoDeleteOnIdle.compareTo(ManagementClientConstants.MIN_ALLOWED_AUTODELETE_DURATION) < 0) {
            throw new IllegalArgumentException(String.format("The value must be greater than %s.", ManagementClientConstants.MIN_ALLOWED_AUTODELETE_DURATION));
        }
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        if (this.autoDeleteOnIdle.compareTo(ManagementClientConstants.MAX_DURATION) > 0) {
            this.autoDeleteOnIdle = ManagementClientConstants.MAX_DURATION;
        }
    }

    public Duration getDuplicationDetectionHistoryTimeWindow() {
        return this.duplicationDetectionHistoryTimeWindow;
    }

    public void setDuplicationDetectionHistoryTimeWindow(Duration duplicationDetectionHistoryTimeWindow) {
        if (duplicationDetectionHistoryTimeWindow == null || duplicationDetectionHistoryTimeWindow.compareTo(ManagementClientConstants.MIN_DUPLICATE_HISTORY_DURATION) < 0 || duplicationDetectionHistoryTimeWindow.compareTo(ManagementClientConstants.MAX_DUPLICATE_HISTORY_DURATION) > 0) {
            throw new IllegalArgumentException(String.format("The value must be between %s and %s.", ManagementClientConstants.MIN_DUPLICATE_HISTORY_DURATION, ManagementClientConstants.MAX_DUPLICATE_HISTORY_DURATION));
        }
        this.duplicationDetectionHistoryTimeWindow = duplicationDetectionHistoryTimeWindow;
        if (this.duplicationDetectionHistoryTimeWindow.compareTo(ManagementClientConstants.MAX_DURATION) > 0) {
            this.duplicationDetectionHistoryTimeWindow = ManagementClientConstants.MAX_DURATION;
        }
    }

    public boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public void setEnableBatchedOperations(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public EntityStatus getEntityStatus() {
        return this.status;
    }

    public void setEntityStatus(EntityStatus status) {
        this.status = status;
    }

    public boolean isEnablePartitioning() {
        return this.enablePartitioning;
    }

    public void setEnablePartitioning(boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
    }

    public boolean isSupportOrdering() {
        return this.supportOrdering;
    }

    public void setSupportOrdering(boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(String userMetadata) {
        if (userMetadata == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        if (userMetadata.length() > 1024) {
            throw new IllegalArgumentException("Length cannot cross 1024 characters");
        }
        this.userMetadata = userMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicDescription)) {
            return false;
        }
        TopicDescription other = (TopicDescription)o;
        return this.path.equalsIgnoreCase(other.path) && this.autoDeleteOnIdle.equals(other.autoDeleteOnIdle) && this.defaultMessageTimeToLive.equals(other.defaultMessageTimeToLive) && (!this.requiresDuplicateDetection || this.duplicationDetectionHistoryTimeWindow.equals(other.duplicationDetectionHistoryTimeWindow)) && this.enableBatchedOperations == other.enableBatchedOperations && this.enablePartitioning == other.enablePartitioning && this.maxSizeInMB == other.maxSizeInMB && this.requiresDuplicateDetection == other.requiresDuplicateDetection && this.supportOrdering == other.supportOrdering && this.status.equals((Object)other.status) && (this.userMetadata == null ? other.userMetadata == null : this.userMetadata.equals(other.userMetadata)) && AuthorizationRuleSerializer.equals(this.authorizationRules, other.authorizationRules) && this.forwardTo == null ? other.forwardTo == null : this.forwardTo.equalsIgnoreCase(other.forwardTo) && this.enableExpress == other.enableExpress && this.enableSubscriptionPartitioning == other.enableSubscriptionPartitioning && this.isAnonymousAccessible == other.isAnonymousAccessible && this.filterMessagesBeforePublishing == other.filterMessagesBeforePublishing;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

