/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class EntityNameHelper {
    private static final String PATH_DELIMITER = "/";
    private static final String SUBSCRIPTIONS_SUB_PATH = "Subscriptions";
    private static final String RULES_SUB_PATH = "Rules";
    private static final String SUB_QUEUE_PREFIX = "$";
    private static final String DEAD_LETTER_QUEUE_SUFFIX = "DeadLetterQueue";
    private static final String DEAD_LETTER_QUEUE_NAME = "$DeadLetterQueue";
    private static final String TRANSFER = "Transfer";
    private static final String TRANSFER_DEAD_LETTER_QUEUE_NAME = "$Transfer/$DeadLetterQueue";

    public static String formatDeadLetterPath(String entityPath) {
        return EntityNameHelper.formatSubQueuePath(entityPath, DEAD_LETTER_QUEUE_NAME);
    }

    public static String formatSubscriptionPath(String topicPath, String subscriptionName) {
        return String.join((CharSequence)PATH_DELIMITER, topicPath, SUBSCRIPTIONS_SUB_PATH, subscriptionName);
    }

    public static String formatRulePath(String topicPath, String subscriptionName, String ruleName) {
        return String.join((CharSequence)PATH_DELIMITER, topicPath, SUBSCRIPTIONS_SUB_PATH, subscriptionName, RULES_SUB_PATH, ruleName);
    }

    public static String formatTransferDeadLetterPath(String entityPath) {
        return String.join((CharSequence)PATH_DELIMITER, entityPath, TRANSFER_DEAD_LETTER_QUEUE_NAME);
    }

    static String formatSubQueuePath(String entityPath, String subQueueName) {
        return entityPath + PATH_DELIMITER + subQueueName;
    }

    static void checkValidQueueName(String queueName) {
        EntityNameHelper.checkValidEntityName(queueName, 260, true);
    }

    static void checkValidTopicName(String topicName) {
        EntityNameHelper.checkValidEntityName(topicName, 260, true);
    }

    static void checkValidSubscriptionName(String subscriptionName) {
        EntityNameHelper.checkValidEntityName(subscriptionName, 50, false);
    }

    static void checkValidRuleName(String ruleName) {
        EntityNameHelper.checkValidEntityName(ruleName, 50, false);
    }

    static String normalizeForwardToAddress(String forwardTo, URI baseAddress) {
        try {
            new URL(forwardTo);
            return forwardTo;
        }
        catch (MalformedURLException e) {
            return baseAddress.resolve(forwardTo).toString();
        }
    }

    private static void checkValidEntityName(String entityName, int maxEntityNameLength, boolean allowSeparator) {
        if (entityName == null || entityName.isEmpty()) {
            throw new IllegalArgumentException("Entity name cannot be null");
        }
        String tempName = entityName.replace('\\', '/');
        if (tempName.length() > maxEntityNameLength) {
            throw new IllegalArgumentException("Entity path " + entityName + " exceeds the " + maxEntityNameLength + " character limit");
        }
        if (tempName.startsWith(PATH_DELIMITER) || tempName.endsWith(PATH_DELIMITER)) {
            throw new IllegalArgumentException("The entity name cannot contain '/' as prefix or suffix.");
        }
        if (!allowSeparator && tempName.contains(PATH_DELIMITER)) {
            throw new IllegalArgumentException("The entity name contains an invalid character '/'");
        }
        for (char key : ManagementClientConstants.INVALID_ENTITY_PATH_CHARACTERS) {
            if (entityName.indexOf(key) < 0) continue;
            throw new IllegalArgumentException(entityName + " contains character '" + key + "' which is not allowedbecause it is reserved in the Uri scheme.");
        }
    }
}

